/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.ops4j.pax.web.service.spi.WebListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebEventDispatcher
implements WebListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebEventDispatcher.class);
    private final BundleContext bundleContext;
    private final ScheduledExecutorService executors;
    private EventAdmin eventAdminService;
    private LogService logService;
    private final ServiceTracker<WebListener, WebListener> webListenerTracker;
    private final Set<WebListener> listeners = new CopyOnWriteArraySet<WebListener>();
    private final Map<Bundle, WebEvent> states = new ConcurrentHashMap<Bundle, WebEvent>();

    public WebEventDispatcher(final BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle Context");
        this.bundleContext = bundleContext;
        this.executors = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("WebEventExecutor: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.webListenerTracker = new ServiceTracker(bundleContext, WebListener.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<WebListener, WebListener>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WebListener addingService(ServiceReference<WebListener> reference) {
                WebListener listener = (WebListener)bundleContext.getService(reference);
                Set set = WebEventDispatcher.this.listeners;
                synchronized (set) {
                    WebEventDispatcher.this.sendInitialEvents(listener);
                    WebEventDispatcher.this.listeners.add(listener);
                }
                return listener;
            }

            public void modifiedService(ServiceReference<WebListener> reference, WebListener service) {
            }

            public void removedService(ServiceReference<WebListener> reference, WebListener service) {
                WebEventDispatcher.this.listeners.remove(service);
                bundleContext.ungetService(reference);
            }
        });
        this.webListenerTracker.open();
    }

    void destroy() {
        this.executors.shutdown();
        try {
            this.executors.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.webListenerTracker.close();
        this.eventAdminService = null;
    }

    private void sendInitialEvents(WebListener listener) {
        for (Map.Entry<Bundle, WebEvent> entry : this.states.entrySet()) {
            try {
                this.callListener(listener, new WebEvent(entry.getValue(), true));
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    public void webEvent(WebApp webApp, int type) {
        this.webEvent(webApp, type, (Throwable)null);
    }

    public void webEvent(WebApp webApp, int type, Throwable t) {
        this.webEvent(new WebEvent(type, "/" + webApp.getContextName(), webApp.getBundle(), this.bundleContext.getBundle(), t));
    }

    public void webEvent(WebApp webApp, int type, Collection<Long> ids) {
        this.webEvent(new WebEvent(type, "/" + webApp.getContextName(), webApp.getBundle(), this.bundleContext.getBundle(), ids));
    }

    public void webEvent(WebApp webApp, int type, HttpService httpService) {
        this.webEvent(new WebEvent(type, "/" + webApp.getContextName(), webApp.getBundle(), this.bundleContext.getBundle(), httpService, webApp.getHttpContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webEvent(final WebEvent webEvent) {
        String topic;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending web event " + webEvent + " for bundle " + webEvent.getBundle().getSymbolicName());
        }
        Set<WebListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(webEvent);
            this.states.put(webEvent.getBundle(), webEvent);
        }
        switch (webEvent.getType()) {
            case 1: {
                topic = WebEvent.WebTopic.DEPLOYING.toString();
                break;
            }
            case 2: {
                topic = WebEvent.WebTopic.DEPLOYED.toString();
                break;
            }
            case 3: {
                topic = WebEvent.WebTopic.UNDEPLOYING.toString();
                break;
            }
            case 4: {
                topic = WebEvent.WebTopic.UNDEPLOYED.toString();
                break;
            }
            case 5: {
                topic = WebEvent.WebTopic.FAILED.toString();
                break;
            }
            case 6: {
                topic = WebEvent.WebTopic.FAILED.toString();
                break;
            }
            default: {
                topic = WebEvent.WebTopic.FAILED.toString();
            }
        }
        if (this.eventAdminService != null) {
            try {
                this.executors.submit(new Runnable(){

                    @Override
                    public void run() {
                        Hashtable<String, Object> properties = new Hashtable<String, Object>();
                        ((Dictionary)properties).put("bundle.symbolicName", webEvent.getBundle().getSymbolicName());
                        ((Dictionary)properties).put("bundle.id", webEvent.getBundle().getBundleId());
                        ((Dictionary)properties).put("bundle", webEvent.getBundle());
                        Object bundleVersionObject = webEvent.getBundle().getHeaders().get("Bundle-Version");
                        Version bundleVersion = bundleVersionObject instanceof Version ? (Version)bundleVersionObject : (bundleVersionObject instanceof String ? new Version((String)bundleVersionObject) : new Version("0.0.0"));
                        ((Dictionary)properties).put("bundle.version", bundleVersion);
                        ((Dictionary)properties).put("context.path", webEvent.getContextPath());
                        ((Dictionary)properties).put("timestamp", webEvent.getTimestamp());
                        ((Dictionary)properties).put("extender.bundle", webEvent.getExtenderBundle());
                        ((Dictionary)properties).put("extender.bundle.id", webEvent.getExtenderBundle().getBundleId());
                        ((Dictionary)properties).put("extender.bundle.symbolicName", webEvent.getExtenderBundle().getSymbolicName());
                        Object extenderBundleVersionObject = webEvent.getExtenderBundle().getHeaders().get("Bundle-Version");
                        Version extenderVersion = extenderBundleVersionObject instanceof Version ? (Version)extenderBundleVersionObject : (extenderBundleVersionObject instanceof String ? new Version((String)extenderBundleVersionObject) : new Version("0.0.0"));
                        ((Dictionary)properties).put("extender.bundle.version", extenderVersion);
                        if (webEvent.getCause() != null) {
                            ((Dictionary)properties).put("exception", webEvent.getCause());
                        }
                        if (webEvent.getCollisionIds() != null) {
                            ((Dictionary)properties).put("collision", webEvent.getContextPath());
                            ((Dictionary)properties).put("collision.bundles", webEvent.getCollisionIds());
                        }
                        Event event = new Event(topic, properties);
                        EventAdmin adminService = WebEventDispatcher.this.getEventAdminService();
                        if (adminService != null) {
                            adminService.postEvent(event);
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
            }
        }
        if (this.logService != null) {
            try {
                this.executors.submit(new Runnable(){

                    @Override
                    public void run() {
                        WebEventDispatcher.this.getLogService().log(4, topic);
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
            }
        } else if (webEvent.getCause() != null) {
            LOG.error(webEvent.toString());
        } else {
            LOG.debug(topic);
        }
    }

    private EventAdmin getEventAdminService() {
        return this.eventAdminService;
    }

    private LogService getLogService() {
        return this.logService;
    }

    private void callListeners(WebEvent webEvent) {
        for (WebListener listener : this.listeners) {
            try {
                this.callListener(listener, webEvent);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(final WebListener listener, final WebEvent event) {
        try {
            this.executors.invokeAny(Collections.singleton(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    listener.webEvent(event);
                    return null;
                }
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOG.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOG.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }

    public void setEventAdminService(Object eventService) {
        this.eventAdminService = (EventAdmin)eventService;
    }

    public void setLogService(Object logService) {
        this.logService = (LogService)logService;
    }
}

