/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.ops4j.pax.swissbox.tracker.ReplaceableService;
import org.ops4j.pax.swissbox.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyHolder;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class DefaultWebAppDependencyManager {
    private Map<WebApp, ReplaceableService<HttpService>> trackers = new HashMap<WebApp, ReplaceableService<HttpService>>();

    public synchronized void addWebApp(final WebApp webApp) {
        final BundleContext webAppContext = webApp.getBundle().getBundleContext();
        ReplaceableService<HttpService> tracker = new ReplaceableService<HttpService>(webAppContext, HttpService.class, new ReplaceableServiceListener<HttpService>(){
            private ServiceRegistration<WebAppDependencyHolder> registration;

            @Override
            public void serviceChanged(HttpService oldService, HttpService newService) {
                if (this.registration != null) {
                    this.registration.unregister();
                    this.registration = null;
                }
                if (newService != null) {
                    DefaultWebAppDependencyHolder holder = new DefaultWebAppDependencyHolder(newService);
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("bundle.id", Long.toString(webApp.getBundle().getBundleId()));
                    this.registration = webAppContext.registerService(WebAppDependencyHolder.class, (Object)holder, props);
                }
            }
        });
        this.trackers.put(webApp, tracker);
        tracker.start();
    }

    public synchronized void removeWebApp(WebApp webApp) {
        ReplaceableService<HttpService> tracker = this.trackers.remove(webApp);
        if (tracker != null) {
            tracker.stop();
        }
    }
}

