/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.ops4j.pax.web.extender.war.internal.WarExtenderContext;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEvent;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractExtender {
    public static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final int DEFAULT_POOL_SIZE = 3;
    private WarExtenderContext warExtenderContext;
    private int poolSize = 3;
    private final Map<Bundle, Extension> extensions = new ConcurrentHashMap<Bundle, Extension>();
    private ServiceRegistration<?> managedServiceReg;
    private ExecutorService executors;

    @Override
    protected ExecutorService createExecutor() {
        return null;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        String poolSizeValue = context.getProperty("org.ops4j.pax.web.extender.war.threads");
        if (poolSizeValue != null && !"".equals(poolSizeValue)) {
            try {
                this.poolSize = Integer.parseInt(poolSizeValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LOG.info("Configuring WAR extender thread pool. Pool size = {}", (Object)this.poolSize);
        this.executors = Executors.newScheduledThreadPool(this.poolSize, (ThreadFactory)new NamedThreadFactory("wab-extender"));
        this.setSynchronous(false);
        WebApplicationEvent.setExtenderBundle((Bundle)context.getBundle());
        super.start(context);
    }

    @Override
    protected void doStart() {
        LOG.debug("Starting Pax Web WAR Extender");
        this.warExtenderContext = new WarExtenderContext(this.getBundleContext(), this.getExecutors());
        this.startTracking();
        LOG.debug("Pax Web WAR Extender started");
    }

    @Override
    public synchronized void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    @Override
    protected void doStop() {
        LOG.debug("Stopping Pax Web WAR Extender");
        if (this.managedServiceReg != null) {
            this.managedServiceReg.unregister();
            this.managedServiceReg = null;
        }
        if (this.warExtenderContext != null) {
            this.stopTracking();
            this.warExtenderContext.shutdown();
        }
        LOG.debug("Pax Web WAR Extender stopped");
    }

    @Override
    public synchronized ExecutorService getExecutors() {
        return this.executors;
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) {
        Extension extension = this.warExtenderContext.createExtension(bundle, () -> this.extensions.remove(bundle));
        if (extension != null) {
            this.extensions.put(bundle, extension);
        }
        return extension;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && this.extensions.containsKey(bundle)) {
            super.bundleChanged(event);
        }
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (this.extensions.containsKey(bundle)) {
            super.removedBundle(bundle, event, object);
        }
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        if (LOG.isDebugEnabled()) {
            if (bundle == null) {
                LOG.debug("(no bundle): " + msg);
            } else {
                LOG.debug(bundle.getSymbolicName() + "/" + String.valueOf(bundle.getVersion()) + ": " + msg);
            }
        }
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        if (bundle == null) {
            if (t != null) {
                LOG.warn("(no bundle): " + msg, t);
            } else {
                LOG.warn("(no bundle): " + msg);
            }
        } else if (t != null) {
            LOG.warn(bundle.getSymbolicName() + "/" + String.valueOf(bundle.getVersion()) + ": " + msg, t);
        } else {
            LOG.warn(bundle.getSymbolicName() + "/" + String.valueOf(bundle.getVersion()) + ": " + msg);
        }
    }

    @Override
    protected void error(String msg, Throwable t) {
        if (t != null) {
            LOG.error(msg, t);
        } else {
            LOG.error(msg);
        }
    }
}

