/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.util.Path;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

class WebAppHttpContext
implements HttpContext {
    final Log LOG = LogFactory.getLog(this.getClass());
    final Bundle m_bundle;
    private final HttpContext m_httpContext;
    private final Map<String, String> m_mimeMappings;

    WebAppHttpContext(HttpContext httpContext, Bundle bundle, WebAppMimeMapping[] mimeMappings) {
        NullArgumentException.validateNotNull(httpContext, "http context");
        NullArgumentException.validateNotNull(bundle, "Bundle");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Creating WebAppHttpContext for " + httpContext);
        }
        this.m_httpContext = httpContext;
        this.m_bundle = bundle;
        this.m_mimeMappings = new HashMap<String, String>();
        for (WebAppMimeMapping mimeMapping : mimeMappings) {
            this.m_mimeMappings.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.m_httpContext.handleSecurity(request, response);
    }

    public URL getResource(String name) {
        String normalizedName = Path.normalizeResourcePath(name);
        this.LOG.debug("Searching bundle [" + this.m_bundle + "] for resource [" + name + "], normalized to [" + normalizedName + "]");
        URL url = null;
        if (normalizedName != null && normalizedName.trim().length() > 0) {
            Enumeration e;
            String path = "";
            String file = normalizedName;
            int idx = file.lastIndexOf(47);
            if (idx > 0) {
                path = normalizedName.substring(0, idx);
                file = normalizedName.substring(idx + 1);
            }
            if ((e = this.m_bundle.findEntries(path, file, false)) != null && e.hasMoreElements()) {
                url = (URL)e.nextElement();
            }
        }
        if (url != null) {
            this.LOG.debug("Resource found as url [" + url + "]");
        } else {
            this.LOG.debug("Resource not found");
        }
        return url;
    }

    public String getMimeType(String name) {
        String mimeType = null;
        if (name != null && name.length() > 0 && name.contains(".")) {
            String[] segments = name.split("\\.");
            mimeType = this.m_mimeMappings.get(segments[segments.length - 1]);
        }
        if (mimeType == null) {
            mimeType = this.m_httpContext.getMimeType(name);
        }
        return mimeType;
    }
}

