/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public class TokenCallable
implements Callable<String> {
    private static Logger log = Logger.getLogger(TokenCallable.class);
    private final String userName;
    private final String password;
    private final String scope;
    private final Http http;
    private final Configuration configuration;
    private final ServerConfiguration serverConfiguration;
    private AccessTokenResponse tokenResponse;

    public TokenCallable(String userName, String password, String scope, Http http, Configuration configuration, ServerConfiguration serverConfiguration) {
        this.userName = userName;
        this.password = password;
        this.scope = scope;
        this.http = http;
        this.configuration = configuration;
        this.serverConfiguration = serverConfiguration;
    }

    public TokenCallable(String userName, String password, Http http, Configuration configuration, ServerConfiguration serverConfiguration) {
        this(userName, password, null, http, configuration, serverConfiguration);
    }

    public TokenCallable(Http http, Configuration configuration, ServerConfiguration serverConfiguration) {
        this(null, null, http, configuration, serverConfiguration);
    }

    @Override
    public String call() {
        if (this.tokenResponse == null) {
            this.tokenResponse = this.obtainTokens();
        }
        try {
            String rawAccessToken = this.tokenResponse.getToken();
            AccessToken accessToken = JsonSerialization.readValue(new JWSInput(rawAccessToken).getContent(), AccessToken.class);
            if (accessToken.isActive() && this.isTokenTimeToLiveSufficient(accessToken)) {
                return rawAccessToken;
            }
            log.debug((Object)"Access token is expired.");
        }
        catch (Exception cause) {
            this.clearTokens();
            throw new RuntimeException("Failed to parse access token", cause);
        }
        this.tokenResponse = this.tryRefreshToken();
        return this.tokenResponse.getToken();
    }

    private AccessTokenResponse tryRefreshToken() {
        String rawRefreshToken = this.tokenResponse.getRefreshToken();
        if (rawRefreshToken == null) {
            log.debug((Object)"Refresh token not found, obtaining new tokens");
            return this.obtainTokens();
        }
        try {
            RefreshToken refreshToken = JsonSerialization.readValue(new JWSInput(rawRefreshToken).getContent(), RefreshToken.class);
            if (!refreshToken.isActive() || !this.isTokenTimeToLiveSufficient(refreshToken)) {
                log.debug((Object)"Refresh token is expired.");
                return this.obtainTokens();
            }
        }
        catch (Exception cause) {
            this.clearTokens();
            throw new RuntimeException("Failed to parse refresh token", cause);
        }
        return this.refreshToken(rawRefreshToken);
    }

    public boolean isTokenTimeToLiveSufficient(AccessToken token) {
        return token != null && token.getExpiration() - this.getConfiguration().getTokenMinimumTimeToLive() > Time.currentTime();
    }

    AccessTokenResponse clientCredentialsGrant() {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().response().json(AccessTokenResponse.class).execute();
    }

    AccessTokenResponse resourceOwnerPasswordGrant(String userName, String password) {
        return this.resourceOwnerPasswordGrant(userName, password, null);
    }

    AccessTokenResponse resourceOwnerPasswordGrant(String userName, String password, String scope) {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().oauth2ResourceOwnerPassword(userName, password, scope).response().json(AccessTokenResponse.class).execute();
    }

    private AccessTokenResponse refreshToken(String rawRefreshToken) {
        log.debug((Object)"Refreshing tokens");
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().form().param("grant_type", "refresh_token").param("refresh_token", rawRefreshToken).response().json(AccessTokenResponse.class).execute();
    }

    private AccessTokenResponse obtainTokens() {
        if (this.userName == null || this.password == null) {
            return this.clientCredentialsGrant();
        }
        if (this.scope != null) {
            return this.resourceOwnerPasswordGrant(this.userName, this.password, this.scope);
        }
        return this.resourceOwnerPasswordGrant(this.userName, this.password);
    }

    Http getHttp() {
        return this.http;
    }

    protected boolean isRetry() {
        return true;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    void clearTokens() {
        this.tokenResponse = null;
    }
}

