/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.pep;

import java.io.InputStream;
import java.util.List;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.representations.AccessToken;

public class HttpAuthzRequest
implements HttpRequest {
    private final TokenPrincipal tokenPrincipal;
    private final OIDCHttpFacade oidcFacade;

    public HttpAuthzRequest(final OIDCHttpFacade oidcFacade) {
        this.oidcFacade = oidcFacade;
        this.tokenPrincipal = new TokenPrincipal(){

            @Override
            public String getRawToken() {
                KeycloakSecurityContext securityContext = oidcFacade.getSecurityContext();
                if (securityContext == null) {
                    return null;
                }
                return oidcFacade.getSecurityContext().getTokenString();
            }

            @Override
            public AccessToken getToken() {
                KeycloakSecurityContext securityContext = oidcFacade.getSecurityContext();
                if (securityContext == null) {
                    return null;
                }
                return securityContext.getToken();
            }
        };
    }

    @Override
    public String getRelativePath() {
        return this.oidcFacade.getRequest().getRelativePath();
    }

    @Override
    public String getMethod() {
        return this.oidcFacade.getRequest().getMethod();
    }

    @Override
    public String getURI() {
        return this.oidcFacade.getRequest().getURI();
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.oidcFacade.getRequest().getHeaders(name);
    }

    @Override
    public String getFirstParam(String name) {
        String queryParamValue = this.oidcFacade.getRequest().getQueryParamValue(name);
        if (queryParamValue != null) {
            return queryParamValue;
        }
        return this.oidcFacade.getRequest().getFirstParam(name);
    }

    @Override
    public String getCookieValue(String name) {
        HttpFacade.Cookie cookie = this.oidcFacade.getRequest().getCookie(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public String getRemoteAddr() {
        return this.oidcFacade.getRequest().getRemoteAddr();
    }

    @Override
    public boolean isSecure() {
        return this.oidcFacade.getRequest().isSecure();
    }

    @Override
    public String getHeader(String name) {
        return this.oidcFacade.getRequest().getHeader(name);
    }

    @Override
    public InputStream getInputStream(boolean buffered) {
        return this.oidcFacade.getRequest().getInputStream(buffered);
    }

    @Override
    public TokenPrincipal getPrincipal() {
        return this.tokenPrincipal;
    }
}

