/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProviderUtils;
import org.keycloak.representations.AccessToken;

public class AdapterUtils {
    private static Logger log = Logger.getLogger(AdapterUtils.class);

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public static Set<String> getRolesFromSecurityContext(RefreshableKeycloakSecurityContext session) {
        AccessToken.Access access;
        Set<String> roles = null;
        AccessToken accessToken = session.getToken();
        if (session.getDeployment().isUseResourceRoleMappings()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"useResourceRoleMappings");
            }
            if ((access = accessToken.getResourceAccess(session.getDeployment().getResourceName())) != null) {
                roles = access.getRoles();
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"use realm role mappings");
            }
            if ((access = accessToken.getRealmAccess()) != null) {
                roles = access.getRoles();
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting roles: ");
            for (String role : roles) {
                log.trace((Object)("   role: " + role));
            }
        }
        return roles;
    }

    public static String getPrincipalName(KeycloakDeployment deployment, AccessToken token) {
        String attr = "sub";
        if (deployment.getPrincipalAttribute() != null) {
            attr = deployment.getPrincipalAttribute();
        }
        String name = null;
        if ("sub".equals(attr)) {
            name = token.getSubject();
        } else if ("email".equals(attr)) {
            name = token.getEmail();
        } else if ("preferred_username".equals(attr)) {
            name = token.getPreferredUsername();
        } else if ("name".equals(attr)) {
            name = token.getName();
        } else if ("given_name".equals(attr)) {
            name = token.getGivenName();
        } else if ("family_name".equals(attr)) {
            name = token.getFamilyName();
        } else if ("nickname".equals(attr)) {
            name = token.getNickName();
        }
        if (name == null) {
            name = token.getSubject();
        }
        return name;
    }

    public static KeycloakPrincipal<RefreshableKeycloakSecurityContext> createPrincipal(KeycloakDeployment deployment, RefreshableKeycloakSecurityContext securityContext) {
        return new KeycloakPrincipal<RefreshableKeycloakSecurityContext>(AdapterUtils.getPrincipalName(deployment, securityContext.getToken()), securityContext);
    }

    public static void setClientCredentials(KeycloakDeployment deployment, HttpPost post, List<NameValuePair> formparams) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        ClientCredentialsProviderUtils.setClientCredentials(deployment.getAdapterConfig(), deployment.getClientAuthenticator(), reqHeaders, reqParams);
        for (Map.Entry header : reqHeaders.entrySet()) {
            post.setHeader((String)header.getKey(), (String)header.getValue());
        }
        for (Map.Entry param : reqParams.entrySet()) {
            formparams.add((NameValuePair)new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
    }
}

