/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.client.authentication;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class ClientCredentialsProviderUtils {
    private static Logger logger = Logger.getLogger(ClientCredentialsProviderUtils.class);

    public static ClientCredentialsProvider bootstrapClientAuthenticator(AdapterConfig deployment) {
        String authenticatorId;
        String clientId = deployment.getResource();
        Map<String, Object> clientCredentials = deployment.getCredentials();
        if (clientCredentials == null || clientCredentials.isEmpty()) {
            authenticatorId = "secret";
        } else {
            authenticatorId = (String)clientCredentials.get("provider");
            if (authenticatorId == null) {
                if (clientCredentials.size() == 1) {
                    authenticatorId = clientCredentials.keySet().iterator().next();
                } else {
                    throw new RuntimeException("Can't identify clientAuthenticator from the configuration of client '" + clientId + "' . Check your adapter configurations");
                }
            }
        }
        logger.debugf("Using provider '%s' for authentication of client '%s'", (Object)authenticatorId, (Object)clientId);
        HashMap<String, ClientCredentialsProvider> authenticators = new HashMap<String, ClientCredentialsProvider>();
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, ClientCredentialsProviderUtils.class.getClassLoader());
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, Thread.currentThread().getContextClassLoader());
        ClientCredentialsProvider authenticator = (ClientCredentialsProvider)authenticators.get(authenticatorId);
        if (authenticator == null) {
            throw new RuntimeException("Couldn't find ClientCredentialsProvider implementation class with id: " + authenticatorId + ". Loaded authentication providers: " + authenticators.keySet());
        }
        Object config = clientCredentials == null ? null : clientCredentials.get(authenticatorId);
        authenticator.init(deployment, config);
        return authenticator;
    }

    public static void loadAuthenticators(Map<String, ClientCredentialsProvider> authenticators, ClassLoader classLoader) {
        Iterator<ClientCredentialsProvider> iterator = ServiceLoader.load(ClientCredentialsProvider.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                ClientCredentialsProvider authenticator = iterator.next();
                logger.debugf("Loaded clientCredentialsProvider %s", (Object)authenticator.getId());
                authenticators.put(authenticator.getId(), authenticator);
            }
            catch (ServiceConfigurationError e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to load clientCredentialsProvider with classloader: " + classLoader), (Throwable)e);
            }
        }
    }

    public static void setClientCredentials(AdapterConfig deployment, ClientCredentialsProvider authenticator, Map<String, String> requestHeaders, Map<String, String> formparams) {
        authenticator.setClientCredentials(deployment, requestHeaders, formparams);
    }
}

