/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.authorization.client.util.HttpMethod;
import org.keycloak.authorization.client.util.HttpResponseProcessor;
import org.keycloak.util.JsonSerialization;

public class HttpMethodResponse<R> {
    private final HttpMethod<R> method;

    public HttpMethodResponse(HttpMethod method) {
        this.method = method;
    }

    public R execute() {
        return this.method.execute(new HttpResponseProcessor<R>(){

            @Override
            public R process(byte[] entity) {
                return null;
            }
        });
    }

    public HttpMethodResponse<R> json(final Class<R> responseType) {
        return new HttpMethodResponse<R>(this.method){

            @Override
            public R execute() {
                return HttpMethodResponse.this.method.execute(new HttpResponseProcessor<R>(){

                    @Override
                    public R process(byte[] entity) {
                        try {
                            return JsonSerialization.readValue(entity, responseType);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error parsing JSON response.", e);
                        }
                    }
                });
            }
        };
    }

    public HttpMethodResponse<R> json(final TypeReference responseType) {
        return new HttpMethodResponse<R>(this.method){

            @Override
            public R execute() {
                return HttpMethodResponse.this.method.execute(new HttpResponseProcessor<R>(){

                    @Override
                    public R process(byte[] entity) {
                        try {
                            return JsonSerialization.readValue((InputStream)new ByteArrayInputStream(entity), responseType);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error parsing JSON response.", e);
                        }
                    }
                });
            }
        };
    }
}

