/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.CapabilityImpl;
import aQute.bnd.osgi.resource.DeferredValueEntry;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.RequirementImpl;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.VersionRange;
import aQute.lib.converter.Converter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class CapReqBuilder {
    private static final String REQ_ALIAS_IDENTITY = "bnd.identity";
    private static final String REQ_ALIAS_IDENTITY_NAME_ATTRIB = "id";
    private static final String REQ_ALIAS_IDENTITY_VERSION_ATTRIB = "version";
    private static final String REQ_ALIAS_LITERAL = "bnd.literal";
    private static final String REQ_ALIAS_LITERAL_ATTRIB = "bnd.literal";
    private final String namespace;
    private Resource resource;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> directives = new HashMap<String, String>();

    public CapReqBuilder(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public CapReqBuilder(String namespace, Attrs attrs) {
        this(namespace);
        this.addAttributesOrDirectives(attrs);
    }

    public CapReqBuilder(Resource resource, String namespace) {
        this(namespace);
        this.setResource(resource);
    }

    public static CapReqBuilder clone(Capability capability) {
        return new CapReqBuilder(capability.getNamespace()).from(capability);
    }

    public static CapReqBuilder clone(Requirement requirement) {
        return new CapReqBuilder(requirement.getNamespace()).from(requirement);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Resource getResource() {
        return this.resource;
    }

    public CapReqBuilder setResource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public CapReqBuilder addAttribute(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (value.getClass().isArray()) {
            try {
                value = Converter.cnv(List.class, value);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }
        if (this.isVersion(value, aQute.bnd.version.Version.class) || name.equals(ResourceUtils.getVersionAttributeForNamespace(this.getNamespace()))) {
            value = this.toVersions(value);
        }
        this.attributes.put(name, value);
        return this;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public CapReqBuilder removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public boolean isVersion(Object value) {
        return this.isVersion(value, Version.class);
    }

    private boolean isVersion(Object value, Class<?> versionClass) {
        if (versionClass.isInstance(value)) {
            return true;
        }
        if (value instanceof Collection) {
            Collection v = (Collection)value;
            if (v.isEmpty()) {
                return false;
            }
            return this.isVersion(v.iterator().next(), versionClass);
        }
        if (value.getClass().isArray()) {
            if (versionClass.isAssignableFrom(value.getClass().getComponentType())) {
                return true;
            }
            if (Array.getLength(value) == 0) {
                return false;
            }
            return this.isVersion(Array.get(value, 0), versionClass);
        }
        return false;
    }

    public CapReqBuilder addAttributes(Map<? extends String, ? extends Object> attributes) {
        for (Map.Entry<? extends String, ? extends Object> entry : attributes.entrySet()) {
            if (entry instanceof DeferredValueEntry) {
                DeferredValueEntry deferred = (DeferredValueEntry)entry;
                this.addAttribute((String)deferred.getKey(), deferred.getDeferredValue());
                continue;
            }
            this.addAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public CapReqBuilder addDirective(String name, String value) {
        if (value == null) {
            return this;
        }
        this.directives.put(ResourceUtils.stripDirective(name), value);
        return this;
    }

    public boolean hasDirective(String name) {
        return this.directives.containsKey(ResourceUtils.stripDirective(name));
    }

    public CapReqBuilder removeDirective(String name) {
        this.directives.remove(ResourceUtils.stripDirective(name));
        return this;
    }

    public CapReqBuilder addDirectives(Attrs directives) {
        directives.stream().mapKey(Attrs::toDirective).filterKey(Objects::nonNull).forEachOrdered(this::addDirective);
        return this;
    }

    public CapReqBuilder addDirectives(Map<String, String> directives) {
        directives.forEach(this::addDirective);
        return this;
    }

    public Capability buildCapability() {
        if (this.resource == null) {
            throw new IllegalStateException("Cannot build Capability with null Resource.");
        }
        return new CapabilityImpl(this.namespace, this.resource, this.directives, this.attributes);
    }

    public Capability buildSyntheticCapability() {
        return new CapabilityImpl(this.namespace, null, this.directives, this.attributes);
    }

    public Requirement buildRequirement() {
        if (this.resource == null) {
            throw new IllegalStateException("Cannot build Requirement with null Resource. use buildSyntheticRequirement");
        }
        return new RequirementImpl(this.namespace, this.resource, this.directives, this.attributes);
    }

    public Requirement buildSyntheticRequirement() {
        return new RequirementImpl(this.namespace, null, this.directives, this.attributes);
    }

    public static CapReqBuilder createPackageRequirement(String name, String versionRange) {
        return CapReqBuilder.createPackageRequirement(name, null, versionRange);
    }

    public static RequirementBuilder createPackageRequirement(String name, Attrs attrs, String versionRange) {
        RequirementBuilder builder = new RequirementBuilder("osgi.wiring.package");
        if (attrs != null) {
            builder.addDirectives(attrs);
            if (versionRange == null) {
                versionRange = attrs.get(REQ_ALIAS_IDENTITY_VERSION_ATTRIB);
            }
        }
        builder.addFilter("osgi.wiring.package", name, versionRange, attrs);
        builder.addAttribute("osgi.wiring.package", name);
        return builder;
    }

    public static CapabilityBuilder createPackageCapability(String name, Attrs attrs, String bundle_symbolic_name, Version bundle_version) {
        CapabilityBuilder builder = new CapabilityBuilder("osgi.wiring.package");
        if (attrs != null) {
            builder.addAttributesOrDirectives(attrs);
        }
        if (!builder.hasAttribute(REQ_ALIAS_IDENTITY_VERSION_ATTRIB)) {
            builder.addAttribute(REQ_ALIAS_IDENTITY_VERSION_ATTRIB, Version.emptyVersion);
        }
        builder.addAttribute("osgi.wiring.package", Objects.requireNonNull(name));
        if (bundle_symbolic_name != null) {
            builder.addAttribute("bundle-symbolic-name", bundle_symbolic_name);
        }
        if (bundle_version != null) {
            builder.addAttribute("bundle-version", bundle_version);
        }
        return builder;
    }

    public static CapReqBuilder createBundleRequirement(String name, String versionRange) {
        return CapReqBuilder.createSimpleRequirement("osgi.identity", name, versionRange);
    }

    public static CapReqBuilder createSimpleRequirement(String namespace, String name, String versionRange) {
        RequirementBuilder builder = new RequirementBuilder(namespace);
        builder.addFilter(namespace, name, versionRange, null);
        return builder;
    }

    public static RequirementBuilder createServiceRequirement(String name) {
        RequirementBuilder builder = new RequirementBuilder("osgi.service");
        builder.addFilter("objectClass", name, null, null);
        return builder;
    }

    public CharSequence and(Object ... exprs) {
        StringBuilder sb = new StringBuilder().append('(').append('&');
        for (Object expr : exprs) {
            sb.append(this.toFilter(expr));
        }
        return sb.append(')');
    }

    public CharSequence or(Object ... exprs) {
        StringBuilder sb = new StringBuilder().append('(').append('|');
        for (Object expr : exprs) {
            sb.append(this.toFilter(expr));
        }
        return sb.append(')');
    }

    public CharSequence not(Object expr) {
        StringBuilder sb = new StringBuilder().append('(').append('!');
        sb.append(this.toFilter(expr));
        return sb.append(')');
    }

    private CharSequence toFilter(Object expr) {
        if (expr instanceof CharSequence) {
            return (CharSequence)expr;
        }
        if (expr instanceof VersionRange) {
            return ((VersionRange)expr).toFilter();
        }
        return expr.toString();
    }

    public CapReqBuilder filter(CharSequence f) {
        return this.addDirective("filter", f.toString());
    }

    public static List<Requirement> getRequirementsFrom(Parameters rr) {
        return CapReqBuilder.getRequirementsFrom(rr, true);
    }

    public static List<Requirement> getRequirementsFrom(Parameters rr, boolean unalias) {
        List<Requirement> requirements = rr.stream().mapToObj((k, v) -> CapReqBuilder.getRequirementFrom(Processor.removeDuplicateMarker(k), v, unalias)).collect(Collectors.toList());
        return requirements;
    }

    public static Requirement getRequirementFrom(String namespace, Attrs attrs) {
        return CapReqBuilder.getRequirementFrom(namespace, attrs, true);
    }

    public static Requirement getRequirementFrom(String namespace, Attrs attrs, boolean unalias) {
        CapReqBuilder builder = CapReqBuilder.createCapReqBuilder(namespace, attrs);
        Requirement requirement = builder.buildSyntheticRequirement();
        if (unalias) {
            requirement = CapReqBuilder.unalias(requirement);
        }
        return requirement;
    }

    public static CapReqBuilder createCapReqBuilder(String namespace, Attrs attrs) {
        CapReqBuilder builder = new CapReqBuilder(namespace);
        if (attrs != null) {
            builder.addAttributesOrDirectives(attrs);
        }
        return builder;
    }

    public static Requirement unalias(Requirement requirement) {
        if (requirement == null) {
            return null;
        }
        switch (requirement.getNamespace()) {
            case "bnd.literal": {
                String namespace = Objects.toString(requirement.getAttributes().get("bnd.literal"), null);
                if (namespace == null) {
                    throw new IllegalArgumentException(String.format("Requirement alias %s is missing mandatory attribute '%s' of type String", "bnd.literal", "bnd.literal"));
                }
                CapReqBuilder builder = new CapReqBuilder(namespace).from(requirement).removeAttribute("bnd.literal");
                return builder.buildSyntheticRequirement();
            }
            case "bnd.identity": {
                String name = Objects.toString(requirement.getAttributes().get(REQ_ALIAS_IDENTITY_NAME_ATTRIB), null);
                String versionRange = Objects.toString(requirement.getAttributes().get(REQ_ALIAS_IDENTITY_VERSION_ATTRIB), null);
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Requirement alias '%s' is missing mandatory attribute '%s' of type String", REQ_ALIAS_IDENTITY, REQ_ALIAS_IDENTITY_NAME_ATTRIB));
                }
                CapReqBuilder builder = new CapReqBuilder("osgi.identity").from(requirement).removeAttribute(REQ_ALIAS_IDENTITY_NAME_ATTRIB).removeAttribute(REQ_ALIAS_IDENTITY_VERSION_ATTRIB);
                builder.addFilter("osgi.identity", name, versionRange, null);
                return builder.buildSyntheticRequirement();
            }
        }
        return requirement;
    }

    public static List<Capability> getCapabilitiesFrom(Parameters rr) {
        List<Capability> capabilities = rr.stream().mapToObj((k, v) -> CapReqBuilder.getCapabilityFrom(Processor.removeDuplicateMarker(k), v)).collect(Collectors.toList());
        return capabilities;
    }

    public static Capability getCapabilityFrom(String namespace, Attrs attrs) {
        return CapReqBuilder.createCapReqBuilder(namespace, attrs).buildSyntheticCapability();
    }

    public CapReqBuilder from(Capability capability) {
        return this.addAttributes(capability.getAttributes()).addDirectives(capability.getDirectives());
    }

    public CapReqBuilder from(Requirement requirement) {
        return this.addAttributes(requirement.getAttributes()).addDirectives(requirement.getDirectives());
    }

    public static Capability copy(Capability capability, Resource resource) {
        CapReqBuilder clone = CapReqBuilder.clone(capability);
        return resource != null ? clone.setResource(resource).buildCapability() : clone.buildSyntheticCapability();
    }

    public static Requirement copy(Requirement requirement, Resource resource) {
        CapReqBuilder clone = CapReqBuilder.clone(requirement);
        return resource != null ? clone.setResource(resource).buildRequirement() : clone.buildSyntheticRequirement();
    }

    public void addAttributesOrDirectives(Attrs attrs) {
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            String name = e.getKey();
            String directive = Attrs.toDirective(name);
            if (directive != null) {
                this.addDirective(directive, e.getValue());
                continue;
            }
            Object typed = attrs.getTyped(name);
            this.addAttribute(name, typed);
        }
    }

    public CapReqBuilder addAttributes(Attrs attrs) {
        attrs.keySet().stream().filter(Attrs::isAttribute).forEachOrdered(name -> {
            Object typed = attrs.getTyped((String)name);
            this.addAttribute((String)name, typed);
        });
        return this;
    }

    public void addFilter(String nameAttr, String name, String versionRange, Attrs attrs) {
        boolean versionAttrFilterAdded;
        StringBuilder filter = new StringBuilder(256).append('(').append('&').append('(').append(Objects.requireNonNull(nameAttr)).append('=').append(Objects.requireNonNull(name)).append(')');
        int len = filter.length();
        String versionAttrName = Optional.ofNullable(ResourceUtils.getVersionAttributeForNamespace(this.getNamespace())).orElse(REQ_ALIAS_IDENTITY_VERSION_ATTRIB);
        CapReqBuilder.appendFilterVersionRange(filter, versionAttrName, versionRange);
        boolean bl = versionAttrFilterAdded = filter.length() > len;
        if (this.getNamespace().startsWith("osgi.wiring.")) {
            MapStream<String, String> attrStream = MapStream.ofNullable(attrs).filterKey(Attrs::isAttribute);
            if (versionAttrFilterAdded) {
                attrStream = attrStream.filterKey(attrName -> !attrName.equals(versionAttrName));
            }
            attrStream.sortedByKey().forEachOrdered((attrName, attrValue) -> {
                switch (attrName) {
                    case "version": 
                    case "bundle-version": {
                        CapReqBuilder.appendFilterVersionRange(filter, attrName, attrValue);
                        break;
                    }
                    default: {
                        CapReqBuilder.appendFilterEquals(filter, attrName, attrValue);
                    }
                }
            });
        }
        String value = filter.length() > len ? filter.append(')').toString() : filter.substring(2);
        this.addDirective("filter", value);
    }

    private static void appendFilterEquals(StringBuilder filter, String name, String value) {
        if (value != null) {
            filter.append('(').append(name).append('=');
            CapReqBuilder.escapeFilterValue(filter, value).append(')');
        }
    }

    private static void appendFilterVersionRange(StringBuilder filter, String name, String versionRange) {
        Optional.ofNullable(versionRange).filter(VersionRange::isOSGiVersionRange).map(VersionRange::parseOSGiVersionRange).map(range -> range.toFilter(name)).ifPresent(range -> {
            if (filter.length() > 1 && filter.charAt(1) == '&' && range.length() > 1 && range.charAt(1) == '&') {
                filter.append((CharSequence)range, 2, range.length() - 1);
            } else {
                filter.append((String)range);
            }
        });
    }

    public static String escapeFilterValue(String value) {
        StringBuilder sb;
        int len = value.length();
        return len == (sb = CapReqBuilder.escapeFilterValue(new StringBuilder(len), value)).length() ? value : sb.toString();
    }

    private static StringBuilder escapeFilterValue(StringBuilder sb, String value) {
        int len = value.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public void and(String ... s) {
        StringBuilder filter = new StringBuilder().append('(').append('&');
        String previous = this.directives.get("filter");
        if (previous != null) {
            filter.append(previous);
        }
        for (String subexpr : s) {
            filter.append(subexpr);
        }
        filter.append(')');
        this.addDirective("filter", filter.toString());
    }

    public boolean isPackage() {
        return "osgi.wiring.package".equals(this.getNamespace());
    }

    public boolean isHost() {
        return "osgi.wiring.host".equals(this.getNamespace());
    }

    public boolean isBundle() {
        return "osgi.wiring.bundle".equals(this.getNamespace());
    }

    public boolean isService() {
        return "osgi.service".equals(this.getNamespace());
    }

    public boolean isContract() {
        return "osgi.contract".equals(this.getNamespace());
    }

    public boolean isIdentity() {
        return "osgi.identity".equals(this.getNamespace());
    }

    public boolean isContent() {
        return "osgi.content".equals(this.getNamespace());
    }

    public boolean isEE() {
        return "osgi.ee".equals(this.getNamespace());
    }

    public boolean isExtender() {
        return "osgi.extender".equals(this.getNamespace());
    }

    public Attrs toAttrs() {
        String versionAttrName = Optional.ofNullable(ResourceUtils.getVersionAttributeForNamespace(this.getNamespace())).orElse(REQ_ALIAS_IDENTITY_VERSION_ATTRIB);
        Attrs attrs = new Attrs();
        this.attributes.forEach((key, value) -> attrs.putTyped((String)key, key.equals(versionAttrName) || value instanceof Version ? this.toBndVersions(value) : value));
        this.directives.forEach((key, value) -> attrs.put(key.concat(":"), (String)value));
        return attrs;
    }

    private Object toBndVersions(Object value) {
        if (value instanceof aQute.bnd.version.Version) {
            return value;
        }
        if (value instanceof Version) {
            Version osgiVersion = (Version)value;
            return new aQute.bnd.version.Version(osgiVersion.getMajor(), osgiVersion.getMinor(), osgiVersion.getMicro(), osgiVersion.getQualifier());
        }
        if (value instanceof String) {
            return new aQute.bnd.version.Version((String)value);
        }
        if (value instanceof Number) {
            try {
                return new aQute.bnd.version.Version(((Number)value).intValue());
            }
            catch (Exception e) {
                return value;
            }
        }
        if (value instanceof Collection) {
            Collection v = (Collection)value;
            if (v.isEmpty()) {
                return value;
            }
            if (v.iterator().next() instanceof aQute.bnd.version.Version) {
                return value;
            }
            ArrayList<Object> bnds = new ArrayList<Object>();
            for (Object m : v) {
                bnds.add(this.toBndVersions(m));
            }
            return bnds;
        }
        throw new IllegalArgumentException("cannot convert " + value + " to a bnd Version(s) object as requested");
    }

    private Object toVersions(Object value) {
        if (value instanceof Version) {
            return value;
        }
        if (value instanceof aQute.bnd.version.Version) {
            aQute.bnd.version.Version bndVersion = (aQute.bnd.version.Version)value;
            return new Version(bndVersion.getMajor(), bndVersion.getMinor(), bndVersion.getMicro(), bndVersion.getQualifier());
        }
        if (value instanceof String) {
            try {
                String versionString = (String)value;
                return new Version(versionString.trim());
            }
            catch (Exception e) {
                return value;
            }
        }
        if (value instanceof Number) {
            try {
                return new Version(((Number)value).intValue(), 0, 0);
            }
            catch (Exception e) {
                return value;
            }
        }
        if (value instanceof Collection) {
            Collection v = (Collection)value;
            if (v.isEmpty()) {
                return value;
            }
            if (v.iterator().next() instanceof Version) {
                return value;
            }
            ArrayList<Object> osgis = new ArrayList<Object>();
            for (Object m : v) {
                osgis.add(this.toVersions(m));
            }
            return osgis;
        }
        throw new IllegalArgumentException("cannot convert " + value + " to a org.osgi.framework Version(s) object as requested");
    }

    public static RequirementBuilder createRequirementFromCapability(Capability capability) {
        String namespace = capability.getNamespace();
        RequirementBuilder builder = new RequirementBuilder(namespace);
        String versionAttrName = Optional.ofNullable(ResourceUtils.getVersionAttributeForNamespace(namespace)).orElse(REQ_ALIAS_IDENTITY_VERSION_ATTRIB);
        Map capAttributes = capability.getAttributes();
        StringBuilder filter = new StringBuilder(256);
        if (capAttributes.size() > 1) {
            filter.append('(').append('&');
        }
        capAttributes.forEach((name, v) -> {
            if (v instanceof Version || name.equals(versionAttrName) || namespace.equals("osgi.wiring.package") && name.equals("bundle-version")) {
                CapReqBuilder.appendFilterVersionRange(filter, name, v.toString());
            } else {
                CapReqBuilder.appendFilterEquals(filter, name, v.toString());
            }
        });
        if (capAttributes.size() > 1) {
            filter.append(')');
        }
        builder.filter(filter);
        return builder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('[').append(this.namespace).append(']').append(this.attributes).append(this.directives);
        return sb.toString();
    }
}

