/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.buildtool;

import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;

public class ToolManager
extends Processor {
    final Workspace workspace;
    final BiConsumer<String, Object[]> reporter;

    public ToolManager(Workspace workspace, BiConsumer<String, Object[]> reporter) {
        super(workspace);
        this.reporter = reporter;
        this.use(workspace);
        this.workspace = workspace;
        this.setBase(workspace.getBase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String install(String url, Map<String, String> parameters, boolean force) {
        HttpClient client = this.workspace.getPlugin(HttpClient.class);
        try {
            if (client.isOffline()) {
                return "The workspace is off line";
            }
            URI uri = new URI(url);
            this.progress("URI is %s", uri);
            File file = client.build().maxRedirects(2).useCache().get().go(uri);
            this.progress("Downloaded %s", file);
            try (Jar jar = new Jar(file);){
                Optional<String> properties = jar.getResourceNames(s -> s.endsWith("tool.bnd")).findAny();
                if (!properties.isPresent()) {
                    String string = "cannot find 'tool.bnd' in zip: " + jar.getResources().keySet();
                    return string;
                }
                String toolPath = properties.get();
                String prefix = Strings.stripSuffix(properties.get(), "tool.bnd");
                this.progress("tool path = %s", toolPath);
                UTF8Properties props = new UTF8Properties();
                props.load(jar.getResource(toolPath).openInputStream());
                this.setProperties(props);
                Instructions copyInstructions = new Instructions(this.getMergedParameters("-tool"));
                Iterator<Map.Entry<String, Resource>> iterator = jar.getResources().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Resource> entry = iterator.next();
                    String path = entry.getKey();
                    Resource resource = entry.getValue();
                    if (!path.startsWith(prefix)) {
                        this.progress("not included %s", path);
                        continue;
                    }
                    String newPath = Strings.stripPrefix(path, prefix);
                    Instruction matcher = copyInstructions.matcher(newPath);
                    Attrs attrs = copyInstructions.get(matcher);
                    String actions = newPath;
                    if (attrs.containsKey("skip")) {
                        actions = actions + " skip";
                    } else {
                        File destination = this.getFile(newPath);
                        if (destination.isFile()) {
                            if (!force) {
                                String string = "cannot overwrite " + destination;
                                return string;
                            }
                            actions = actions + " overwrite";
                        }
                        destination.getParentFile().mkdirs();
                        if (attrs.containsKey("macro")) {
                            actions = actions + " macro";
                            String content = IO.collect(resource.openInputStream());
                            content = this.getReplacer().process(content);
                            resource = new EmbeddedResource(content.getBytes(StandardCharsets.UTF_8), 0L);
                        }
                        if (attrs.containsKey("append")) {
                            StringBuilder sb = new StringBuilder(IO.collect(resource.openInputStream()));
                            sb.append("\n\n# Appended by tool manager at ").append(Instant.now()).append("\n\n");
                            for (Map.Entry<String, String> e : parameters.entrySet()) {
                                sb.append(e.getKey()).append(" = ").append(e.getValue()).append("\n");
                            }
                            resource = new EmbeddedResource(sb.toString().getBytes(StandardCharsets.UTF_8), 0L);
                        }
                        IO.copy(resource.openInputStream(), destination);
                        if (attrs.containsKey("exec")) {
                            actions = actions + " exec";
                            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                            permissions.add(PosixFilePermission.OWNER_EXECUTE);
                            permissions.add(PosixFilePermission.OWNER_WRITE);
                            permissions.add(PosixFilePermission.OWNER_READ);
                            Files.setPosixFilePermissions(destination.toPath(), permissions);
                        }
                    }
                    this.progress(actions, new Object[0]);
                }
                return null;
            }
        }
        catch (Exception e) {
            return "failed to install gradle tool: " + e;
        }
    }

    @Override
    public void progress(String format, Object ... args) {
        if (this.reporter != null) {
            this.reporter.accept(format, args);
        }
    }

    @Override
    public String toString() {
        return "ToolManager [workspace=" + this.workspace.getBase() + "]";
    }
}

