/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> distinct(Set<? extends T> first, Iterable<? extends T> second) {
        return new Distinct<Object, Object>(first, second, t -> t, t -> true);
    }

    public static <T, R> Iterable<R> distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper) {
        return new Distinct<T, Object>(first, second, mapper, r -> true);
    }

    public static <T, R> Iterable<R> distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
        return new Distinct<T, R>(first, second, mapper, filter);
    }

    public static <T> Iterable<T> iterable(Enumeration<? extends T> enumeration) {
        return new IterableEnumeration<Object, Object>(enumeration, t -> t, t -> true);
    }

    public static <T, R> Iterable<R> iterable(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper) {
        return new IterableEnumeration<T, Object>(enumeration, mapper, r -> true);
    }

    public static <T, R> Iterable<R> iterable(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
        return new IterableEnumeration<T, R>(enumeration, mapper, filter);
    }

    static final class Distinct<T, R>
    implements Iterable<R> {
        private final Set<? extends T> first;
        private final Iterable<? extends T> second;
        private final Function<? super T, ? extends R> mapper;
        private final Predicate<? super R> filter;

        Distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
            this.mapper = Objects.requireNonNull(mapper);
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            R r;
            Objects.requireNonNull(action);
            for (T t : this.first) {
                r = this.mapper.apply(t);
                if (!this.filter.test(r)) continue;
                action.accept(r);
            }
            for (T t : this.second) {
                r = this.mapper.apply(t);
                if (!this.filter.test(r) || this.first.contains(t)) continue;
                action.accept(r);
            }
        }

        @Override
        public Iterator<R> iterator() {
            return new DistinctIterator();
        }

        @Override
        public Spliterator<R> spliterator() {
            return new DistinctSpliterator();
        }

        final class DistinctIterator
        implements Iterator<R> {
            private final Iterator<? extends T> it1;
            private final Iterator<? extends T> it2;
            private boolean hasNext = false;
            private R next;

            DistinctIterator() {
                this.it1 = Distinct.this.first.iterator();
                this.it2 = Distinct.this.second.iterator();
            }

            @Override
            public boolean hasNext() {
                Object r;
                Object t;
                if (this.hasNext) {
                    return true;
                }
                while (this.it1.hasNext()) {
                    t = this.it1.next();
                    r = Distinct.this.mapper.apply(t);
                    if (!Distinct.this.filter.test(r)) continue;
                    this.next = r;
                    this.hasNext = true;
                    return true;
                }
                while (this.it2.hasNext()) {
                    t = this.it2.next();
                    r = Distinct.this.mapper.apply(t);
                    if (!Distinct.this.filter.test(r) || Distinct.this.first.contains(t)) continue;
                    this.next = r;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public R next() {
                if (this.hasNext()) {
                    Object r = this.next;
                    this.hasNext = false;
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void forEachRemaining(Consumer<? super R> action) {
                Object r;
                Object t;
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    Object r2 = this.next;
                    action.accept(r2);
                    this.hasNext = false;
                }
                while (this.it1.hasNext()) {
                    t = this.it1.next();
                    r = Distinct.this.mapper.apply(t);
                    if (!Distinct.this.filter.test(r)) continue;
                    action.accept(r);
                }
                while (this.it2.hasNext()) {
                    t = this.it2.next();
                    r = Distinct.this.mapper.apply(t);
                    if (!Distinct.this.filter.test(r) || Distinct.this.first.contains(t)) continue;
                    action.accept(r);
                }
            }
        }

        final class DistinctSpliterator
        extends Spliterators.AbstractSpliterator<R>
        implements Consumer<T> {
            private Spliterator<? extends T> it2;
            private Spliterator<? extends T> it1;
            private T t;

            DistinctSpliterator() {
                super(Long.MAX_VALUE, 17);
            }

            private Spliterator<? extends T> first() {
                Spliterator spliterator = this.it1;
                if (spliterator != null) {
                    return spliterator;
                }
                this.it1 = Distinct.this.first.spliterator();
                return this.it1;
            }

            private Spliterator<? extends T> second() {
                Spliterator spliterator = this.it2;
                if (spliterator != null) {
                    return spliterator;
                }
                this.it2 = Distinct.this.second.spliterator();
                return this.it2;
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                Object r;
                Objects.requireNonNull(action);
                Spliterator spliterator = this.first();
                while (spliterator.tryAdvance(this)) {
                    r = Distinct.this.mapper.apply(this.t);
                    if (!Distinct.this.filter.test(r)) continue;
                    action.accept(r);
                    return true;
                }
                spliterator = this.second();
                while (spliterator.tryAdvance(this)) {
                    r = Distinct.this.mapper.apply(this.t);
                    if (!Distinct.this.filter.test(r) || Distinct.this.first.contains(this.t)) continue;
                    action.accept(r);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super R> action) {
                Objects.requireNonNull(action);
                this.first().forEachRemaining((? super T t) -> {
                    Object r = Distinct.this.mapper.apply(t);
                    if (Distinct.this.filter.test(r)) {
                        action.accept((Object)r);
                    }
                });
                this.second().forEachRemaining((? super T t) -> {
                    Object r = Distinct.this.mapper.apply(t);
                    if (Distinct.this.filter.test(r) && !Distinct.this.first.contains(t)) {
                        action.accept((Object)r);
                    }
                });
            }

            @Override
            public long estimateSize() {
                long est = this.first().estimateSize() + this.second().estimateSize();
                if (est < 0L) {
                    return super.estimateSize();
                }
                return est;
            }

            @Override
            public void accept(T t) {
                this.t = t;
            }
        }
    }

    static final class IterableEnumeration<T, R>
    implements Iterable<R> {
        private final Enumeration<? extends T> enumeration;
        private final Function<? super T, ? extends R> mapper;
        private final Predicate<? super R> filter;
        private final AtomicBoolean consume = new AtomicBoolean();

        IterableEnumeration(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
            this.enumeration = enumeration != null ? enumeration : Collections.emptyEnumeration();
            this.mapper = Objects.requireNonNull(mapper);
            this.filter = Objects.requireNonNull(filter);
        }

        private void consume() {
            if (this.consume.compareAndSet(false, true)) {
                return;
            }
            throw new IllegalStateException("enumeration already consumed");
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            Objects.requireNonNull(action);
            this.consume();
            while (this.enumeration.hasMoreElements()) {
                T t = this.enumeration.nextElement();
                R r = this.mapper.apply(t);
                if (!this.filter.test(r)) continue;
                action.accept(r);
            }
        }

        @Override
        public Iterator<R> iterator() {
            this.consume();
            return new EnumerationIterator();
        }

        @Override
        public Spliterator<R> spliterator() {
            this.consume();
            return new EnumerationSpliterator();
        }

        final class EnumerationIterator
        implements Iterator<R> {
            private boolean hasNext = false;
            private R next;

            EnumerationIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (IterableEnumeration.this.enumeration.hasMoreElements()) {
                    Object t = IterableEnumeration.this.enumeration.nextElement();
                    Object r = IterableEnumeration.this.mapper.apply(t);
                    if (!IterableEnumeration.this.filter.test(r)) continue;
                    this.next = r;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public R next() {
                if (this.hasNext()) {
                    Object r = this.next;
                    this.hasNext = false;
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void forEachRemaining(Consumer<? super R> action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    Object r = this.next;
                    action.accept(r);
                    this.hasNext = false;
                }
                while (IterableEnumeration.this.enumeration.hasMoreElements()) {
                    Object t = IterableEnumeration.this.enumeration.nextElement();
                    Object r = IterableEnumeration.this.mapper.apply(t);
                    if (!IterableEnumeration.this.filter.test(r)) continue;
                    action.accept(r);
                }
            }
        }

        final class EnumerationSpliterator
        extends Spliterators.AbstractSpliterator<R> {
            EnumerationSpliterator() {
                super(Long.MAX_VALUE, 16);
            }

            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                Objects.requireNonNull(action);
                while (IterableEnumeration.this.enumeration.hasMoreElements()) {
                    Object t = IterableEnumeration.this.enumeration.nextElement();
                    Object r = IterableEnumeration.this.mapper.apply(t);
                    if (!IterableEnumeration.this.filter.test(r)) continue;
                    action.accept(r);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super R> action) {
                Objects.requireNonNull(action);
                while (IterableEnumeration.this.enumeration.hasMoreElements()) {
                    Object t = IterableEnumeration.this.enumeration.nextElement();
                    Object r = IterableEnumeration.this.mapper.apply(t);
                    if (!IterableEnumeration.this.filter.test(r)) continue;
                    action.accept(r);
                }
            }
        }
    }
}

