/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.DeferredValue;
import aQute.bnd.osgi.resource.DeferredValueMap;
import aQute.bnd.osgi.resource.FilterImpl;
import aQute.bnd.osgi.resource.ResolutionDirective;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceImpl;
import aQute.bnd.stream.MapStream;
import aQute.bnd.unmodifiable.Lists;
import aQute.bnd.unmodifiable.Maps;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.converter.Converter;
import aQute.lib.strings.Strings;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class ResourceUtils {
    public static final Comparator<Requirement> REQUIREMENT_COMPARATOR = (o1, o2) -> {
        String ns2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        String ns1 = o1.getNamespace();
        int compareTo = ns1.compareTo(ns2 = o2.getNamespace());
        if (compareTo != 0) {
            return compareTo;
        }
        String f1 = (String)o1.getDirectives().get("filter");
        String f2 = (String)o2.getDirectives().get("filter");
        return f1.compareTo(f2);
    };
    public static final Comparator<? super Resource> IDENTITY_VERSION_COMPARATOR = (o1, o2) -> {
        String v2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        String v1 = ResourceUtils.getIdentityVersion(o1);
        if (v1 == (v2 = ResourceUtils.getIdentityVersion(o2))) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return new aQute.bnd.version.Version(v1).compareTo(new aQute.bnd.version.Version(v2));
    };
    private static final Comparator<? super Resource> RESOURCE_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof ResourceImpl && o2 instanceof ResourceImpl) {
            return ((ResourceImpl)o1).compareTo((Resource)o2);
        }
        return o1.toString().compareTo(o2.toString());
    };
    public static final Resource DUMMY_RESOURCE = new ResourceBuilder().build();
    public static final String WORKSPACE_NAMESPACE = "bnd.workspace.project";
    private static final Converter cnv = new Converter().hook((Type)((Object)aQute.bnd.version.Version.class), (dest, o) -> ResourceUtils.toVersion(o));
    private static final Pattern ATTR_NAME = Pattern.compile("\\(\\s*([^()=<>~\\s]+)\\s*[=<>~][^)]+\\)");
    private static final Collection<Requirement> all = Lists.of(ResourceUtils.createWildcardRequirement());
    private static final Comparator<Comparable> nullsFirst = Comparator.nullsFirst(Comparator.naturalOrder());

    public static Stream<Capability> capabilityStream(Resource resource, String namespace) {
        return resource.getCapabilities(namespace).stream();
    }

    public static <T extends Capability> Stream<T> capabilityStream(Resource resource, String namespace, Class<T> type) {
        return ResourceUtils.capabilityStream(resource, namespace).map(c -> ResourceUtils.as(c, type));
    }

    public static ContentCapability getContentCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).findFirst().orElse(null);
    }

    public static Optional<URI> getURI(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).findFirst().map(ContentCapability::url);
    }

    public static List<ContentCapability> getContentCapabilities(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).collect(ResourceUtils.toCapabilities());
    }

    public static IdentityCapability getIdentityCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.identity", IdentityCapability.class).findFirst().orElse(null);
    }

    public static BundleId getBundleId(Resource resource) {
        List capabilities;
        BundleCap b = ResourceUtils.getBundleCapability(resource);
        if (b != null && b.osgi_wiring_bundle() != null) {
            return new BundleId(b.osgi_wiring_bundle(), b.bundle_version());
        }
        IdentityCapability identity = ResourceUtils.getIdentityCapability(resource);
        if (identity != null) {
            String bsn = identity.osgi_identity();
            aQute.bnd.version.Version version = identity.version();
            if (version == null) {
                version = aQute.bnd.version.Version.LOWEST;
            }
            if (bsn != null) {
                return new BundleId(bsn, version.toString());
            }
        }
        if ((capabilities = resource.getCapabilities("bnd.info")).isEmpty()) {
            return null;
        }
        Capability cap = (Capability)capabilities.get(0);
        String bsn = (String)cap.getAttributes().get("name");
        aQute.bnd.version.Version version = ResourceUtils.getVersion(cap);
        if (version == null) {
            version = aQute.bnd.version.Version.LOWEST;
        }
        if (bsn == null) {
            return null;
        }
        return new BundleId(bsn, version);
    }

    public static String getIdentityVersion(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.identity", IdentityCapability.class).findFirst().map(c -> c.getAttributes().get("version")).map(Object::toString).orElse(null);
    }

    public static BundleCap getBundleCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.wiring.bundle", BundleCap.class).findFirst().orElse(null);
    }

    public static aQute.bnd.version.Version toVersion(Object v) {
        if (v instanceof aQute.bnd.version.Version) {
            return (aQute.bnd.version.Version)v;
        }
        if (v instanceof Version) {
            Version o = (Version)v;
            String q = o.getQualifier();
            return q.isEmpty() ? new aQute.bnd.version.Version(o.getMajor(), o.getMinor(), o.getMicro()) : new aQute.bnd.version.Version(o.getMajor(), o.getMinor(), o.getMicro(), q);
        }
        if (v instanceof String && aQute.bnd.version.Version.isVersion((String)v)) {
            return aQute.bnd.version.Version.valueOf((String)v);
        }
        return null;
    }

    public static aQute.bnd.version.Version getVersion(Capability cap) {
        String attr = ResourceUtils.getVersionAttributeForNamespace(cap.getNamespace());
        if (attr == null) {
            return null;
        }
        Object v = cap.getAttributes().get(attr);
        return ResourceUtils.toVersion(v);
    }

    public static URI getURI(Capability contentCapability) {
        Object uriObj = contentCapability.getAttributes().get("url");
        if (uriObj == null) {
            return null;
        }
        if (uriObj instanceof URI) {
            return (URI)uriObj;
        }
        try {
            if (uriObj instanceof URL) {
                return ((URL)uriObj).toURI();
            }
            if (uriObj instanceof String) {
                try {
                    URL url = new URL((String)uriObj);
                    return url.toURI();
                }
                catch (MalformedURLException url) {
                    File f = new File((String)uriObj);
                    if (f.isFile()) {
                        return f.toURI();
                    }
                    return new URI((String)uriObj);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Resource content capability has illegal URL attribute", e);
        }
        return null;
    }

    public static String getVersionAttributeForNamespace(String namespace) {
        switch (namespace) {
            case "bnd.library": 
            case "bnd.info": {
                return "version";
            }
            case "osgi.identity": {
                return "version";
            }
            case "osgi.wiring.bundle": 
            case "osgi.wiring.host": {
                return "bundle-version";
            }
            case "osgi.wiring.package": {
                return "version";
            }
            case "osgi.ee": {
                return "version";
            }
            case "osgi.native": {
                return "osgi.native.osversion";
            }
            case "osgi.extender": {
                return "version";
            }
            case "osgi.contract": {
                return "version";
            }
            case "osgi.implementation": {
                return "version";
            }
        }
        return "version";
    }

    public static <T extends Capability> T as(Capability cap, Class<T> type) {
        return (T)((Capability)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (target, method, args) -> {
            Class<?> declaringClass = method.getDeclaringClass();
            if (Capability.class == declaringClass || Object.class == declaringClass) {
                return MethodHandles.publicLookup().unreflect(method).bindTo(cap).invokeWithArguments(args);
            }
            return ResourceUtils.get(method, cap.getAttributes(), cap.getDirectives(), args);
        }));
    }

    public static <T extends Requirement> T as(Requirement req, Class<T> type) {
        return (T)((Requirement)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (target, method, args) -> {
            Class<?> declaringClass = method.getDeclaringClass();
            if (Requirement.class == declaringClass || Object.class == declaringClass) {
                return MethodHandles.publicLookup().unreflect(method).bindTo(req).invokeWithArguments(args);
            }
            return ResourceUtils.get(method, req.getAttributes(), req.getDirectives(), args);
        }));
    }

    private static Object get(Method method, Map<String, Object> attrs, Map<String, String> directives, Object[] args) throws Exception {
        String name = method.getName().replace('_', '.');
        Object value = name.startsWith("$") ? ResourceUtils.getValue(directives, name.substring(1)) : ResourceUtils.getValue(attrs, name);
        if (value == null && args != null && args.length == 1) {
            value = args[0];
        }
        return cnv.convert(method.getGenericReturnType(), value);
    }

    private static Object getValue(Map<String, ?> attrs, String name) {
        Object object = attrs.get(name);
        if (object != null) {
            return object;
        }
        return attrs.get(name.replace('.', '-'));
    }

    public static Set<Resource> getResources(Collection<? extends Capability> providers) {
        if (providers == null || providers.isEmpty()) {
            return Sets.of();
        }
        return ResourceUtils.getResources(providers.stream());
    }

    public static Map<Resource, List<Capability>> getIndexedByResource(Collection<? extends Capability> providers) {
        if (providers == null || providers.isEmpty()) {
            return Maps.of();
        }
        return providers.stream().collect(Collectors.groupingBy(Capability::getResource, ResourceUtils.toCapabilities()));
    }

    private static Set<Resource> getResources(Stream<? extends Capability> providers) {
        return providers.map(Capability::getResource).collect(Collectors.toCollection(() -> new TreeSet<Resource>(RESOURCE_COMPARATOR)));
    }

    public static Requirement createWildcardRequirement() {
        return CapReqBuilder.createSimpleRequirement("osgi.identity", "*", null).buildSyntheticRequirement();
    }

    public static boolean isEffective(Requirement r, Capability c) {
        String capabilityEffective = (String)c.getDirectives().get("effective");
        if (capabilityEffective == null) {
            return true;
        }
        if (capabilityEffective.equals("resolve")) {
            return true;
        }
        String requirementEffective = (String)r.getDirectives().get("effective");
        if (requirementEffective == null) {
            return false;
        }
        return capabilityEffective.equals(requirementEffective);
    }

    public static Predicate<Map<String, Object>> filterPredicate(String filterString) {
        if (filterString == null) {
            return m -> true;
        }
        try {
            FilterImpl filter = FilterImpl.createFilter(filterString);
            return arg_0 -> ((Filter)filter).matches(arg_0);
        }
        catch (InvalidSyntaxException e) {
            return m -> false;
        }
    }

    public static boolean matches(Requirement requirement, Resource resource) {
        return ResourceUtils.capabilityStream(resource, requirement.getNamespace()).anyMatch(ResourceUtils.matcher(requirement));
    }

    public static boolean matches(Requirement requirement, Capability capability) {
        return ResourceUtils.matcher(requirement).test(capability);
    }

    public static Predicate<Capability> matcher(Requirement requirement) {
        return ResourceUtils.matcher(requirement, ResourceUtils::filterPredicate);
    }

    public static Predicate<Capability> matcher(Requirement requirement, Function<String, Predicate<Map<String, Object>>> filter) {
        Predicate<Capability> matcher = capability -> Objects.equals(requirement.getNamespace(), capability.getNamespace()) && ResourceUtils.isEffective(requirement, capability);
        return matcher.and(ResourceUtils.filterMatcher(requirement, filter));
    }

    public static Predicate<Capability> filterMatcher(Requirement requirement) {
        return ResourceUtils.filterMatcher(requirement, ResourceUtils::filterPredicate);
    }

    public static Predicate<Capability> filterMatcher(Requirement requirement, Function<String, Predicate<Map<String, Object>>> filter) {
        String filterDirective = (String)requirement.getDirectives().get("filter");
        Memoize<Predicate<Map<String, Object>>> predicate = Memoize.supplier(filter, filterDirective);
        Predicate<Capability> matcher = capability -> {
            if (filterDirective != null && !((Predicate)predicate.get()).test(capability.getAttributes())) {
                return false;
            }
            if (capability.getNamespace().startsWith("osgi.wiring.")) {
                String mandatoryDirective = (String)capability.getDirectives().get("mandatory");
                if (mandatoryDirective == null) {
                    return true;
                }
                if (filterDirective == null) {
                    return false;
                }
                Set mandatory = Strings.splitAsStream(mandatoryDirective).collect(Collectors.toSet());
                Matcher m = ATTR_NAME.matcher(filterDirective);
                while (m.find()) {
                    String attr = m.group(1);
                    mandatory.remove(attr);
                }
                return mandatory.isEmpty();
            }
            return true;
        };
        return matcher;
    }

    public static String getEffective(Map<String, String> directives) {
        String effective = directives.get("effective");
        if (effective == null) {
            return "resolve";
        }
        return effective;
    }

    public static ResolutionDirective getResolution(Requirement requirement) {
        String resolution = (String)requirement.getDirectives().get("resolution");
        if (resolution == null || resolution.equals("mandatory")) {
            return ResolutionDirective.mandatory;
        }
        if (resolution.equals("optional")) {
            return ResolutionDirective.optional;
        }
        return null;
    }

    public static String toRequireCapability(Requirement requirement) throws Exception {
        CapReqBuilder builder = CapReqBuilder.clone(requirement);
        StringBuilder sb = new StringBuilder(builder.getNamespace()).append(';').append(builder.toAttrs());
        return sb.toString();
    }

    public static String toProvideCapability(Capability capability) throws Exception {
        CapReqBuilder builder = CapReqBuilder.clone(capability);
        StringBuilder sb = new StringBuilder(builder.getNamespace()).append(';').append(builder.toAttrs());
        return sb.toString();
    }

    public static Map<URI, String> getLocations(Resource resource) {
        Map locations = MapStream.of(ResourceUtils.capabilityStream(resource, "osgi.content").map(FunctionWithException.asFunction(c -> {
            DeferredValue deferred;
            DeferredValueMap deferredMap;
            Object value;
            Map attributes = c.getAttributes();
            Object u = attributes.get("url");
            if (u == null) {
                return null;
            }
            URI uri = URI.create(u.toString());
            Object osgi_content = attributes instanceof DeferredValueMap ? ((value = (deferredMap = (DeferredValueMap)attributes).getDeferred("osgi.content")) instanceof DeferredValue ? (String.class.isAssignableFrom((deferred = (DeferredValue)value).type()) ? deferred : cnv.convert(String.class, deferred.get())) : cnv.convert(String.class, value)) : cnv.convert(String.class, attributes.get("osgi.content"));
            return MapStream.entry(uri, osgi_content);
        })).filter(Objects::nonNull)).collect(Collector.of(HashMap::new, (map, entry) -> map.put((URI)entry.getKey(), entry.getValue()), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0]));
        DeferredValueMap<URI, String> result = new DeferredValueMap<URI, String>(locations);
        return result;
    }

    public static List<Capability> findProviders(Requirement requirement, Collection<? extends Capability> capabilities) {
        return capabilities.stream().filter(ResourceUtils.matcher(requirement)).collect(ResourceUtils.toCapabilities());
    }

    public static boolean isFragment(Resource resource) {
        IdentityCapability identity = ResourceUtils.getIdentityCapability(resource);
        if (identity == null) {
            return false;
        }
        return "osgi.fragment".equals(identity.getAttributes().get("type"));
    }

    public static String stripDirective(String name) {
        if (Strings.charAt(name, -1) == ':') {
            return Strings.substring(name, 0, -1);
        }
        return name;
    }

    public static String getIdentity(Capability identityCapability) throws IllegalArgumentException {
        String id = (String)identityCapability.getAttributes().get("osgi.identity");
        if (id == null) {
            throw new IllegalArgumentException("Resource identity capability has missing identity attribute");
        }
        return id;
    }

    public static String getIdentity(Resource resource) throws IllegalArgumentException {
        return ResourceUtils.getIdentity(ResourceUtils.getIdentityCapability(resource));
    }

    public static aQute.bnd.version.Version getVersion(Resource resource) throws IllegalArgumentException {
        return ResourceUtils.getVersion(ResourceUtils.getIdentityCapability(resource));
    }

    public static VersionedClause toVersionClause(Resource resource) {
        return ResourceUtils.toVersionClause(resource, "[===,==+)");
    }

    public static VersionedClause toVersionClause(Resource resource, String mask) {
        String versionString;
        IdentityCapability idCap = ResourceUtils.getIdentityCapability(resource);
        String identity = ResourceUtils.getIdentity(idCap);
        if (resource.getCapabilities(WORKSPACE_NAMESPACE).isEmpty()) {
            Macro macro = new Macro(new Processor(), new Object[0]);
            aQute.bnd.version.Version version = ResourceUtils.getVersion(idCap);
            versionString = macro._range(new String[]{"range", mask, version.toString()});
        } else {
            versionString = "snapshot";
        }
        Attrs attribs = new Attrs();
        attribs.put("version", versionString);
        return new VersionedClause(identity, attribs);
    }

    public static List<VersionedClause> toVersionedClauses(Collection<Resource> resources) {
        List<VersionedClause> runBundles = resources.stream().map(ResourceUtils::toVersionClause).distinct().collect(Collectors.toList());
        return runBundles;
    }

    public static Set<Resource> getAllResources(Repository repository) {
        return ResourceUtils.getResources(repository.findProviders(all).values().stream().flatMap(Collection::stream));
    }

    public static int compareTo(Resource a, Resource b) {
        IdentityCapability right;
        IdentityCapability left = ResourceUtils.getIdentityCapability(a);
        if (left == (right = ResourceUtils.getIdentityCapability(b))) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        int compare = Objects.compare(left.osgi_identity(), right.osgi_identity(), nullsFirst);
        if (compare != 0) {
            return compare;
        }
        return Objects.compare(left.version(), right.version(), nullsFirst);
    }

    public static List<Resource> sort(Collection<Resource> resources) {
        List<Resource> list = resources.stream().sorted(ResourceUtils::compareTo).collect(Collectors.toList());
        return list;
    }

    public static List<Resource> sortByNameVersion(Collection<Resource> resources) {
        List<Resource> list = resources.stream().sorted(ResourceUtils::compareTo).collect(Collectors.toList());
        return list;
    }

    public static boolean isInitialRequirement(Resource resource) {
        IdentityCapability identityCapability = ResourceUtils.getIdentityCapability(resource);
        if (identityCapability == null) {
            return false;
        }
        String osgi_identity = identityCapability.osgi_identity();
        if (osgi_identity == null) {
            return false;
        }
        return "<<INITIAL>>".equals(osgi_identity);
    }

    public static <CAPABILITY extends Capability> Collector<CAPABILITY, List<CAPABILITY>, List<CAPABILITY>> toCapabilities() {
        return Collector.of(ArrayList::new, ResourceUtils::capabilitiesAccumulator, ResourceUtils::capabilitiesCombiner, new Collector.Characteristics[0]);
    }

    public static <CAPABILITY extends Capability, COLLECTION extends Collection<CAPABILITY>> void capabilitiesAccumulator(COLLECTION collection, CAPABILITY capability) {
        if (!collection.contains(capability)) {
            collection.add(capability);
        }
    }

    public static <CAPABILITY extends Capability, COLLECTION extends Collection<CAPABILITY>> COLLECTION capabilitiesCombiner(COLLECTION leftCollection, COLLECTION rightCollection) {
        if (leftCollection.isEmpty()) {
            return rightCollection;
        }
        rightCollection.forEach(capability -> ResourceUtils.capabilitiesAccumulator(leftCollection, capability));
        return leftCollection;
    }

    public static <CAPABILITY extends Capability, COLLECTION extends Collection<CAPABILITY>> Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements, Function<? super Requirement, COLLECTION> provider) {
        Map<Requirement, Collection<Capability>> result = requirements.stream().collect(Collectors.toMap(Function.identity(), provider, ResourceUtils::capabilitiesCombiner));
        return result;
    }

    public static Map<Requirement, Collection<Capability>> emptyProviders(Collection<? extends Requirement> requirements) {
        return ResourceUtils.findProviders(requirements, (? super Requirement requirement) -> new ArrayList());
    }

    public static interface ContentCapability
    extends Capability {
        public String osgi_content();

        public URI url();

        public long size();

        public String mime();
    }

    public static interface IdentityCapability
    extends Capability {
        public String osgi_identity();

        public boolean singleton();

        public aQute.bnd.version.Version version();

        public Type type();

        public URI uri();

        public String copyright();

        public String description(String var1);

        public String documentation();

        public String license();

        public static enum Type {
            bundle("osgi.bundle"),
            fragment("osgi.fragment"),
            unknown("unknown");

            private String s;

            private Type(String s) {
                this.s = s;
            }

            public String toString() {
                return this.s;
            }
        }
    }

    public static interface BundleCap
    extends Capability {
        public String osgi_wiring_bundle();

        public boolean singleton();

        public aQute.bnd.version.Version bundle_version();
    }
}

