/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.osgi.resource.DeferredValueMap;
import aQute.bnd.unmodifiable.Maps;
import java.util.Map;
import java.util.Objects;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

abstract class CapReq {
    private final String namespace;
    private final Resource resource;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;
    private transient int hashCode = 0;

    CapReq(String namespace, Resource resource, Map<String, String> directives, Map<String, Object> attributes) {
        this.namespace = Objects.requireNonNull(namespace);
        this.resource = resource;
        this.directives = Maps.copyOf(directives);
        this.attributes = new DeferredValueMap<String, Object>(Maps.copyOf(attributes));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = Objects.hash(this.attributes, this.directives, this instanceof Capability, this.namespace, this.resource);
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this instanceof Capability) {
            if (!(obj instanceof Capability)) {
                return false;
            }
            Capability other = (Capability)obj;
            return Objects.equals(this.namespace, other.getNamespace()) && Objects.equals(this.attributes, other.getAttributes()) && Objects.equals(this.directives, other.getDirectives()) && Objects.equals(this.resource, other.getResource());
        }
        if (!(obj instanceof Requirement)) {
            return false;
        }
        Requirement other = (Requirement)obj;
        return Objects.equals(this.namespace, other.getNamespace()) && Objects.equals(this.attributes, other.getAttributes()) && Objects.equals(this.directives, other.getDirectives()) && Objects.equals(this.resource, other.getResource());
    }

    protected void toString(StringBuilder sb) {
        sb.append('[').append(this.namespace).append(']').append(this.attributes).append(this.directives);
    }
}

