/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.IO;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class ActivelyClosingClassLoader
extends URLClassLoader
implements Closeable {
    final AtomicReference<Map<File, Wrapper>> wrappers = new AtomicReference(new LinkedHashMap());
    final AtomicBoolean open = new AtomicBoolean(true);
    final Processor processor;
    ScheduledFuture<?> schedule;

    ActivelyClosingClassLoader(Processor processor, ClassLoader parent) {
        super(new URL[0], parent);
        this.processor = processor;
        ActivelyClosingClassLoader.registerAsParallelCapable();
    }

    void add(File file) {
        if (!this.open.get()) {
            throw new IllegalStateException("Already closed");
        }
        this.wrappers.updateAndGet(map -> {
            LinkedHashMap<File, Wrapper> copy = new LinkedHashMap<File, Wrapper>((Map<File, Wrapper>)map);
            copy.computeIfAbsent(file, x$0 -> new Wrapper((File)x$0));
            return copy;
        });
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.dataStream(name.replace('.', '/') + ".class").findFirst().map(data -> this.defineClass(name, (byte[])data, 0, ((byte[])data).length)).orElseThrow(() -> new ClassNotFoundException(name + " not found in " + this));
    }

    @Override
    public URL findResource(String name) {
        return this.dataStream(name).findFirst().map(data -> this.createURL(name, (byte[])data)).orElse(null);
    }

    private Stream<byte[]> dataStream(String name) {
        return this.wrappers.get().values().stream().map(wrapper -> wrapper.getData(name)).filter(Objects::nonNull);
    }

    private URL createURL(String name, final byte[] data) {
        try {
            return new URL("bndloader", null, 0, name, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteBufferInputStream(data);
                        }

                        @Override
                        public int getContentLength() {
                            return data.length;
                        }

                        @Override
                        public long getContentLengthLong() {
                            return data.length;
                        }

                        @Override
                        public String getContentType() {
                            return "application/octet-stream";
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        List resources = this.dataStream(name).map(data -> this.createURL(name, (byte[])data)).collect(Collectors.toList());
        return Collections.enumeration(resources);
    }

    void purge(long purgeTime) {
        this.wrappers.get().values().stream().filter(w -> w.lastAccess < purgeTime).forEach(Wrapper::close);
    }

    @Override
    public void close() {
        if (this.open.getAndSet(false)) {
            if (this.schedule != null) {
                this.schedule.cancel(true);
            }
            ((Map)this.wrappers.getAndSet(new LinkedHashMap())).values().forEach(Wrapper::close);
        }
    }

    List<File> getFiles() {
        return this.wrappers.get().values().stream().map(w -> w.file).collect(Collectors.toList());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException nfe) {
                Bundle bundle = FrameworkUtil.getBundle(ActivelyClosingClassLoader.class);
                if (bundle == null) {
                    throw nfe;
                }
                Bundle system = bundle.getBundleContext().getBundle(0L);
                return system.loadClass(name);
            }
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append(" not found, parent: ");
            sb.append(this.getParent());
            sb.append(" urls:");
            sb.append(this.getFiles());
            sb.append(" exception:");
            sb.append(Exceptions.toString(t));
            throw new ClassNotFoundException(sb.toString(), t);
        }
    }

    void autopurge(long freshPeriod) {
        this.schedule = Processor.getScheduledExecutor().scheduleWithFixedDelay(() -> this.purge(System.currentTimeMillis() - freshPeriod), freshPeriod, freshPeriod, TimeUnit.MILLISECONDS);
    }

    class Wrapper {
        Jar jarFile;
        volatile long lastAccess;
        final File file;

        Wrapper(File file) {
            this.file = file;
        }

        synchronized void close() {
            IO.close(this.jarFile);
            this.jarFile = null;
        }

        synchronized byte[] getData(String name) {
            if (!ActivelyClosingClassLoader.this.open.get()) {
                return null;
            }
            try {
                Resource resource;
                if (this.jarFile == null) {
                    if (!this.file.exists()) {
                        return null;
                    }
                    this.jarFile = new Jar(this.file);
                }
                if ((resource = this.jarFile.getResource(name)) == null) {
                    return null;
                }
                this.lastAccess = System.currentTimeMillis();
                return IO.read(resource.openInputStream());
            }
            catch (Exception e) {
                ActivelyClosingClassLoader.this.processor.exception(e, "while loading resource %s from %s: %s", name, this.file, e.getMessage());
                return null;
            }
        }
    }
}

