/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.ops4j.pax.url.war.internal.Configuration;
import org.ops4j.pax.url.war.internal.WarConnection;

public class WebBundleConnection
extends WarConnection {
    public WebBundleConnection(URL url, Configuration config) throws MalformedURLException {
        super(url, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream createBundle(InputStream inputStream, Properties instructions, String warUri) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream, 65536);
        bis.mark(65536);
        boolean isBundle = false;
        try {
            JarInputStream jis = new JarInputStream(bis){

                @Override
                public void close() throws IOException {
                }
            };
            Manifest man = jis.getManifest();
            Attributes mainAttributes = man.getMainAttributes();
            if (mainAttributes.getValue("Bundle-SymbolicName") != null || mainAttributes.getValue("Bundle-Version") != null || mainAttributes.getValue("Bundle-ManifestVersion") != null || mainAttributes.getValue("Import-Package") != null || mainAttributes.getValue("Web-ContextPath") != null) {
                isBundle = true;
            }
            jis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis.markSupported()) {
                try {
                    bis.reset();
                }
                catch (IOException e) {}
            }
        }
        if (isBundle) {
            Properties originalInstructions = BndUtils.parseInstructions(this.getURL().getQuery());
            if (originalInstructions.size() > 1 || originalInstructions.size() == 1 && !originalInstructions.containsKey("Web-ContextPath")) {
                throw new MalformedURLException("The webbundle URL handler can not be used with bundles");
            }
            String manifestVersion = originalInstructions.getProperty("Bundle-ManifestVersion");
            if (manifestVersion != null && !"2".equals(manifestVersion)) {
                throw new IllegalArgumentException("Can't support Bundle-ManifestVersion: " + manifestVersion);
            }
            Iterator<Object> it = instructions.keySet().iterator();
            while (it.hasNext()) {
                Object k = it.next();
                String key = k == null ? "" : k.toString();
                if (key.startsWith("-") || "WAR-URL".equals(key) || "Web-ContextPath".equals(key)) continue;
                it.remove();
            }
        }
        if (instructions.get("Web-ContextPath") != null) {
            Object ctxtPath = (String)instructions.get("Web-ContextPath");
            if (!((String)ctxtPath).startsWith("/")) {
                ctxtPath = "/" + (String)ctxtPath;
                instructions.setProperty("Web-ContextPath", (String)ctxtPath);
            }
        } else {
            throw new IllegalArgumentException("Can't install a webbundle WAR without Web-ContextPath configured");
        }
        return super.createBundle(bis, instructions, warUri, OverwriteMode.MERGE);
    }
}

