/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.url.war.internal.AbstractConnection;
import org.ops4j.pax.url.war.internal.Configuration;

public class WarConnection
extends AbstractConnection {
    private static final String JAKARTA_SERVLET_HTTP = "jakarta.servlet.http";
    private static final String JAKARTA_SERVLET = "jakarta.servlet";
    private static final String JAKARTA_JSP = "jakarta.servlet.jsp";
    private static final String JAKARTA_JSP_JSTL = "jakarta.servlet.jsp.jstl";
    private static final String APACHE_JASPER = "org.apache.jasper";
    private static final String APACHE_TAGLIBS = "org.apache.taglibs";
    private static final String SUN_EL = "com.sun.el";
    private static final String JASPI = "org.apache.geronimo.components.jaspi";

    public WarConnection(URL url, Configuration config) throws MalformedURLException {
        super(url, config);
    }

    @Override
    protected Properties getInstructions() throws MalformedURLException {
        Object importPackages;
        Properties instructions = BndUtils.parseInstructions(this.getURL().getQuery());
        instructions.setProperty("WAR-URL", this.getURL().getPath());
        if (!instructions.containsKey("Import-Package")) {
            String packages = "jakarta.servlet,jakarta.servlet.http,jakarta.servlet.jsp; resolution:=optional,jakarta.servlet.jsp.el; resolution:=optional,jakarta.servlet.jsp.jstl.*; resolution:=optional,jakarta.*; resolution:=optional,org.apache.geronimo.components.jaspi;resolution:=optional,org.apache.jasper.*;resolution:=optional,org.apache.taglibs.*;resolution:=optional,com.sun.el.*;resolution:=optional,org.xml.*; resolution:=optional,org.w3c.*; resolution:=optional";
            instructions.setProperty("Import-Package", packages);
        } else {
            importPackages = instructions.getProperty("Import-Package");
            if (((String)importPackages).contains(JAKARTA_SERVLET) || ((String)importPackages).contains(JAKARTA_SERVLET_HTTP)) {
                String[] imports;
                boolean servletFound = false;
                boolean servletHttpFound = false;
                for (String importstmt : imports = ((String)importPackages).split(",")) {
                    if (!importstmt.contains(JAKARTA_SERVLET)) continue;
                    if (importstmt.length() > JAKARTA_SERVLET.length() && importstmt.charAt(JAKARTA_SERVLET.length()) == '.') {
                        if (!importstmt.contains(JAKARTA_SERVLET_HTTP)) continue;
                        servletHttpFound = true;
                        continue;
                    }
                    servletFound = true;
                }
                if (!servletFound) {
                    importPackages = (String)importPackages + ",jakarta.servlet";
                }
                if (!servletHttpFound) {
                    importPackages = (String)importPackages + ",jakarta.servlet.http";
                }
            } else {
                importPackages = (String)importPackages + ",jakarta.servlet,jakarta.servlet.http";
            }
            if (!((String)importPackages).contains(JAKARTA_JSP)) {
                importPackages = (String)importPackages + ",jakarta.servlet.jsp;resolution:=optional";
                importPackages = (String)importPackages + ",jakarta.servlet.jsp.el;resolution:=optional";
                importPackages = (String)importPackages + ",jakarta.servlet.jsp.jstl.*;resolution:=optional";
            }
            if (!((String)importPackages).contains(APACHE_JASPER)) {
                importPackages = (String)importPackages + ",org.apache.jasper.*;resolution:=optional";
            }
            if (!((String)importPackages).contains(APACHE_TAGLIBS)) {
                importPackages = (String)importPackages + ",org.apache.taglibs.*;resolution:=optional";
            }
            if (!((String)importPackages).contains(SUN_EL)) {
                importPackages = (String)importPackages + ",com.sun.el.*;resolution:=optional";
            }
            if (!((String)importPackages).contains(JASPI)) {
                importPackages = (String)importPackages + ",org.apache.geronimo.components.jaspi;resolution:=optional";
            }
            instructions.setProperty("Import-Package", (String)importPackages);
        }
        if (this.getConfiguration().getImportPaxLoggingPackages().booleanValue()) {
            importPackages = instructions.getProperty("Import-Package");
            String provider = ";provider=paxlogging;resolution:=optional";
            importPackages = (String)importPackages + ",org.apache.commons.logging" + provider + ",org.apache.commons.logging.impl" + provider + ",org.apache.log4j" + provider + ",org.apache.log4j.spi" + provider + ",org.apache.log4j.xml" + provider + ",org.slf4j" + provider + ",org.slf4j.helpers" + provider + ",org.slf4j.spi" + provider;
            instructions.setProperty("Import-Package", (String)importPackages);
        }
        if (!instructions.containsKey("Export-Package")) {
            instructions.setProperty("Export-Package", "!*");
        }
        if (!instructions.containsKey("-removeheaders")) {
            instructions.setProperty("-removeheaders", "Private-Package,Ignore-Package");
        }
        return instructions;
    }
}

