/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build.model;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.WorkspaceLayout;
import aQute.bnd.build.model.EE;
import aQute.bnd.build.model.clauses.ExportedPackage;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.build.model.clauses.ImportPattern;
import aQute.bnd.build.model.clauses.ServiceComponent;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.build.model.conversions.CollectionFormatter;
import aQute.bnd.build.model.conversions.Converter;
import aQute.bnd.build.model.conversions.DefaultBooleanFormatter;
import aQute.bnd.build.model.conversions.DefaultFormatter;
import aQute.bnd.build.model.conversions.EEConverter;
import aQute.bnd.build.model.conversions.EEFormatter;
import aQute.bnd.build.model.conversions.HeaderClauseFormatter;
import aQute.bnd.build.model.conversions.HeaderClauseListConverter;
import aQute.bnd.build.model.conversions.MapFormatter;
import aQute.bnd.build.model.conversions.NewlineEscapedStringFormatter;
import aQute.bnd.build.model.conversions.NoopConverter;
import aQute.bnd.build.model.conversions.PropertiesConverter;
import aQute.bnd.build.model.conversions.PropertiesEntryFormatter;
import aQute.bnd.build.model.conversions.RequirementFormatter;
import aQute.bnd.build.model.conversions.RequirementListConverter;
import aQute.bnd.build.model.conversions.SimpleListConverter;
import aQute.bnd.build.model.conversions.VersionedClauseConverter;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.help.instructions.ResolutionInstructions;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Processor;
import aQute.bnd.properties.Document;
import aQute.bnd.properties.IDocument;
import aQute.bnd.properties.IRegion;
import aQute.bnd.properties.LineType;
import aQute.bnd.properties.PropertiesLineReader;
import aQute.bnd.version.Version;
import aQute.lib.collections.Iterables;
import aQute.lib.io.IO;
import aQute.lib.utf8properties.UTF8Properties;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.resource.Requirement;

public class BndEditModel {
    public static final String NEWLINE_LINE_SEPARATOR = "\\n\\\n\t";
    public static final String LIST_SEPARATOR = ",\\\n\t";
    private static String[] KNOWN_PROPERTIES = new String[]{"Bundle-License", "Bundle-Category", "Bundle-Name", "Bundle-Description", "Bundle-Copyright", "Bundle-UpdateLocation", "Bundle-Vendor", "Bundle-ContactAddress", "Bundle-DocURL", "Bundle-SymbolicName", "Bundle-Version", "Bundle-Activator", "Export-Package", "Import-Package", "Private-Package", "-privatepackage", "-sources", "Service-Component", "-classpath", "-buildpath", "-runbundles", "-runproperties", "-sub", "-runframework", "-runfw", "-runvm", "-runprogramargs", "-distro", "Test-Cases", "-plugin", "-pluginpath", "-runrepos", "-runrequires", "-runee", "-runblacklist", "Bundle-Blueprint", "Include-Resource", "-standalone"};
    public static final String PROP_WORKSPACE = "_workspace";
    public static final String BUNDLE_VERSION_MACRO = "${Bundle-Version}";
    private static final Map<String, Converter<? extends Object, String>> converters = new HashMap<String, Converter<? extends Object, String>>();
    private static final Map<String, Converter<String, ? extends Object>> formatters = new HashMap<String, Converter<String, ? extends Object>>();
    private File bndResource;
    private String bndResourceName;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private Properties properties = new UTF8Properties();
    private final Map<String, Object> objectProperties = new HashMap<String, Object>();
    private final Map<String, String> changesToSave = new TreeMap<String, String>();
    private Project project;
    private volatile boolean dirty;
    private static final Converter<List<VersionedClause>, String> buildPathConverter = new HeaderClauseListConverter<VersionedClause>(new Converter<VersionedClause, HeaderClause>(){

        @Override
        public VersionedClause convert(HeaderClause input) throws IllegalArgumentException {
            if (input == null) {
                return null;
            }
            return new VersionedClause(input.getName(), input.getAttribs());
        }

        @Override
        public VersionedClause error(String msg) {
            return null;
        }
    });
    private static final Converter<List<VersionedClause>, String> clauseListConverter = new HeaderClauseListConverter<VersionedClause>(new VersionedClauseConverter());
    private static final Converter<String, String> stringConverter = new NoopConverter<String>();
    private static final Converter<Boolean, String> includedSourcesConverter = new Converter<Boolean, String>(){

        @Override
        public Boolean convert(String string) throws IllegalArgumentException {
            return Boolean.valueOf(string);
        }

        @Override
        public Boolean error(String msg) {
            return Boolean.FALSE;
        }
    };
    private static final Converter<List<String>, String> listConverter = SimpleListConverter.create();
    private static final Converter<List<ExportedPackage>, String> exportPackageConverter = new HeaderClauseListConverter<ExportedPackage>(new Converter<ExportedPackage, HeaderClause>(){

        @Override
        public ExportedPackage convert(HeaderClause input) {
            if (input == null) {
                return null;
            }
            return new ExportedPackage(input.getName(), input.getAttribs());
        }

        @Override
        public ExportedPackage error(String msg) {
            return ExportedPackage.error(msg);
        }
    });
    private static final Converter<List<ServiceComponent>, String> serviceComponentConverter = new HeaderClauseListConverter<ServiceComponent>(new Converter<ServiceComponent, HeaderClause>(){

        @Override
        public ServiceComponent convert(HeaderClause input) throws IllegalArgumentException {
            if (input == null) {
                return null;
            }
            return new ServiceComponent(input.getName(), input.getAttribs());
        }

        @Override
        public ServiceComponent error(String msg) {
            return ServiceComponent.error(msg);
        }
    });
    private static final Converter<List<ImportPattern>, String> importPatternConverter = new HeaderClauseListConverter<ImportPattern>(new Converter<ImportPattern, HeaderClause>(){

        @Override
        public ImportPattern convert(HeaderClause input) throws IllegalArgumentException {
            if (input == null) {
                return null;
            }
            return new ImportPattern(input.getName(), input.getAttribs());
        }

        @Override
        public ImportPattern error(String msg) {
            return ImportPattern.error(msg);
        }
    });
    private static final Converter<Map<String, String>, String> propertiesConverter = new PropertiesConverter();
    private static final Converter<List<Requirement>, String> requirementListConverter = new RequirementListConverter();
    private static final Converter<EE, String> eeConverter = new EEConverter();
    private static final Converter<String, String> newlineEscapeFormatter = new NewlineEscapedStringFormatter();
    private static final Converter<String, Boolean> defaultFalseBoolFormatter = new DefaultBooleanFormatter(false);
    private static final Converter<String, Collection<?>> stringListFormatter = new CollectionFormatter(",\\\n\t", (String)null);
    private static final Converter<List<HeaderClause>, String> headerClauseListConverter = new HeaderClauseListConverter<HeaderClause>(new NoopConverter());
    private static final Converter<String, Collection<? extends HeaderClause>> headerClauseListFormatter = new CollectionFormatter<HeaderClause>(",\\\n\t", new HeaderClauseFormatter(), null);
    private static final Converter<String, Collection<? extends HeaderClause>> complexHeaderClauseListFormatter = new CollectionFormatter<HeaderClause>(",\\\n\t", new HeaderClauseFormatter(true), null);
    private static final Converter<String, Map<String, String>> propertiesFormatter = new MapFormatter(",\\\n\t", new PropertiesEntryFormatter(), null);
    private static final Converter<String, Collection<? extends Requirement>> requirementListFormatter = new CollectionFormatter<Requirement>(",\\\n\t", new RequirementFormatter(), null);
    private static final Converter<String, Collection<? extends HeaderClause>> standaloneLinkListFormatter = new CollectionFormatter<HeaderClause>(",\\\n\t", new HeaderClauseFormatter(), "");
    private static final Converter<String, EE> eeFormatter = new EEFormatter();
    private static final Converter<String, Collection<? extends String>> runReposFormatter = new CollectionFormatter<String>(",\\\n\t", "<<EMPTY>>");
    private Workspace workspace;
    private IDocument document;

    public BndEditModel() {
    }

    public BndEditModel(BndEditModel model) {
        this();
        this.bndResource = model.bndResource;
        this.workspace = model.workspace;
        this.properties.putAll((Map<?, ?>)model.properties);
        this.changesToSave.putAll(model.changesToSave);
    }

    public BndEditModel(Workspace workspace) {
        this();
        this.workspace = workspace;
    }

    public BndEditModel(IDocument document) throws IOException {
        this();
        this.loadFrom(document);
    }

    public BndEditModel(Project project) throws IOException {
        this(project.getWorkspace());
        this.project = project;
        File propertiesFile = project.getPropertiesFile();
        this.document = propertiesFile.isFile() ? new Document(IO.collect(propertiesFile)) : new Document("");
        this.loadFrom(this.document);
    }

    public void loadFrom(IDocument document) throws IOException {
        try (InputStream in = this.toEscaped(document.get());){
            this.loadFrom(in);
        }
    }

    public InputStream toEscaped(String text) throws IOException {
        int c;
        StringReader unicode = new StringReader(text);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((c = unicode.read()) >= 0) {
            if (c >= 127) {
                bout.write(String.format("\\u%04X", c).getBytes());
                continue;
            }
            bout.write((char)c);
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public InputStream toAsciiStream(IDocument doc) throws IOException {
        this.saveChangesTo(doc);
        return this.toEscaped(doc.get());
    }

    public void loadFrom(File file) throws IOException {
        this.loadFrom(IO.stream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(InputStream inputStream) throws IOException {
        try {
            if (this.workspace != null && this.workspace.getLayout() != WorkspaceLayout.STANDALONE) {
                this.properties = (Properties)this.workspace.getProperties().clone();
            } else {
                this.properties.clear();
            }
            this.properties.load(inputStream);
            this.objectProperties.clear();
            this.changesToSave.clear();
            for (String prop : KNOWN_PROPERTIES) {
                this.propChangeSupport.firePropertyChange(prop, null, null);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void saveChangesTo(IDocument document) {
        Iterator<Map.Entry<String, String>> iter = this.changesToSave.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String propertyName = entry.getKey();
            String stringValue = entry.getValue();
            BndEditModel.updateDocument(document, propertyName, stringValue);
            String value = this.cleanup(stringValue);
            if (value == null) {
                value = "";
            }
            if (propertyName != null) {
                this.properties.setProperty(propertyName, value);
            }
            iter.remove();
        }
    }

    private static IRegion findEntry(IDocument document, String name) throws Exception {
        PropertiesLineReader reader = new PropertiesLineReader(document);
        LineType type = reader.next();
        while (type != LineType.eof) {
            String key;
            if (type == LineType.entry && name.equals(key = reader.key())) {
                return reader.region();
            }
            type = reader.next();
        }
        return null;
    }

    private static void updateDocument(IDocument document, String name, String value) {
        String newEntry;
        if (value != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(name).append(": ").append(value);
            newEntry = buffer.toString();
        } else {
            newEntry = "";
        }
        try {
            IRegion region = BndEditModel.findEntry(document, name);
            if (region != null) {
                int offset = region.getOffset();
                int length = region.getLength();
                if (newEntry.length() == 0 && offset + length + 1 < document.getLength()) {
                    ++length;
                }
                document.replace(offset, length, newEntry);
            } else if (newEntry.length() > 0) {
                if (document.getLength() > 0 && document.getChar(document.getLength() - 1) != '\n') {
                    newEntry = "\n" + newEntry;
                }
                document.replace(document.getLength(), 0, newEntry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getAllPropertyNames() {
        return StreamSupport.stream(Iterables.iterable(this.properties.propertyNames(), String.class::cast).spliterator(), false).collect(Collectors.toList());
    }

    public Converter<Object, String> lookupConverter(String propertyName) {
        Converter<Object, String> converter = converters.get(propertyName);
        return converter;
    }

    public Converter<String, Object> lookupFormatter(String propertyName) {
        Converter<String, Object> formatter = formatters.get(propertyName);
        return formatter;
    }

    public Object genericGet(String propertyName) {
        Converter<? extends Object, String> converter = converters.get(propertyName);
        if (converter == null) {
            converter = new NoopConverter<String>();
        }
        return this.doGetObject(propertyName, converter);
    }

    public void genericSet(String propertyName, Object value) {
        Object oldValue = this.genericGet(propertyName);
        DefaultFormatter formatter = formatters.get(propertyName);
        if (formatter == null) {
            formatter = new DefaultFormatter();
        }
        this.doSetObject(propertyName, oldValue, value, formatter);
    }

    public String getBundleLicense() {
        return this.doGetObject("Bundle-License", stringConverter);
    }

    public void setBundleLicense(String bundleLicense) {
        this.doSetObject("Bundle-License", this.getBundleLicense(), bundleLicense, newlineEscapeFormatter);
    }

    public String getBundleCategory() {
        return this.doGetObject("Bundle-Category", stringConverter);
    }

    public void setBundleCategory(String bundleCategory) {
        this.doSetObject("Bundle-Category", this.getBundleCategory(), bundleCategory, newlineEscapeFormatter);
    }

    public String getBundleName() {
        return this.doGetObject("Bundle-Name", stringConverter);
    }

    public void setBundleName(String bundleName) {
        this.doSetObject("Bundle-Name", this.getBundleName(), bundleName, newlineEscapeFormatter);
    }

    public String getBundleDescription() {
        return this.doGetObject("Bundle-Description", stringConverter);
    }

    public void setBundleDescription(String bundleDescription) {
        this.doSetObject("Bundle-Description", this.getBundleDescription(), bundleDescription, newlineEscapeFormatter);
    }

    public String getBundleCopyright() {
        return this.doGetObject("Bundle-Copyright", stringConverter);
    }

    public void setBundleCopyright(String bundleCopyright) {
        this.doSetObject("Bundle-Copyright", this.getBundleCopyright(), bundleCopyright, newlineEscapeFormatter);
    }

    public String getBundleUpdateLocation() {
        return this.doGetObject("Bundle-UpdateLocation", stringConverter);
    }

    public void setBundleUpdateLocation(String bundleUpdateLocation) {
        this.doSetObject("Bundle-UpdateLocation", this.getBundleUpdateLocation(), bundleUpdateLocation, newlineEscapeFormatter);
    }

    public String getBundleVendor() {
        return this.doGetObject("Bundle-Vendor", stringConverter);
    }

    public void setBundleVendor(String bundleVendor) {
        this.doSetObject("Bundle-Vendor", this.getBundleVendor(), bundleVendor, newlineEscapeFormatter);
    }

    public String getBundleContactAddress() {
        return this.doGetObject("Bundle-ContactAddress", stringConverter);
    }

    public void setBundleContactAddress(String bundleContactAddress) {
        this.doSetObject("Bundle-ContactAddress", this.getBundleContactAddress(), bundleContactAddress, newlineEscapeFormatter);
    }

    public String getBundleDocUrl() {
        return this.doGetObject("Bundle-DocURL", stringConverter);
    }

    public void setBundleDocUrl(String bundleDocUrl) {
        this.doSetObject("Bundle-DocURL", this.getBundleDocUrl(), bundleDocUrl, newlineEscapeFormatter);
    }

    public String getBundleSymbolicName() {
        return this.doGetObject("Bundle-SymbolicName", stringConverter);
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.doSetObject("Bundle-SymbolicName", this.getBundleSymbolicName(), bundleSymbolicName, newlineEscapeFormatter);
    }

    public String getBundleVersionString() {
        return this.doGetObject("Bundle-Version", stringConverter);
    }

    public void setBundleVersion(String bundleVersion) {
        this.doSetObject("Bundle-Version", this.getBundleVersionString(), bundleVersion, newlineEscapeFormatter);
    }

    public String getBundleActivator() {
        return this.doGetObject("Bundle-Activator", stringConverter);
    }

    public void setBundleActivator(String bundleActivator) {
        this.doSetObject("Bundle-Activator", this.getBundleActivator(), bundleActivator, newlineEscapeFormatter);
    }

    public String getOutputFile() {
        return this.doGetObject("-output", stringConverter);
    }

    public void setOutputFile(String name) {
        this.doSetObject("-output", this.getOutputFile(), name, newlineEscapeFormatter);
    }

    public boolean isIncludeSources() {
        return this.doGetObject("-sources", includedSourcesConverter);
    }

    public void setIncludeSources(boolean includeSources) {
        boolean oldValue = this.isIncludeSources();
        this.doSetObject("-sources", oldValue, includeSources, defaultFalseBoolFormatter);
    }

    public List<String> getPrivatePackages() {
        List<String> privatePackagesEntries1 = this.getEntries("-privatepackage", listConverter);
        List<String> privatePackagesEntries2 = this.getEntries("Private-Package", listConverter);
        return Stream.concat(privatePackagesEntries1.stream(), privatePackagesEntries2.stream()).distinct().collect(Collectors.toList());
    }

    public void setPrivatePackages(List<String> newPackages) {
        List<String> privatePackagesEntries1 = this.getEntries("-privatepackage", listConverter);
        List<String> privatePackagesEntries2 = this.getEntries("Private-Package", listConverter);
        Set privatePackages = Stream.concat(privatePackagesEntries1.stream(), privatePackagesEntries2.stream()).collect(Collectors.toSet());
        List<String> addedEntries = BndEditModel.disjunction(newPackages, privatePackages);
        List removedEntries = BndEditModel.disjunction(privatePackages, newPackages);
        privatePackagesEntries1.removeAll(removedEntries);
        if (privatePackagesEntries1.isEmpty()) {
            this.removeEntries("-privatepackage");
        } else {
            this.setEntries(privatePackagesEntries1, "-privatepackage");
        }
        privatePackagesEntries2.removeAll(removedEntries);
        if (privatePackagesEntries2.isEmpty()) {
            this.removeEntries("Private-Package");
        } else {
            this.setEntries(privatePackagesEntries2, "Private-Package");
        }
        if (this.hasPrivatePackageInstruction()) {
            privatePackagesEntries1.addAll(addedEntries);
            this.setEntries(privatePackagesEntries1, "-privatepackage");
        } else {
            privatePackagesEntries2.addAll(addedEntries);
            this.setEntries(privatePackagesEntries2, "Private-Package");
        }
    }

    private void setEntries(List<? extends String> packages, String key) {
        List<String> oldPackages = this.getEntries(key, listConverter);
        this.doSetObject(key, oldPackages, packages, stringListFormatter);
    }

    private void removeEntries(String key) {
        List<String> oldPackages = this.getEntries(key, listConverter);
        this.doRemoveObject(key, oldPackages, null, stringListFormatter);
    }

    public void addPrivatePackage(String packageName) {
        String key = this.hasPrivatePackageInstruction() ? "-privatepackage" : "Private-Package";
        List<String> packages = this.getEntries(key, listConverter);
        packages.add(packageName);
        this.setEntries(packages, key);
    }

    private boolean hasPrivatePackageInstruction() {
        return this.properties.containsKey("-privatepackage");
    }

    private <E> List<String> getEntries(String instruction, Converter<? extends E, ? super String> converter) {
        List entries = (List)this.doGetObject(instruction, converter);
        return entries == null ? new ArrayList() : entries;
    }

    public List<ExportedPackage> getSystemPackages() {
        return this.doGetObject("-runsystempackages", exportPackageConverter);
    }

    public void setSystemPackages(List<? extends ExportedPackage> packages) {
        List<ExportedPackage> oldPackages = this.getSystemPackages();
        this.doSetObject("-runsystempackages", oldPackages, packages, headerClauseListFormatter);
    }

    public List<String> getClassPath() {
        return this.doGetObject("-classpath", listConverter);
    }

    public void setClassPath(List<? extends String> classPath) {
        List<String> oldClassPath = this.getClassPath();
        this.doSetObject("-classpath", oldClassPath, classPath, stringListFormatter);
    }

    public List<ExportedPackage> getExportedPackages() {
        return this.doGetObject("Export-Package", exportPackageConverter);
    }

    public void setExportedPackages(List<? extends ExportedPackage> exports) {
        boolean referencesBundleVersion = false;
        if (exports != null) {
            for (ExportedPackage exportedPackage : exports) {
                String versionString = exportedPackage.getVersionString();
                if (versionString == null || !versionString.contains(BUNDLE_VERSION_MACRO)) continue;
                referencesBundleVersion = true;
            }
        }
        List<ExportedPackage> oldValue = this.getExportedPackages();
        this.doSetObject("Export-Package", oldValue, exports, headerClauseListFormatter);
        if (referencesBundleVersion && this.getBundleVersionString() == null) {
            this.setBundleVersion(Version.emptyVersion.toString());
        }
    }

    public void addExportedPackage(ExportedPackage export) {
        List<ExportedPackage> exports = this.getExportedPackages();
        exports = exports == null ? new ArrayList<ExportedPackage>() : new ArrayList<ExportedPackage>(exports);
        exports.add(export);
        this.setExportedPackages(exports);
    }

    public List<String> getDSAnnotationPatterns() {
        return this.doGetObject("-dsannotations", listConverter);
    }

    public void setDSAnnotationPatterns(List<? extends String> patterns) {
        List<String> oldValue = this.getDSAnnotationPatterns();
        this.doSetObject("-dsannotations", oldValue, patterns, stringListFormatter);
    }

    public List<ServiceComponent> getServiceComponents() {
        return this.doGetObject("Service-Component", serviceComponentConverter);
    }

    public void setServiceComponents(List<? extends ServiceComponent> components) {
        List<ServiceComponent> oldValue = this.getServiceComponents();
        this.doSetObject("Service-Component", oldValue, components, headerClauseListFormatter);
    }

    public List<ImportPattern> getImportPatterns() {
        return this.doGetObject("Import-Package", importPatternConverter);
    }

    public void setImportPatterns(List<? extends ImportPattern> patterns) {
        List<ImportPattern> oldValue = this.getImportPatterns();
        this.doSetObject("Import-Package", oldValue, patterns, headerClauseListFormatter);
    }

    public List<VersionedClause> getBuildPath() {
        return this.doGetObject("-buildpath", buildPathConverter);
    }

    public List<VersionedClause> getTestPath() {
        return this.doGetObject("-testpath", buildPathConverter);
    }

    public void setBuildPath(List<? extends VersionedClause> paths) {
        List<VersionedClause> oldValue = this.getBuildPath();
        if (oldValue == null) {
            oldValue = Collections.emptyList();
        }
        this.doSetObject("-buildpath", oldValue, paths, headerClauseListFormatter);
    }

    public void addPath(VersionedClause versionedClause, String header) {
        List<VersionedClause> oldValue = this.doGetObject(header, buildPathConverter);
        ArrayList<VersionedClause> newValue = oldValue == null ? new ArrayList<VersionedClause>() : new ArrayList<VersionedClause>(oldValue);
        newValue.add(versionedClause);
        this.doSetObject(header, oldValue, newValue, headerClauseListFormatter);
    }

    public void addPath(BundleId bundleId, String header) {
        this.addPath(new VersionedClause(bundleId), header);
    }

    public void setTestPath(List<? extends VersionedClause> paths) {
        List<VersionedClause> oldValue = this.getTestPath();
        this.doSetObject("-testpath", oldValue, paths, headerClauseListFormatter);
    }

    public List<VersionedClause> getRunBundles() {
        return this.doGetObject("-runbundles", clauseListConverter);
    }

    public void setRunBundles(List<? extends VersionedClause> paths) {
        List<VersionedClause> oldValue = this.getRunBundles();
        this.doSetObject("-runbundles", oldValue, paths, headerClauseListFormatter);
    }

    public boolean isIncludedPackage(String packageName) {
        List<String> privatePackages = this.getPrivatePackages();
        if (privatePackages != null && privatePackages.contains(packageName)) {
            return true;
        }
        List<ExportedPackage> exportedPackages = this.getExportedPackages();
        if (exportedPackages != null) {
            for (ExportedPackage pkg : exportedPackages) {
                if (!packageName.equals(pkg.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getSubBndFiles() {
        return this.doGetObject("-sub", listConverter);
    }

    public void setSubBndFiles(List<String> subBndFiles) {
        List<String> oldValue = this.getSubBndFiles();
        this.doSetObject("-sub", oldValue, subBndFiles, stringListFormatter);
    }

    public Map<String, String> getRunProperties() {
        return this.doGetObject("-runproperties", propertiesConverter);
    }

    public void setRunProperties(Map<String, String> props) {
        Map<String, String> old = this.getRunProperties();
        this.doSetObject("-runproperties", old, props, propertiesFormatter);
    }

    public String getRunVMArgs() {
        return this.doGetObject("-runvm", stringConverter);
    }

    public void setRunVMArgs(String args) {
        String old = this.getRunVMArgs();
        this.doSetObject("-runvm", old, args, newlineEscapeFormatter);
    }

    public String getRunProgramArgs() {
        return this.doGetObject("-runprogramargs", stringConverter);
    }

    public void setRunProgramArgs(String args) {
        String old = this.getRunProgramArgs();
        this.doSetObject("-runprogramargs", old, args, newlineEscapeFormatter);
    }

    public List<String> getTestSuites() {
        List<String> testCases = this.doGetObject("Test-Cases", listConverter);
        testCases = testCases != null ? testCases : Collections.emptyList();
        ArrayList<String> result = new ArrayList<String>(testCases.size());
        result.addAll(testCases);
        return result;
    }

    public void setTestSuites(List<String> suites) {
        List<String> old = this.getTestSuites();
        this.doSetObject("Test-Cases", old, suites, stringListFormatter);
    }

    public List<HeaderClause> getPlugins() {
        return this.doGetObject("-plugin", headerClauseListConverter);
    }

    public void setPlugins(List<HeaderClause> plugins) {
        List<HeaderClause> old = this.getPlugins();
        this.doSetObject("-plugin", old, plugins, complexHeaderClauseListFormatter);
    }

    public List<String> getPluginPath() {
        return this.doGetObject("-pluginpath", listConverter);
    }

    public void setPluginPath(List<String> pluginPath) {
        List<String> old = this.getPluginPath();
        this.doSetObject("-pluginpath", old, pluginPath, stringListFormatter);
    }

    public List<String> getDistro() {
        return this.doGetObject("-distro", listConverter);
    }

    public void setDistro(List<String> distros) {
        List<String> old = this.getPluginPath();
        this.doSetObject("-distro", old, distros, stringListFormatter);
    }

    public List<String> getRunRepos() {
        return this.doGetObject("-runrepos", listConverter);
    }

    public void setRunRepos(List<String> repos) {
        List<String> old = this.getRunRepos();
        this.doSetObject("-runrepos", old, repos, runReposFormatter);
    }

    public String getRunFramework() {
        return this.doGetObject("-runframework", stringConverter);
    }

    public String getRunFw() {
        return this.doGetObject("-runfw", stringConverter);
    }

    public EE getEE() {
        return this.doGetObject("-runee", eeConverter);
    }

    public void setEE(EE ee) {
        EE old = this.getEE();
        this.doSetObject("-runee", old, ee, eeFormatter);
    }

    public void setRunFramework(String clause) {
        assert ("services".equalsIgnoreCase(clause.trim()) || "none".equalsIgnoreCase(clause.trim()));
        String oldValue = this.getRunFramework();
        this.doSetObject("-runframework", oldValue, clause, newlineEscapeFormatter);
    }

    public void setRunFw(String clause) {
        String oldValue = this.getRunFw();
        this.doSetObject("-runfw", oldValue, clause, newlineEscapeFormatter);
    }

    public List<Requirement> getRunRequires() {
        return this.doGetObject("-runrequires", requirementListConverter);
    }

    public void setRunRequires(List<Requirement> requires) {
        List<Requirement> oldValue = this.getRunRequires();
        this.doSetObject("-runrequires", oldValue, requires, requirementListFormatter);
    }

    public List<Requirement> getRunBlacklist() {
        return this.doGetObject("-runblacklist", requirementListConverter);
    }

    public void setRunBlacklist(List<Requirement> requires) {
        List<Requirement> oldValue = this.getRunBlacklist();
        this.doSetObject("-runblacklist", oldValue, requires, requirementListFormatter);
    }

    public List<HeaderClause> getStandaloneLinks() {
        return this.doGetObject("-standalone", headerClauseListConverter);
    }

    public void setStandaloneLinks(List<HeaderClause> headers) {
        List<HeaderClause> old = this.getStandaloneLinks();
        this.doSetObject("-standalone", old, headers, standaloneLinkListFormatter);
    }

    public List<HeaderClause> getIgnoreStandalone() {
        List<HeaderClause> v = this.doGetObject("-ignore-standalone", headerClauseListConverter);
        if (v != null) {
            return v;
        }
        v = this.doGetObject("x-ignore-standalone", headerClauseListConverter);
        if (v == null) {
            return null;
        }
        this.setIgnoreStandalone(v);
        this.doSetObject("x-ignore-standalone", v, null, standaloneLinkListFormatter);
        return this.doGetObject("-ignore-standalone", headerClauseListConverter);
    }

    public void setIgnoreStandalone(List<HeaderClause> headers) {
        List<HeaderClause> old = this.getIgnoreStandalone();
        this.doSetObject("-ignore-standalone", old, headers, standaloneLinkListFormatter);
    }

    private <R> R doGetObject(String name, Converter<? extends R, ? super String> converter) {
        try {
            Object result;
            if (this.objectProperties.containsKey(name)) {
                Object temp;
                result = temp = this.objectProperties.get(name);
            } else if (this.changesToSave.containsKey(name)) {
                result = converter.convert(this.changesToSave.get(name));
                this.objectProperties.put(name, result);
            } else if (this.properties.containsKey(name)) {
                result = converter.convert(this.properties.getProperty(name));
                this.objectProperties.put(name, result);
            } else {
                result = converter.convert(null);
            }
            return (R)result;
        }
        catch (Exception e) {
            return converter.error(e.getMessage());
        }
    }

    private <T> void doRemoveObject(String name, T oldValue, T newValue, Converter<String, ? super T> formatter) {
        this.objectProperties.remove(name);
        this.properties.remove(name);
        String v = formatter.convert(newValue);
        this.changesToSave.put(name, v);
        this.dirty = true;
        this.propChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    private <T> void doSetObject(String name, T oldValue, T newValue, Converter<String, ? super T> formatter) {
        this.objectProperties.put(name, newValue);
        String v = formatter.convert(newValue);
        this.changesToSave.put(name, v);
        this.dirty = true;
        this.propChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    public boolean isProjectFile() {
        return "bnd.bnd".equals(this.getBndResourceName());
    }

    public boolean isBndrun() {
        return this.getBndResourceName().endsWith(".bndrun");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setBndResource(File bndResource) {
        this.bndResource = bndResource;
    }

    public File getBndResource() {
        return this.bndResource;
    }

    public String getBndResourceName() {
        if (this.bndResourceName == null) {
            return "";
        }
        return this.bndResourceName;
    }

    public void setBndResourceName(String bndResourceName) {
        this.bndResourceName = bndResourceName;
    }

    public List<HeaderClause> getBundleBlueprint() {
        return this.doGetObject("Bundle-Blueprint", headerClauseListConverter);
    }

    public void setBundleBlueprint(List<HeaderClause> bundleBlueprint) {
        List<HeaderClause> old = this.getPlugins();
        this.doSetObject("Bundle-Blueprint", old, bundleBlueprint, headerClauseListFormatter);
    }

    public void addBundleBlueprint(String location) {
        List<HeaderClause> bpLocations = this.getBundleBlueprint();
        bpLocations = bpLocations == null ? new ArrayList<HeaderClause>() : new ArrayList<HeaderClause>(bpLocations);
        bpLocations.add(new HeaderClause(location, null));
        this.setBundleBlueprint(bpLocations);
    }

    public List<String> getIncludeResource() {
        List<String> includeResourceEntries1 = this.getEntries("-includeresource", listConverter);
        List<String> includeResourceEntries2 = this.getEntries("Include-Resource", listConverter);
        return Stream.concat(includeResourceEntries1.stream(), includeResourceEntries2.stream()).distinct().collect(Collectors.toList());
    }

    public void setIncludeResource(List<String> newEntries) {
        List<String> resourceEntries1 = this.getEntries("-includeresource", listConverter);
        List<String> resourceEntries2 = this.getEntries("Include-Resource", listConverter);
        Set resourceEntries = Stream.concat(resourceEntries1.stream(), resourceEntries2.stream()).collect(Collectors.toSet());
        List<String> addedEntries = BndEditModel.disjunction(newEntries, resourceEntries);
        List removedEntries = BndEditModel.disjunction(resourceEntries, newEntries);
        resourceEntries1.removeAll(removedEntries);
        if (resourceEntries1.isEmpty()) {
            this.removeEntries("-includeresource");
        } else {
            this.setEntries(resourceEntries1, "-includeresource");
        }
        resourceEntries2.removeAll(removedEntries);
        if (resourceEntries2.isEmpty()) {
            this.removeEntries("Include-Resource");
        } else {
            this.setEntries(resourceEntries2, "Include-Resource");
        }
        if (this.hasIncludeResourceInstruction()) {
            resourceEntries1.addAll(addedEntries);
            this.setEntries(resourceEntries1, "-includeresource");
        } else {
            resourceEntries2.addAll(addedEntries);
            this.setEntries(resourceEntries2, "Include-Resource");
        }
    }

    public void addIncludeResource(String resource) {
        String key = this.hasIncludeResourceInstruction() ? "-includeresource" : "Include-Resource";
        List<String> entries = this.getEntries(key, listConverter);
        entries.add(resource);
        this.setEntries(entries, key);
    }

    private boolean hasIncludeResourceInstruction() {
        return this.properties.containsKey("-includeresource");
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        Workspace old = this.workspace;
        this.workspace = workspace;
        this.propChangeSupport.firePropertyChange(PROP_WORKSPACE, old, workspace);
    }

    public String getGenericString(String name) {
        return this.doGetObject(name, stringConverter);
    }

    public void setGenericString(String name, String value) {
        this.doSetObject(name, this.getGenericString(name), value, stringConverter);
    }

    public Processor getProperties() throws Exception {
        Processor parent;
        File source = this.getBndResource();
        if (this.project != null) {
            parent = this.project;
            if (source == null) {
                source = this.project.getPropertiesFile();
            }
        } else if (this.workspace != null && this.isCnf()) {
            parent = this.workspace;
            if (source == null) {
                source = this.workspace.getPropertiesFile();
            }
        } else if (source != null) {
            parent = Workspace.getRun(source);
            if (parent == null) {
                parent = new Processor();
                parent.setProperties(source);
            }
        } else {
            parent = new Processor(this.properties, false);
        }
        UTF8Properties p = new UTF8Properties(parent.getProperties());
        if (!this.changesToSave.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.changesToSave.forEach((key, value) -> sb.append((String)key).append(':').append(' ').append((String)value).append('\n').append('\n'));
            p.load(sb.toString(), null, null);
        }
        p = p.replaceHere(parent.getBase());
        Processor result = new Processor(parent, p, false);
        result.setBase(parent.getBase());
        if (source != null) {
            result.setPropertiesFile(source);
        }
        return result;
    }

    private String cleanup(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("\\\\\n", "");
    }

    private static <E> List<E> disjunction(Collection<E> collection, Collection<?> remove) {
        ArrayList<E> list = new ArrayList<E>();
        for (E obj : collection) {
            if (remove.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public Map<String, String> getDocumentChanges() {
        return this.changesToSave;
    }

    public void saveChanges() throws IOException {
        assert (this.document != null && this.project != null) : "you can only call saveChanges when you created this edit model with a project";
        this.saveChangesTo(this.document);
        BndEditModel.store(this.document, this.getProject().getPropertiesFile());
        this.dirty = false;
    }

    public static void store(IDocument document, File file) throws IOException {
        IO.store((Object)document.get(), file);
    }

    public ResolutionInstructions.ResolveMode getResolveMode() {
        String resolve = this.getGenericString("-resolve");
        if (resolve != null) {
            try {
                return aQute.lib.converter.Converter.cnv(ResolutionInstructions.ResolveMode.class, (Object)resolve);
            }
            catch (Exception e) {
                this.project.error("Invalid value for %s: %s. Allowed values are %s", "-resolve", resolve, ResolutionInstructions.ResolveMode.class.getEnumConstants());
            }
        }
        return ResolutionInstructions.ResolveMode.manual;
    }

    public void setResolveMode(ResolutionInstructions.ResolveMode resolveMode) {
        this.setGenericString("-resolve", resolveMode.name());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    public void load() throws IOException {
        this.loadFrom(this.project.getPropertiesFile());
    }

    public boolean isCnf() {
        return this.bndResource != null && "cnf".equals(this.bndResource.getParentFile().getName()) && "build.bnd".equals(this.bndResource.getName());
    }

    public static <T> String format(String header, String input) {
        Converter<? extends Object, String> converter = converters.get(header);
        if (converter == null) {
            return input;
        }
        Object converted = converter.convert(input);
        Converter<String, ? extends Object> formatter = formatters.get(header);
        return formatter.convert(converted);
    }

    public <T extends Collection<Object>> String add(String header, String toAdd) {
        try {
            Converter<? extends Object, String> converter = converters.get(header);
            Collection last = (Collection)converter.convert(toAdd);
            Collection oldValue = (Collection)this.doGetObject(header, converter);
            Collection newValue = (Collection)last.getClass().newInstance();
            if (oldValue != null) {
                newValue.addAll(oldValue);
            } else {
                oldValue = (Collection)last.getClass().newInstance();
            }
            newValue.addAll(last);
            Converter<String, ? extends Object> formatter = formatters.get(header);
            this.doSetObject(header, oldValue, newValue, formatter);
            return header + ": " + formatter.convert(newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw Exceptions.duck(e);
        }
    }

    static {
        converters.put("Bundle-License", stringConverter);
        converters.put("Bundle-Category", stringConverter);
        converters.put("Bundle-Name", stringConverter);
        converters.put("Bundle-Description", stringConverter);
        converters.put("Bundle-Copyright", stringConverter);
        converters.put("Bundle-UpdateLocation", stringConverter);
        converters.put("Bundle-Vendor", stringConverter);
        converters.put("Bundle-ContactAddress", stringConverter);
        converters.put("Bundle-DocURL", stringConverter);
        converters.put("-buildpath", buildPathConverter);
        converters.put("-runbundles", clauseListConverter);
        converters.put("Bundle-SymbolicName", stringConverter);
        converters.put("Bundle-Version", stringConverter);
        converters.put("Bundle-Activator", stringConverter);
        converters.put("-output", stringConverter);
        converters.put("-sources", includedSourcesConverter);
        converters.put("Private-Package", listConverter);
        converters.put("-privatepackage", listConverter);
        converters.put("-classpath", listConverter);
        converters.put("Export-Package", exportPackageConverter);
        converters.put("Service-Component", serviceComponentConverter);
        converters.put("Import-Package", importPatternConverter);
        converters.put("-runframework", stringConverter);
        converters.put("-runfw", stringConverter);
        converters.put("-sub", listConverter);
        converters.put("-runproperties", propertiesConverter);
        converters.put("-runvm", stringConverter);
        converters.put("-runprogramargs", stringConverter);
        converters.put("Test-Cases", listConverter);
        converters.put("-runrequires", requirementListConverter);
        converters.put("-runee", eeConverter);
        converters.put("-runrepos", listConverter);
        converters.put("Bundle-Blueprint", headerClauseListConverter);
        converters.put("Include-Resource", listConverter);
        converters.put("-includeresource", listConverter);
        converters.put("-standalone", headerClauseListConverter);
        formatters.put("Bundle-License", newlineEscapeFormatter);
        formatters.put("Bundle-Category", newlineEscapeFormatter);
        formatters.put("Bundle-Name", newlineEscapeFormatter);
        formatters.put("Bundle-Description", newlineEscapeFormatter);
        formatters.put("Bundle-Copyright", newlineEscapeFormatter);
        formatters.put("Bundle-UpdateLocation", newlineEscapeFormatter);
        formatters.put("Bundle-Vendor", newlineEscapeFormatter);
        formatters.put("Bundle-ContactAddress", newlineEscapeFormatter);
        formatters.put("Bundle-DocURL", newlineEscapeFormatter);
        formatters.put("-buildpath", headerClauseListFormatter);
        formatters.put("-runbundles", headerClauseListFormatter);
        formatters.put("Bundle-SymbolicName", newlineEscapeFormatter);
        formatters.put("Bundle-Version", newlineEscapeFormatter);
        formatters.put("Bundle-Activator", newlineEscapeFormatter);
        formatters.put("-output", newlineEscapeFormatter);
        formatters.put("-sources", defaultFalseBoolFormatter);
        formatters.put("Private-Package", stringListFormatter);
        formatters.put("-privatepackage", stringListFormatter);
        formatters.put("-classpath", stringListFormatter);
        formatters.put("Export-Package", headerClauseListFormatter);
        formatters.put("Service-Component", headerClauseListFormatter);
        formatters.put("Import-Package", headerClauseListFormatter);
        formatters.put("-runframework", newlineEscapeFormatter);
        formatters.put("-runfw", newlineEscapeFormatter);
        formatters.put("-sub", stringListFormatter);
        formatters.put("-runproperties", propertiesFormatter);
        formatters.put("-runvm", newlineEscapeFormatter);
        formatters.put("-runprogramargs", newlineEscapeFormatter);
        formatters.put("Test-Cases", stringListFormatter);
        formatters.put("-runrequires", requirementListFormatter);
        formatters.put("-runee", eeFormatter);
        formatters.put("-runrepos", runReposFormatter);
        formatters.put("Bundle-Blueprint", headerClauseListFormatter);
        formatters.put("Include-Resource", stringListFormatter);
        formatters.put("-includeresource", stringListFormatter);
        formatters.put("-standalone", standaloneLinkListFormatter);
        converters.put("-plugin", headerClauseListConverter);
        formatters.put("-plugin", complexHeaderClauseListFormatter);
    }
}

