/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.maven.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.pax.url.maven.commons.MavenSettings;
import org.ops4j.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenSettingsImpl
implements MavenSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenSettingsImpl.class);
    private static final String LOCAL_REPOSITORY_TAG = "localRepository";
    private static final String SERVER_TAG = "servers/server";
    private static final String PROFILE_TAG = "profiles/profile";
    private static final String REPOSITORY_TAG = "repositories/repository";
    private static final String ACTIVE_PROFILES_TAG = "activeProfiles/activeProfile";
    private static final String PROXY_TAG = "proxies/proxy";
    private static final String MIRROR_TAG = "mirrors/mirror";
    private static final String FALLBACK_REPOSITORIES = "http://repo1.maven.org/maven2@id=central";
    private Document m_document;
    private URL m_settingsURL;
    private final boolean m_useFallbackRepositories;
    private String m_localRepository;
    private String m_repositories;
    private Map<String, Map<String, String>> m_proxySettings;
    private Map<String, Map<String, String>> m_mirrorsSettings;

    public MavenSettingsImpl(URL settingsURL, boolean useFallbackRepositories) {
        this.m_settingsURL = settingsURL;
        this.m_useFallbackRepositories = useFallbackRepositories;
        if (this.m_settingsURL == null) {
            this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getProperty("user.home") + "/.m2/settings.xml");
            if (this.m_settingsURL == null) {
                this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getProperty("maven.home") + "/conf/settings.xml");
                if (this.m_settingsURL == null) {
                    try {
                        this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getenv("M2_HOME") + "/conf/settings.xml");
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public MavenSettingsImpl(URL settingsURL) {
        this(settingsURL, false);
    }

    @Override
    public String getLocalRepository() {
        if (this.m_localRepository == null) {
            Element settingsElement;
            this.readSettings();
            if (this.m_document != null && (settingsElement = XmlUtils.getElement((Document)this.m_document, (String)LOCAL_REPOSITORY_TAG)) != null) {
                this.m_localRepository = XmlUtils.getTextContent((Node)settingsElement);
            }
            if (this.m_localRepository == null || this.m_localRepository.trim().length() == 0) {
                this.m_localRepository = System.getProperty("user.home") + "/.m2/repository";
            }
        }
        return this.m_localRepository;
    }

    @Override
    public String getRepositories() {
        if (this.m_repositories == null) {
            this.readSettings();
            if (this.m_document != null) {
                Set<String> activeProfiles = this.getActiveProfiles();
                HashMap<String, String> repositories = null;
                ArrayList<String> order = null;
                List profiles = XmlUtils.getElements((Document)this.m_document, (String)PROFILE_TAG);
                if (profiles != null) {
                    List servers;
                    for (Element profile : profiles) {
                        String profileId;
                        Element profileIdElement = XmlUtils.getElement((Element)profile, (String)"id");
                        if (profileIdElement == null || (profileId = XmlUtils.getTextContent((Node)profileIdElement)) == null) continue;
                        if (activeProfiles.contains(profileId)) {
                            List repos = XmlUtils.getElements((Element)profile, (String)REPOSITORY_TAG);
                            if (repos == null) continue;
                            for (Element repo : repos) {
                                String url;
                                Element element = XmlUtils.getElement((Element)repo, (String)"id");
                                if (element == null) continue;
                                String id = XmlUtils.getTextContent((Node)element);
                                element = XmlUtils.getElement((Element)repo, (String)"layout");
                                String layout = null;
                                if (element != null) {
                                    layout = XmlUtils.getTextContent((Node)element);
                                }
                                if (layout != null && !"default".equals(layout)) continue;
                                String snapshots = XmlUtils.getTextContentOfElement((Element)repo, (String)"snapshots/enabled");
                                String releases = XmlUtils.getTextContentOfElement((Element)repo, (String)"releases/enabled");
                                element = XmlUtils.getElement((Element)repo, (String)"url");
                                if (element == null || (url = XmlUtils.getTextContent((Node)element)) == null) continue;
                                if (repositories == null) {
                                    repositories = new HashMap<String, String>();
                                    order = new ArrayList<String>();
                                }
                                if (snapshots != null && Boolean.valueOf(snapshots).booleanValue()) {
                                    url = url + "@snapshots";
                                }
                                if (releases != null && !Boolean.valueOf(releases).booleanValue()) {
                                    url = url + "@noreleases";
                                }
                                url = url + "@id=" + id;
                                repositories.put(id, url);
                                order.add(id);
                            }
                            continue;
                        }
                        LOGGER.debug("Profile [" + profileId + "] is inactive (ignored).");
                    }
                    if (repositories != null && (servers = XmlUtils.getElements((Document)this.m_document, (String)SERVER_TAG)) != null) {
                        for (Element server : servers) {
                            String password;
                            String username;
                            String id;
                            String repository;
                            Element element = XmlUtils.getElement((Element)server, (String)"id");
                            if (element == null || (repository = (String)repositories.get(id = XmlUtils.getTextContent((Node)element))) == null || !repository.contains("://") || (element = XmlUtils.getElement((Element)server, (String)"username")) == null || (username = XmlUtils.getTextContent((Node)element)) == null) continue;
                            element = XmlUtils.getElement((Element)server, (String)"password");
                            if (element != null && (password = XmlUtils.getTextContent((Node)element)) != null) {
                                username = username + ":" + password;
                            }
                            String repo = "://" + username + "@";
                            repo = Matcher.quoteReplacement(repo);
                            repositories.put(id, repository.replaceFirst("://", repo));
                        }
                    }
                    StringBuilder builder = new StringBuilder();
                    if (order != null) {
                        for (String repositoryId : order) {
                            if (builder.length() > 0) {
                                builder.append(",");
                            }
                            builder.append((String)repositories.get(repositoryId));
                        }
                    }
                    this.m_repositories = builder.toString();
                }
            }
            if (this.m_useFallbackRepositories) {
                this.m_repositories = this.m_repositories == null || this.m_repositories.length() == 0 ? FALLBACK_REPOSITORIES : this.m_repositories + "," + FALLBACK_REPOSITORIES;
            }
        }
        return this.m_repositories;
    }

    private Set<String> getActiveProfiles() {
        HashSet<String> ret = new HashSet<String>();
        List activeProfiles = XmlUtils.getElements((Document)this.m_document, (String)ACTIVE_PROFILES_TAG);
        if (activeProfiles != null) {
            for (Element active : activeProfiles) {
                ret.add(XmlUtils.getTextContent((Node)active));
            }
        }
        return ret;
    }

    private void readSettings() {
        if (this.m_document == null && this.m_settingsURL != null) {
            try {
                this.m_document = XmlUtils.parseDoc((InputStream)this.m_settingsURL.openStream());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
        }
    }

    private static URL safeGetFile(String filePath) {
        File file;
        if (filePath != null && (file = new File(filePath)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSetting(Element element, String settingName, String defaultSetting) {
        String setting = XmlUtils.getTextContentOfElement((Element)element, (String)settingName);
        if (setting == null) {
            return defaultSetting;
        }
        return setting;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings() {
        if (this.m_proxySettings == null) {
            List proxies;
            this.m_proxySettings = new HashMap<String, Map<String, String>>();
            this.readSettings();
            if (this.m_document != null && (proxies = XmlUtils.getElements((Document)this.m_document, (String)PROXY_TAG)) != null) {
                for (Element proxy : proxies) {
                    String active = this.getSetting(proxy, "active", "false");
                    String protocol = this.getSetting(proxy, "protocol", "http");
                    if (this.m_proxySettings.containsKey(protocol) && !"true".equalsIgnoreCase(active)) continue;
                    HashMap<String, String> proxyDetails = new HashMap<String, String>();
                    proxyDetails.put("user", this.getSetting(proxy, "username", null));
                    proxyDetails.put("pass", this.getSetting(proxy, "password", null));
                    proxyDetails.put("host", this.getSetting(proxy, "host", "127.0.0.1"));
                    proxyDetails.put("port", this.getSetting(proxy, "port", "80"));
                    proxyDetails.put("nonProxyHosts", this.getSetting(proxy, "nonProxyHosts", ""));
                    proxyDetails.put("protocol", protocol);
                    this.m_proxySettings.put(protocol, proxyDetails);
                }
            }
        }
        return Collections.unmodifiableMap(this.m_proxySettings);
    }

    @Override
    public Map<String, Map<String, String>> getMirrorSettings() {
        if (this.m_mirrorsSettings == null) {
            List mirrors;
            this.m_mirrorsSettings = new HashMap<String, Map<String, String>>();
            this.readSettings();
            if (this.m_document != null && (mirrors = XmlUtils.getElements((Document)this.m_document, (String)MIRROR_TAG)) != null) {
                for (Element mirror : mirrors) {
                    String id = this.getSetting(mirror, "id", "");
                    if (this.m_mirrorsSettings.containsKey(id)) continue;
                    HashMap<String, String> proxyDetails = new HashMap<String, String>();
                    proxyDetails.put("id", id);
                    String mirrorRepoUrl = this.getSetting(mirror, "url", "");
                    List servers = XmlUtils.getElements((Document)this.m_document, (String)SERVER_TAG);
                    if (servers != null) {
                        for (Element server : servers) {
                            String password;
                            String username;
                            String serverId;
                            Element element = XmlUtils.getElement((Element)server, (String)"id");
                            if (element == null || !id.equals(serverId = XmlUtils.getTextContent((Node)element)) || !mirrorRepoUrl.contains("://") || (element = XmlUtils.getElement((Element)server, (String)"username")) == null || (username = XmlUtils.getTextContent((Node)element)) == null) continue;
                            element = XmlUtils.getElement((Element)server, (String)"password");
                            if (element != null && (password = XmlUtils.getTextContent((Node)element)) != null) {
                                username = username + ":" + password;
                            }
                            String repo = "://" + username + "@";
                            repo = Matcher.quoteReplacement(repo);
                            mirrorRepoUrl = mirrorRepoUrl.replaceFirst("://", repo);
                        }
                    }
                    proxyDetails.put("url", mirrorRepoUrl);
                    proxyDetails.put("mirrorOf", this.getSetting(mirror, "mirrorOf", "default"));
                    proxyDetails.put("layout", this.getSetting(mirror, "layout", ""));
                    proxyDetails.put("mirrorOfLayouts", this.getSetting(mirror, "mirrorOfLayouts", ""));
                    this.m_mirrorsSettings.put(id, proxyDetails);
                }
            }
        }
        return Collections.unmodifiableMap(this.m_mirrorsSettings);
    }
}

