/*
 * Copyright 2008 Alin Dreghiciu.
 *
 * Licensed  under the  Apache License,  Version 2.0  (the "License");
 * you may not use  this file  except in  compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed  under the  License is distributed on an "AS IS" BASIS,
 * WITHOUT  WARRANTIES OR CONDITIONS  OF ANY KIND, either  express  or
 * implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ops4j.pax.url.cache.internal;

import java.io.File;

/**
 * "cache:" protocol configuration.
 *
 * @author Alin Dreghiciu
 * @since 0.6.0, June 02, 2009
 */
public interface Configuration
{

    /**
     * Returns the root directory to be used for storage.
     * Defaults to "./cache".
     *
     * @return the root directory
     */
    File getWorkingDirectory();

}