/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.named.providers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import shaded.org.eclipse.aether.named.support.FileLockNamedLock;
import shaded.org.eclipse.aether.named.support.NamedLockFactorySupport;
import shaded.org.eclipse.aether.named.support.NamedLockSupport;
import shaded.org.eclipse.aether.named.support.Retry;

@Singleton
@Named(value="file-lock")
public class FileLockNamedLockFactory
extends NamedLockFactorySupport {
    public static final String NAME = "file-lock";
    private static final boolean DELETE_LOCK_FILES = Boolean.parseBoolean(System.getProperty("aether.named.file-lock.deleteLockFiles", Boolean.TRUE.toString()));
    private static final int ATTEMPTS = Integer.parseInt(System.getProperty("aether.named.file-lock.attempts", "5"));
    private static final long SLEEP_MILLIS = Long.parseLong(System.getProperty("aether.named.file-lock.sleepMillis", "50"));
    private final ConcurrentMap<String, FileChannel> fileChannels = new ConcurrentHashMap<String, FileChannel>();

    @Override
    protected NamedLockSupport createLock(String name) {
        Path path = Paths.get(name, new String[0]);
        FileChannel fileChannel = this.fileChannels.computeIfAbsent(name, k -> {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                FileChannel channel = Retry.retry(ATTEMPTS, SLEEP_MILLIS, () -> {
                    try {
                        if (DELETE_LOCK_FILES) {
                            return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
                        }
                        return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                    }
                    catch (AccessDeniedException e) {
                        return null;
                    }
                }, null, null);
                if (channel == null) {
                    throw new IllegalStateException("Could not open file channel for '" + name + "' after " + ATTEMPTS + " attempts; giving up");
                }
                return channel;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while opening file channel for '" + name + "'", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open file channel for '" + name + "'", e);
            }
        });
        return new FileLockNamedLock(name, fileChannel, this);
    }

    @Override
    protected void destroyLock(String name) {
        FileChannel fileChannel = (FileChannel)this.fileChannels.remove(name);
        if (fileChannel == null) {
            throw new IllegalStateException("File channel expected, but does not exist: " + name);
        }
        try {
            fileChannel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close file channel for '" + name + "'", e);
        }
    }
}

