/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MirrorInfo;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.ops4j.pax.url.mvn.internal.PaxRepositorySystemSupplier;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import shaded.org.apache.maven.artifact.repository.metadata.Versioning;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.eclipse.aether.RepositoryException;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.installation.InstallRequest;
import shaded.org.eclipse.aether.metadata.DefaultMetadata;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.Authentication;
import shaded.org.eclipse.aether.repository.AuthenticationSelector;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.MirrorSelector;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.ProxySelector;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.eclipse.aether.resolution.MetadataRequest;
import shaded.org.eclipse.aether.resolution.MetadataResult;
import shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import shaded.org.eclipse.aether.resolution.VersionRangeResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeResult;
import shaded.org.eclipse.aether.transfer.ArtifactNotFoundException;
import shaded.org.eclipse.aether.transfer.ArtifactTransferException;
import shaded.org.eclipse.aether.transfer.MetadataNotFoundException;
import shaded.org.eclipse.aether.transfer.MetadataTransferException;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import shaded.org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import shaded.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import shaded.org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import shaded.org.eclipse.aether.util.version.GenericVersion;
import shaded.org.eclipse.aether.util.version.GenericVersionConstraint;
import shaded.org.eclipse.aether.util.version.GenericVersionScheme;
import shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import shaded.org.eclipse.aether.version.Version;
import shaded.org.ops4j.lang.NullArgumentException;

public class AetherBasedResolver
implements MavenResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AetherBasedResolver.class);
    private static final String LATEST_VERSION_RANGE = "[0.0,)";
    private static final String ENHANCED_REPOSITORY_TYPE = "default";
    private static final String SESSION_CHECKS = "updateCheckManager.checks";
    private final MavenConfiguration m_config;
    private final Settings m_settings;
    private final LocalRepository m_localRepository;
    boolean m_useSystemProperties;
    private final RepositorySystem m_repoSystem;
    private final RepositorySystemSession m_defaultSession;
    private final MirrorSelector m_mirrorSelector;
    private final ProxySelector m_proxySelector;
    private final AuthenticationSelector m_authenticationSelector;
    private final ConcurrentMap<LocalRepository, Deque<RepositorySystemSession>> sessions = new ConcurrentHashMap<LocalRepository, Deque<RepositorySystemSession>>();
    private final AtomicBoolean m_shutdown = new AtomicBoolean(false);
    private static final Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String v1, String v2) {
            try {
                GenericVersion vv1 = new GenericVersionScheme().parseVersion(v1);
                GenericVersion vv2 = new GenericVersionScheme().parseVersion(v2);
                return vv1.compareTo(vv2);
            }
            catch (Exception e) {
                return v1.compareTo(v2);
            }
        }
    };
    private static final Comparator<SnapshotVersion> SNAPSHOT_VERSION_COMPARATOR = new Comparator<SnapshotVersion>(){

        @Override
        public int compare(SnapshotVersion o1, SnapshotVersion o2) {
            int c = VERSION_COMPARATOR.compare(o1.getVersion(), o2.getVersion());
            if (c == 0) {
                c = o1.getExtension().compareTo(o2.getExtension());
            }
            if (c == 0) {
                c = o1.getClassifier().compareTo(o2.getClassifier());
            }
            return c;
        }
    };

    public AetherBasedResolver(MavenConfiguration configuration) {
        this(configuration, null);
    }

    public AetherBasedResolver(MavenConfiguration configuration, MirrorInfo mirror) {
        NullArgumentException.validateNotNull(configuration, "Maven configuration");
        this.m_config = configuration;
        this.m_settings = configuration.getSettings();
        File localRepository = this.m_config.getLocalRepository();
        this.m_localRepository = localRepository != null ? new LocalRepository(localRepository, ENHANCED_REPOSITORY_TYPE) : null;
        this.m_useSystemProperties = this.m_config.getProperty("useSystemProperties", false, Boolean.TYPE);
        this.m_repoSystem = this.newRepositorySystem();
        this.m_proxySelector = this.configureProxySelector();
        this.m_mirrorSelector = this.configureMirrorSelector(mirror);
        this.m_authenticationSelector = this.configureGlobalAuthenticationSelector();
        this.m_defaultSession = this.newDefaultRepositorySystemSession();
    }

    @Override
    public void close() throws IOException {
        this.m_repoSystem.shutdown();
        this.m_shutdown.set(true);
        this.sessions.clear();
    }

    private ProxySelector configureProxySelector() {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (shaded.org.apache.maven.settings.Proxy proxy : this.m_settings.getProxies()) {
            if (!proxy.isActive()) continue;
            String nonProxyHosts = proxy.getNonProxyHosts();
            Authentication auth = this.getProxyAuthentication(proxy);
            Proxy proxyObj = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
            proxySelector.add(proxyObj, nonProxyHosts);
        }
        return proxySelector;
    }

    private Authentication getProxyAuthentication(shaded.org.apache.maven.settings.Proxy proxy) {
        if (proxy.getUsername() != null) {
            return new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return null;
    }

    private MirrorSelector configureMirrorSelector(MirrorInfo mirror) {
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror m : this.m_settings.getMirrors()) {
            mirrorSelector.add(m.getId(), m.getUrl(), null, false, m.isBlocked(), m.getMirrorOf(), m.getMirrorOfLayouts());
        }
        if (mirror != null) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), null, false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return mirrorSelector;
    }

    private AuthenticationSelector configureGlobalAuthenticationSelector() {
        DefaultAuthenticationSelector defaultSelector = new DefaultAuthenticationSelector();
        for (Server server : this.m_settings.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultSelector.add(server.getId(), authBuilder.build());
        }
        return new ConservativeAuthenticationSelector(defaultSelector);
    }

    @Override
    public File resolve(String url) throws IOException {
        return this.resolve(url, null);
    }

    @Override
    public File resolve(String url, Exception previousException) throws IOException {
        if (!url.startsWith("mvn:")) {
            throw new IllegalArgumentException("url should be a mvn based url");
        }
        url = url.substring(4);
        Parser parser = new Parser(url);
        return this.resolve(parser.getGroup(), parser.getArtifact(), parser.getClassifier(), parser.getType(), parser.getVersion(), parser.getRepositoryURL(), previousException);
    }

    @Override
    public File resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        return this.resolve(groupId, artifactId, classifier, extension, version, null, null);
    }

    @Override
    public File resolve(String groupId, String artifactId, String classifier, String extension, String version, Exception previousException) throws IOException {
        return this.resolve(groupId, artifactId, classifier, extension, version, null, previousException);
    }

    public File resolve(String groupId, String artifactId, String classifier, String extension, String version, MavenRepositoryURL url, Exception previousException) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        return this.resolve(artifact, url, previousException);
    }

    public File resolve(Artifact artifact, MavenRepositoryURL url, Exception previousException) throws IOException {
        File resolved;
        List<LocalRepositoryWithConfig> defaultRepositories = this.selectDefaultRepositories();
        List<RemoteRepository> remoteRepositories = this.selectRemoteRepositories(url);
        if (previousException != null) {
            ArtifactResult result;
            LinkedList<RemoteRepository> altered = new LinkedList<RemoteRepository>();
            RepositoryException repositoryException = this.findAetherException(previousException);
            if (repositoryException instanceof ArtifactResolutionException && (result = ((ArtifactResolutionException)repositoryException).getResult()) != null && result.getRequest() != null && result.getRequest().getArtifact().equals(artifact)) {
                for (Exception exception : result.getExceptions()) {
                    RemoteRepository repository;
                    RepositoryException singleException = this.findAetherException(exception);
                    if (!(singleException instanceof ArtifactTransferException) || (repository = ((ArtifactTransferException)singleException).getRepository()) == null) continue;
                    MavenResolver.RetryChance chance = this.isRetryableException(singleException);
                    if (chance == MavenResolver.RetryChance.NEVER) {
                        LOG.debug("Removing " + String.valueOf(repository) + " from list of repositories, previous exception: " + singleException.getClass().getName() + ": " + singleException.getMessage());
                        continue;
                    }
                    altered.add(repository);
                }
                remoteRepositories = altered;
            }
        }
        if ((resolved = this.resolve(defaultRepositories, remoteRepositories, artifact)) != null) {
            LOG.debug("Resolved ({}) as {}", (Object)artifact.toString(), (Object)resolved.getAbsolutePath());
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File resolve(List<LocalRepositoryWithConfig> defaultRepositories, List<RemoteRepository> remoteRepositories, Artifact artifact) throws IOException {
        RepositorySystemSession session;
        if (artifact.getExtension().isEmpty()) {
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), "jar", artifact.getVersion());
        }
        if (artifact.getVersion().equals("LATEST")) {
            artifact = artifact.setVersion(LATEST_VERSION_RANGE);
        }
        try {
            GenericVersionScheme genericVersionScheme = new GenericVersionScheme();
            GenericVersionConstraint vc = genericVersionScheme.parseVersionConstraint(artifact.getVersion());
            for (LocalRepositoryWithConfig repo : defaultRepositories) {
                RepositorySystemSession session2 = this.findOrCreateSession(repo);
                if (session2 == null) {
                    throw new IllegalStateException("No session configured for default repository " + String.valueOf(repo));
                }
                try {
                    if (vc.getVersion() == null && vc.getRange() != null) {
                        DefaultMetadata metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
                        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
                        String path = lrm.getPathForLocalMetadata(metadata);
                        File metadataLocation = new File(lrm.getRepository().getBasedir(), path).getParentFile();
                        TreeSet<GenericVersion> versions = new TreeSet<GenericVersion>();
                        if (metadataLocation.isDirectory()) {
                            if (!new File(metadataLocation, "maven-metadata.xml").isFile()) {
                                String[] versionDirs = metadataLocation.list();
                                if (versionDirs != null) {
                                    for (String vd : versionDirs) {
                                        GenericVersion ver = genericVersionScheme.parseVersion(vd);
                                        if (!vc.containsVersion(ver)) continue;
                                        versions.add(ver);
                                    }
                                }
                                VersionRangeResult vrr = new VersionRangeResult(new VersionRangeRequest());
                                vrr.setVersions(new LinkedList<Version>(versions));
                                if (vrr.getHighestVersion() != null) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Resolved version range {} as {}", (Object)vc.getRange(), (Object)vrr.getHighestVersion().toString());
                                    }
                                    vc = new GenericVersionScheme().parseVersionConstraint(vrr.getHighestVersion().toString());
                                    artifact = artifact.setVersion(vc.getVersion().toString());
                                }
                            } else {
                                try {
                                    Version v;
                                    VersionRangeResult versionResult = this.m_repoSystem.resolveVersionRange(session2, new VersionRangeRequest(artifact, null, null));
                                    if (versionResult != null && (v = versionResult.getHighestVersion()) != null) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("Resolved version range {} as {}", (Object)vc.getRange(), (Object)v.toString());
                                        }
                                        vc = new GenericVersionScheme().parseVersionConstraint(v.toString());
                                        artifact = artifact.setVersion(vc.getVersion().toString());
                                    }
                                }
                                catch (VersionRangeResolutionException versionRangeResolutionException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (vc.getVersion() == null) continue;
                    try {
                        File file = this.m_repoSystem.resolveArtifact(session2, new ArtifactRequest(artifact, null, null)).getArtifact().getFile();
                        return file;
                    }
                    catch (ArtifactResolutionException artifactResolutionException) {}
                }
                finally {
                    this.releaseSession(session2);
                }
            }
        }
        catch (InvalidVersionSpecificationException genericVersionScheme) {
            // empty catch block
        }
        if ((session = this.findOrCreateSession(null)) == null) {
            LOG.debug("Skipping remote repository resolution - no local repository configured");
            return null;
        }
        try {
            List<RemoteRepository> configuredRepositories = this.assignMirrorsAndProxies(session, remoteRepositories);
            artifact = this.resolveLatestVersionRange(session, configuredRepositories, artifact);
            File file = this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, configuredRepositories, null)).getArtifact().getFile();
            return file;
        }
        catch (ArtifactResolutionException e) {
            ArtifactResolutionException artifactResolutionException = new ArtifactResolutionException(e.getResults(), "Error resolving artifact " + artifact.toString(), null);
            throw this.configureIOException(artifactResolutionException, e, e.getResult().getExceptions());
        }
        catch (VersionRangeResolutionException e) {
            VersionRangeResolutionException versionRangeResolutionException = new VersionRangeResolutionException(e.getResult(), "Error resolving artifact " + artifact.toString(), null);
            throw this.configureIOException(versionRangeResolutionException, e, e.getResult().getExceptions());
        }
        finally {
            this.releaseSession(session);
        }
    }

    @Override
    public File resolveMetadata(String groupId, String artifactId, String type, String version) throws IOException {
        return this.resolveMetadata(groupId, artifactId, type, version, null);
    }

    @Override
    public File resolveMetadata(String groupId, String artifactId, String type, String version, Exception previousException) throws IOException {
        RepositorySystemSession session = this.findOrCreateSession(null);
        if (session == null) {
            LOG.warn("Can't resolve metadata without configured local repository");
            return null;
        }
        try {
            DefaultMetadata metadata = new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT);
            ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
            List<RemoteRepository> remoteRepositories = this.selectRemoteRepositories(null);
            List<RemoteRepository> configuredRepositories = this.assignMirrorsAndProxies(session, remoteRepositories);
            for (RemoteRepository repository : configuredRepositories) {
                MetadataRequest request = new MetadataRequest(metadata, repository, null);
                request.setFavorLocalRepository(false);
                requests.add(request);
            }
            MetadataRequest request = new MetadataRequest(metadata, null, null);
            request.setFavorLocalRepository(true);
            requests.add(request);
            Metadata mr = new Metadata();
            mr.setModelVersion("1.1.0");
            mr.setGroupId(metadata.getGroupId());
            mr.setArtifactId(metadata.getArtifactId());
            mr.setVersioning(new Versioning());
            boolean merged = false;
            List<MetadataResult> results = this.m_repoSystem.resolveMetadata(session, requests);
            for (MetadataResult result : results) {
                if (result.getMetadata() == null || result.getMetadata().getFile() == null) continue;
                FileInputStream fis = new FileInputStream(result.getMetadata().getFile());
                Metadata m = new MetadataXpp3Reader().read(fis, false);
                fis.close();
                if (m.getVersioning() != null) {
                    mr.getVersioning().setLastUpdated(this.latestTimestamp(mr.getVersioning().getLastUpdated(), m.getVersioning().getLastUpdated()));
                    mr.getVersioning().setLatest(this.latestVersion(mr.getVersioning().getLatest(), m.getVersioning().getLatest()));
                    mr.getVersioning().setRelease(this.latestVersion(mr.getVersioning().getRelease(), m.getVersioning().getRelease()));
                    for (String v : m.getVersioning().getVersions()) {
                        if (mr.getVersioning().getVersions().contains(v)) continue;
                        mr.getVersioning().getVersions().add(v);
                    }
                    mr.getVersioning().getSnapshotVersions().addAll(m.getVersioning().getSnapshotVersions());
                }
                merged = true;
            }
            if (merged) {
                mr.getVersioning().getVersions().sort(VERSION_COMPARATOR);
                mr.getVersioning().getSnapshotVersions().sort(SNAPSHOT_VERSION_COMPARATOR);
                File tmpFile = Files.createTempFile("mvn-", ".tmp", new FileAttribute[0]).toFile();
                try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                    new MetadataXpp3Writer().write(fos, mr);
                }
                File file = tmpFile;
                return file;
            }
            Iterator<MetadataResult> iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new IOException("Unable to resolve metadata", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    private String latestTimestamp(String t1, String t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.compareTo(t2) < 0 ? t2 : t1;
    }

    private String latestVersion(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return VERSION_COMPARATOR.compare(v1, v2) < 0 ? v2 : v1;
    }

    @Override
    public void upload(String groupId, String artifactId, String classifier, String extension, String version, File file) throws IOException {
        RepositorySystemSession session = this.findOrCreateSession(null);
        if (session == null) {
            return;
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, file);
            InstallRequest request = new InstallRequest();
            request.addArtifact(artifact);
            this.m_repoSystem.install(session, request);
        }
        catch (Exception e) {
            throw new IOException("Unable to install artifact", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    @Override
    public void uploadMetadata(String groupId, String artifactId, String type, String version, File artifact) throws IOException {
        RepositorySystemSession session = this.findOrCreateSession(null);
        if (session == null) {
            return;
        }
        try {
            DefaultMetadata metadata = new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT, artifact);
            InstallRequest request = new InstallRequest();
            request.addMetadata(metadata);
            this.m_repoSystem.install(session, request);
        }
        catch (Exception e) {
            throw new IOException("Unable to install metadata", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    @Override
    public MavenResolver.RetryChance isRetryableException(Exception exception) {
        MavenResolver.RetryChance retry = MavenResolver.RetryChance.NEVER;
        RepositoryException aetherException = this.findAetherException(exception);
        if (aetherException instanceof ArtifactResolutionException) {
            ArtifactResolutionException resolutionException = (ArtifactResolutionException)aetherException;
            if (resolutionException.getResult() != null) {
                for (Exception ex : resolutionException.getResult().getExceptions()) {
                    MavenResolver.RetryChance singleRetry = this.isRetryableException(ex);
                    if (retry.chance() >= singleRetry.chance()) continue;
                    retry = singleRetry;
                }
            }
        } else if (aetherException != null) {
            if (aetherException instanceof ArtifactNotFoundException) {
                retry = MavenResolver.RetryChance.NEVER;
            } else if (aetherException instanceof MetadataNotFoundException) {
                retry = MavenResolver.RetryChance.NEVER;
            } else if (aetherException instanceof ArtifactTransferException || aetherException instanceof MetadataTransferException) {
                Throwable root = this.rootException(aetherException);
                if (root instanceof SocketTimeoutException) {
                    retry = MavenResolver.RetryChance.LOW;
                } else if (root instanceof ConnectException) {
                    retry = MavenResolver.RetryChance.NEVER;
                } else if (root instanceof NoRouteToHostException) {
                    retry = MavenResolver.RetryChance.NEVER;
                }
            } else {
                retry = MavenResolver.RetryChance.NEVER;
            }
        } else {
            retry = MavenResolver.RetryChance.UNKNOWN;
        }
        return retry;
    }

    protected RepositoryException findAetherException(Exception e) {
        Throwable ex;
        for (ex = e; ex != null && !(ex instanceof RepositoryException); ex = ex.getCause()) {
        }
        return ex == null ? null : (RepositoryException)ex;
    }

    protected Throwable rootException(Exception ex) {
        Throwable root = ex;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    private IOException configureIOException(Exception newMavenException, Exception cause, List<Exception> resultExceptions) {
        newMavenException.setStackTrace(cause.getStackTrace());
        ArrayList<String> messages = new ArrayList<String>(resultExceptions.size());
        ArrayList<Exception> suppressed = new ArrayList<Exception>();
        for (Exception ex : resultExceptions) {
            messages.add(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            suppressed.add(ex);
        }
        IOException exception = new IOException(newMavenException.getMessage() + ": " + String.valueOf(messages), newMavenException);
        for (Exception ex : suppressed) {
            exception.addSuppressed(ex);
        }
        LOG.warn(exception.getMessage(), (Throwable)exception);
        return exception;
    }

    private Artifact resolveLatestVersionRange(RepositorySystemSession session, List<RemoteRepository> repositories, Artifact artifact) throws VersionRangeResolutionException {
        VersionRangeResult versionResult = this.m_repoSystem.resolveVersionRange(session, new VersionRangeRequest(artifact, repositories, null));
        if (versionResult != null) {
            Version v = versionResult.getHighestVersion();
            if (v != null) {
                artifact = artifact.setVersion(v.toString());
            } else {
                throw new VersionRangeResolutionException(versionResult, "No highest version found for " + String.valueOf(artifact));
            }
        }
        return artifact;
    }

    List<LocalRepositoryWithConfig> selectDefaultRepositories() {
        ArrayList<LocalRepositoryWithConfig> list = new ArrayList<LocalRepositoryWithConfig>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getDefaultRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("Invalid default repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.getFile() == null) {
                LOG.warn("Invalid default repository {}. Only local directories are supported.", (Object)mavenRepositoryURL);
                continue;
            }
            if (mavenRepositoryURL.isMulti()) {
                this.selectDefaultRepositories(list, mavenRepositoryURL, mavenRepositoryURL.getFile());
                continue;
            }
            this.selectDefaultRepository(list, mavenRepositoryURL);
        }
        return list;
    }

    private void selectDefaultRepositories(List<LocalRepositoryWithConfig> list, MavenRepositoryURL parentRepo, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.warn("Repository marked with @multi does not resolve to a directory: {}", (Object)parentDir);
            return;
        }
        for (File repo : AetherBasedResolver.getSortedChildDirectories(parentDir)) {
            MavenRepositoryURL child = new MavenRepositoryURL(parentRepo, repo);
            String repoURI = child.getURI().toString() + "@" + child.getId();
            LOG.debug("Adding default repository from multi dir: {}", (Object)repoURI);
            this.selectDefaultRepository(list, child);
        }
    }

    private void selectDefaultRepository(List<LocalRepositoryWithConfig> list, MavenRepositoryURL repo) {
        if (repo.getFile() != null) {
            LocalRepository local = new LocalRepository(repo.getFile(), ENHANCED_REPOSITORY_TYPE);
            list.add(new LocalRepositoryWithConfig(local, repo));
        }
    }

    List<RemoteRepository> selectRemoteRepositories(MavenRepositoryURL extraRepository) {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("Invalid remote repository URLs", (Throwable)exc);
        }
        ArrayList toCheck = new ArrayList(urls);
        if (extraRepository != null) {
            toCheck.add(extraRepository);
        }
        for (MavenRepositoryURL r : toCheck) {
            if (r.isSplit()) {
                LOG.warn("Remote repository {} is configured with @split option. Split repositories can only be default or local. Ignoring.", (Object)r);
                continue;
            }
            if (r.isMulti()) {
                if (r.getFile() == null) {
                    LOG.warn("Remote repository {} is marked as @multi repository, but is not using file: protocol", (Object)r);
                    continue;
                }
                this.selectRemoteRepositories(list, r.getFile());
                continue;
            }
            this.selectRemoteRepository(list, r);
        }
        return list;
    }

    private void selectRemoteRepositories(List<RemoteRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: {}", (Object)parentDir);
            return;
        }
        for (File repo : AetherBasedResolver.getSortedChildDirectories(parentDir)) {
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding remote repository from multi dir: {}", (Object)repoURI);
                this.selectRemoteRepository(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving remote repository url of a @multi directory {}", (Object)repo.toURI());
            }
        }
    }

    private void selectRemoteRepository(List<RemoteRepository> list, MavenRepositoryURL repo) {
        String snapshotsChecksumPolicy;
        String releasesChecksumPolicy;
        if (repo.getId() == null) {
            throw new IllegalArgumentException("RepositoryURL doesn't have ID configured: " + String.valueOf(repo));
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), ENHANCED_REPOSITORY_TYPE, repo.getURI().toString());
        String releasesUpdatePolicy = repo.getReleasesUpdatePolicy();
        if ((releasesUpdatePolicy == null || releasesUpdatePolicy.isEmpty()) && ((releasesUpdatePolicy = this.m_config.getGlobalUpdatePolicy()) == null || releasesUpdatePolicy.isEmpty())) {
            releasesUpdatePolicy = "never";
        }
        if (((releasesChecksumPolicy = repo.getReleasesChecksumPolicy()) == null || releasesChecksumPolicy.isEmpty()) && ((releasesChecksumPolicy = this.m_config.getGlobalChecksumPolicy()) == null || releasesChecksumPolicy.isEmpty())) {
            releasesChecksumPolicy = "warn";
        }
        RepositoryPolicy releasePolicy = new RepositoryPolicy(repo.isReleasesEnabled(), releasesUpdatePolicy, releasesChecksumPolicy);
        String snapshotsUpdatePolicy = repo.getSnapshotsUpdatePolicy();
        if ((snapshotsUpdatePolicy == null || snapshotsUpdatePolicy.isEmpty()) && ((snapshotsUpdatePolicy = this.m_config.getGlobalUpdatePolicy()) == null || snapshotsUpdatePolicy.isEmpty())) {
            snapshotsUpdatePolicy = "daily";
        }
        if (((snapshotsChecksumPolicy = repo.getSnapshotsChecksumPolicy()) == null || snapshotsChecksumPolicy.isEmpty()) && ((snapshotsChecksumPolicy = this.m_config.getGlobalChecksumPolicy()) == null || snapshotsChecksumPolicy.isEmpty())) {
            snapshotsChecksumPolicy = "warn";
        }
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repo.isSnapshotsEnabled(), snapshotsUpdatePolicy, snapshotsChecksumPolicy);
        builder.setReleasePolicy(releasePolicy);
        builder.setSnapshotPolicy(snapshotPolicy);
        if (repo.getUsername() != null && repo.getPassword() != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(repo.getUsername()).addPassword(repo.getPassword()).build());
        }
        list.add(builder.build());
    }

    private static File[] getSortedChildDirectories(File parent) {
        File[] files = parent.listFiles(File::isDirectory);
        if (files == null) {
            return new File[0];
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return files;
    }

    public List<RemoteRepository> assignMirrorsAndProxies(RepositorySystemSession session, List<RemoteRepository> repositories) {
        RepositorySystemSession s = session != null ? session : this.m_defaultSession;
        return this.m_repoSystem.newResolutionRepositories(s, repositories);
    }

    private RepositorySystem newRepositorySystem() {
        return new PaxRepositorySystemSupplier().get();
    }

    private RepositorySystemSession findOrCreateSession(LocalRepositoryWithConfig repo) {
        Deque deque;
        if (repo == null) {
            if (this.m_localRepository == null) {
                return null;
            }
            repo = new LocalRepositoryWithConfig(this.m_localRepository, this.m_config.getLocalMavenRepositoryURL());
        }
        RepositorySystemSession session = null;
        if (!this.m_shutdown.get() && (deque = (Deque)this.sessions.get(repo.repository)) != null) {
            session = (RepositorySystemSession)deque.pollFirst();
        }
        if (session == null) {
            session = this.newRepositorySystemSession(repo);
        }
        return session;
    }

    private void releaseSession(RepositorySystemSession session) {
        if (!this.m_shutdown.get()) {
            LocalRepository repo = session.getLocalRepository();
            Deque deque = (Deque)this.sessions.get(repo);
            if (deque == null) {
                this.sessions.putIfAbsent(repo, new ConcurrentLinkedDeque());
                deque = (Deque)this.sessions.get(repo);
            }
            session.getData().set(SESSION_CHECKS, null);
            deque.add(session);
        }
    }

    private RepositorySystemSession newRepositorySystemSession(LocalRepositoryWithConfig repo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        MavenRepositoryURL repoURL = repo.repositoryURL;
        session.setConfigProperty("aether.enhancedLocalRepository.split", repoURL.isSplit());
        session.setConfigProperty("aether.enhancedLocalRepository.splitLocal", repoURL.isSplitLocal());
        session.setConfigProperty("aether.enhancedLocalRepository.splitRemote", repoURL.isSplitRemote());
        session.setConfigProperty("aether.enhancedLocalRepository.splitRemoteRepository", repoURL.isSplitRemoteRepository());
        session.setConfigProperty("aether.enhancedLocalRepository.splitRemoteRepositoryLast", repoURL.isSplitRemoteRepositoryLast());
        session.setConfigProperty("aether.enhancedLocalRepository.localPrefix", repoURL.getSplitLocalPrefix());
        session.setConfigProperty("aether.enhancedLocalRepository.remotePrefix", repoURL.getSplitRemotePrefix());
        session.setConfigProperty("aether.enhancedLocalRepository.releasesPrefix", repoURL.getSplitReleasesPrefix());
        session.setConfigProperty("aether.enhancedLocalRepository.snapshotsPrefix", repoURL.getSplitSnapshotsPrefix());
        session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, repo.repository));
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        session.setAuthenticationSelector(this.m_authenticationSelector);
        session.setOffline(this.m_config.isOffline());
        session.setConfigProperty("aether.interactive", false);
        session.setConfigProperty("aether.connector.http.preemptiveAuth", true);
        session.setConfigProperty("aether.connector.basic.threads", 3);
        session.setConfigProperty("aether.dependencyCollector.impl", "df");
        session.setConfigProperty("aether.connector.userAgent", "Pax URL");
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(false, false));
        boolean updateReleases = this.m_config.getProperty("updateReleases", false, Boolean.class);
        session.setConfigProperty("paxUrlAether.updateReleases", updateReleases);
        session.setUpdatePolicy(null);
        session.setChecksumPolicy(null);
        int defaultTimeout = this.m_config.getTimeout();
        int connectionTimeout = this.m_config.getProperty("socket.connectionTimeout", defaultTimeout, Integer.class);
        int readTimeout = this.m_config.getProperty("socket.readTimeout", defaultTimeout, Integer.class);
        session.setConfigProperty("aether.connector.connectTimeout", connectionTimeout);
        session.setConfigProperty("aether.connector.requestTimeout", readTimeout);
        session.setConfigProperty("aether.connector.http.useSystemProperties", this.m_useSystemProperties);
        boolean secure = this.m_config.getCertificateCheck();
        session.setConfigProperty("aether.connector.https.securityMode", secure ? ENHANCED_REPOSITORY_TYPE : "insecure");
        int resolverRetryCount = this.m_config.getProperty("aether.connector.http.retryHandler.count", 3, Integer.class);
        int retryCount = this.m_config.getProperty("connection.retryCount", resolverRetryCount, Integer.class);
        session.setConfigProperty("aether.connector.http.retryHandler.count", resolverRetryCount);
        for (Server s : this.m_settings.getServers()) {
            Xpp3Dom httpConfiguration;
            Xpp3Dom requestTimeoutValue;
            String sid = s.getId();
            if (s.getFilePermissions() != null) {
                session.setConfigProperty("aether.connector.perms.fileMode." + sid, s.getFilePermissions());
            }
            if (s.getDirectoryPermissions() != null) {
                session.setConfigProperty("aether.connector.perms.dirMode." + sid, s.getFilePermissions());
            }
            if (s.getConfiguration() == null) continue;
            Xpp3Dom config = (Xpp3Dom)s.getConfiguration();
            int serverConnectTimeout = connectionTimeout;
            int serverRequestTimeout = readTimeout;
            Xpp3Dom connectTimeoutValue = config.getChild("connectTimeout");
            if (connectTimeoutValue != null) {
                try {
                    serverConnectTimeout = Integer.parseInt(connectTimeoutValue.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((requestTimeoutValue = config.getChild("requestTimeout")) != null) {
                try {
                    serverRequestTimeout = Integer.parseInt(requestTimeoutValue.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            session.setConfigProperty("aether.connector.connectTimeout." + sid, serverConnectTimeout);
            session.setConfigProperty("aether.connector.requestTimeout." + sid, serverRequestTimeout);
            HashMap<String, String> headers = new HashMap<String, String>();
            Xpp3Dom httpHeaders = config.getChild("httpHeaders");
            if (httpHeaders != null) {
                for (Xpp3Dom httpHeader : httpHeaders.getChildren("property")) {
                    String headerValue;
                    Xpp3Dom name = httpHeader.getChild("name");
                    String headerName = name == null ? null : name.getValue();
                    Xpp3Dom value = httpHeader.getChild("value");
                    String string = headerValue = value == null ? null : value.getValue();
                    if (name == null || value == null) continue;
                    headers.put(headerName, headerValue);
                }
            }
            if (!headers.isEmpty()) {
                session.setConfigProperty("aether.connector.http.headers." + sid, headers);
            }
            if ((httpConfiguration = config.getChild("httpConfiguration")) == null) continue;
            LOG.warn("Old <configuration>/<httpConfiguration> detected. Please check https://maven.apache.org/guides/mini/guide-resolver-transport.html for new configuration style.");
        }
        return session;
    }

    private RepositorySystemSession newDefaultRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, this.m_localRepository));
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        session.setAuthenticationSelector(this.m_authenticationSelector);
        session.setOffline(this.m_config.isOffline());
        session.setConfigProperty("aether.interactive", false);
        session.setUpdatePolicy(null);
        session.setChecksumPolicy(null);
        return session;
    }

    public static class LocalRepositoryWithConfig {
        final LocalRepository repository;
        final MavenRepositoryURL repositoryURL;

        private LocalRepositoryWithConfig(LocalRepository repository, MavenRepositoryURL repositoryURL) {
            this.repository = repository;
            this.repositoryURL = repositoryURL;
        }
    }
}

