/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.config;

import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.maven.settings.Profile;
import shaded.org.apache.maven.settings.Repository;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilder;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.ops4j.util.property.PropertyResolver;
import shaded.org.ops4j.util.property.PropertyStore;

public class MavenConfigurationImpl
extends PropertyStore
implements MavenConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private static final String DEFAULT_TIMEOUT = "5000";
    private final String m_pid;
    private final PropertyResolver m_propertyResolver;
    private Settings settings;

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_pid = pid == null ? "" : pid + ".";
        this.m_propertyResolver = propertyResolver;
        this.settings = this.buildSettings(this.getLocalRepoPath(propertyResolver), this.getSettingsPath(), this.useFallbackRepositories());
    }

    @Override
    public PropertyResolver getPropertyResolver() {
        return this.m_propertyResolver;
    }

    public boolean isValid() {
        return this.m_propertyResolver.get(this.m_pid + "requireConfigAdminConfig") == null;
    }

    @Override
    public boolean isOffline() {
        if (!this.contains(this.m_pid + "offline")) {
            return this.set(this.m_pid + "offline", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + "offline")));
        }
        return (Boolean)this.get(this.m_pid + "offline");
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains(this.m_pid + "certificateCheck")) {
            return this.set(this.m_pid + "certificateCheck", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + "certificateCheck")));
        }
        return (Boolean)this.get(this.m_pid + "certificateCheck");
    }

    @Override
    public URL getSettingsFileUrl() {
        block10: {
            if (!this.contains(this.m_pid + "settings")) {
                String spec = this.m_propertyResolver.get(this.m_pid + "settings");
                if (spec == null) {
                    spec = this.safeGetFile(System.getProperty("user.home") + "/.m2/settings.xml");
                }
                if (spec == null) {
                    spec = this.safeGetFile(System.getProperty("maven.home") + "/conf/settings.xml");
                }
                if (spec == null) {
                    spec = this.safeGetFile(System.getenv("M2_HOME") + "/conf/settings.xml");
                }
                if (spec != null) {
                    try {
                        return this.set(this.m_pid + "settings", new URL(spec));
                    }
                    catch (MalformedURLException e) {
                        File file = new File(spec);
                        if (file.exists()) {
                            try {
                                return this.set(this.m_pid + "settings", file.toURI().toURL());
                            }
                            catch (MalformedURLException ignore) {
                                break block10;
                            }
                        }
                        LOGGER.warn("Settings file [" + spec + "] cannot be used and will be skipped (malformed url or file does not exist)");
                        this.set(this.m_pid + "settings", null);
                    }
                }
            }
        }
        return (URL)this.get(this.m_pid + "settings");
    }

    private String safeGetFile(String path) {
        File file;
        if (path != null && (file = new File(path)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + "defaultRepositories")) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(this.m_pid + "defaultRepositories");
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            if (defaultRepositoriesProp != null && defaultRepositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL.trim()));
                }
            }
            LOGGER.trace("Using repositories [" + defaultRepositoriesProperty + "]");
            return this.set(this.m_pid + "defaultRepositories", defaultRepositoriesProperty);
        }
        return (List)this.get(this.m_pid + "defaultRepositories");
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + "repositories")) {
            MavenRepositoryURL localRepository;
            String repositoriesProp = this.m_propertyResolver.get(this.m_pid + "repositories");
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.settings != null) {
                String init = repositoriesProp == null ? "" : repositoriesProp.substring(1);
                StringBuilder builder = new StringBuilder(init);
                Map<String, Profile> profiles = this.settings.getProfilesAsMap();
                for (String activeProfile : this.settings.getActiveProfiles()) {
                    Profile profile = profiles.get(activeProfile);
                    if (profile == null) continue;
                    for (Repository repo : profile.getRepositories()) {
                        if (builder.length() > 0) {
                            builder.append(REPOSITORIES_SEPARATOR);
                        }
                        builder.append(repo.getUrl());
                        builder.append("@id=");
                        builder.append(repo.getId());
                        if (repo.getReleases() != null && !repo.getReleases().isEnabled()) {
                            builder.append("@noreleases");
                        }
                        if (repo.getSnapshots() == null || !repo.getSnapshots().isEnabled()) continue;
                        builder.append("@snapshots");
                    }
                }
                repositoriesProp = builder.toString();
            }
            ArrayList<MavenRepositoryURL> repositoriesProperty = new ArrayList<MavenRepositoryURL>();
            if (this.m_propertyResolver.get(this.m_pid + "defaultLocalRepoAsRemote") != null && (localRepository = this.getDefaultLocalRepository()) != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    repositoriesProperty.add(new MavenRepositoryURL(repositoryURL.trim()));
                }
            }
            LOGGER.trace("Using repositories [" + repositoriesProperty + "]");
            return this.set(this.m_pid + "repositories", repositoriesProperty);
        }
        return (List)this.get(this.m_pid + "repositories");
    }

    @Override
    public String getGlobalUpdatePolicy() {
        String propertyName = this.m_pid + "globalUpdatePolicy";
        if (this.contains(propertyName)) {
            return (String)this.get(propertyName);
        }
        String propertyValue = this.m_propertyResolver.get(propertyName);
        if (propertyValue != null) {
            this.set(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    @Override
    public String getGlobalChecksumPolicy() {
        String propertyName = this.m_pid + "globalChecksumPolicy";
        if (this.contains(propertyName)) {
            return (String)this.get(propertyName);
        }
        String propertyValue = this.m_propertyResolver.get(propertyName);
        if (propertyValue != null) {
            this.set(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    @Override
    public MavenRepositoryURL getLocalRepository() {
        if (!this.contains(this.m_pid + "localRepository")) {
            String spec = this.m_propertyResolver.get(this.m_pid + "localRepository");
            if (spec == null && this.settings != null) {
                spec = this.settings.getLocalRepository();
            }
            if (spec == null) {
                spec = System.getProperty("user.home") + "/.m2/repository";
            }
            if (!spec.toLowerCase().contains("@snapshots")) {
                spec = spec + "@snapshots";
            }
            spec = spec + "@id=local";
            try {
                return this.set(this.m_pid + "localRepository", new MavenRepositoryURL(spec));
            }
            catch (MalformedURLException e) {
                try {
                    return this.set(this.m_pid + "localRepository", new MavenRepositoryURL(new File(spec).toURI().toASCIIString()));
                }
                catch (MalformedURLException ignore) {
                    LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                    return this.set(this.m_pid + "localRepository", null);
                }
            }
        }
        return (MavenRepositoryURL)this.get(this.m_pid + "localRepository");
    }

    public MavenRepositoryURL getDefaultLocalRepository() {
        if (this.settings != null) {
            String spec = this.settings.getLocalRepository();
            if (spec == null) {
                spec = System.getProperty("user.home") + "/.m2/repository";
            }
            if (!spec.toLowerCase().contains("@snapshots")) {
                spec = spec + "@snapshots";
            }
            spec = spec + "@id=defaultlocal";
            try {
                return new MavenRepositoryURL(spec);
            }
            catch (MalformedURLException e) {
                try {
                    return new MavenRepositoryURL(new File(spec).toURI().toASCIIString());
                }
                catch (MalformedURLException ignore) {
                    LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Integer getTimeout() {
        if (!this.contains(this.m_pid + "timeout")) {
            String timeout = this.m_propertyResolver.get(this.m_pid + "timeout");
            return this.set(this.m_pid + "timeout", Integer.valueOf(timeout == null ? DEFAULT_TIMEOUT : timeout));
        }
        return (Integer)this.get(this.m_pid + "timeout");
    }

    @Override
    public Boolean useFallbackRepositories() {
        if (!this.contains(this.m_pid + "useFallbackRepositories")) {
            String useFallbackRepoProp = this.m_propertyResolver.get(this.m_pid + "useFallbackRepositories");
            return this.set(this.m_pid + "useFallbackRepositories", Boolean.valueOf(useFallbackRepoProp == null ? "true" : useFallbackRepoProp));
        }
        return (Boolean)this.get(this.m_pid + "useFallbackRepositories");
    }

    @Override
    public void enableProxy(URL url) {
        String protocol = url.getProtocol();
        Map<String, String> proxyDetails = this.getProxySettings(url.getProtocol()).get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace("Enabling proxy [" + proxyDetails + "]");
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty(protocol + ".proxyHost", proxyDetails.get("host"));
            System.setProperty(protocol + ".proxyPort", proxyDetails.get("port"));
            System.setProperty(protocol + ".nonProxyHosts", proxyDetails.get("nonProxyHosts"));
            this.set(this.m_pid + "proxySupport", protocol);
        }
    }

    private boolean isProtocolSupportEnabled(String ... protocols) {
        String proxySupport = this.m_propertyResolver.get(this.m_pid + "proxySupport");
        if (proxySupport == null) {
            return true;
        }
        if ("true".equalsIgnoreCase(proxySupport)) {
            return true;
        }
        if ("false".equalsIgnoreCase(proxySupport)) {
            return false;
        }
        if (protocols.length == 0) {
            return true;
        }
        for (String protocol : protocols) {
            if (!proxySupport.contains(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings(String ... protocols) {
        HashMap<String, Map<String, String>> pr = new HashMap<String, Map<String, String>>();
        if (this.isProtocolSupportEnabled(protocols)) {
            this.parseSystemWideProxySettings(pr);
            this.parseProxiesFromProperty(this.m_propertyResolver.get(this.m_pid + "proxies"), pr);
        }
        return pr;
    }

    private void parseSystemWideProxySettings(Map<String, Map<String, String>> pr) {
        String httpHost = this.m_propertyResolver.get("http.proxyHost");
        String httpPort = this.m_propertyResolver.get("http.proxyPort");
        String httpnonProxyHosts = this.m_propertyResolver.get("http.nonProxyHosts");
        if (httpHost != null) {
            this.parseProxiesFromProperty("http:host=" + httpHost + ",port=" + httpPort + ",nonProxyHosts=" + httpnonProxyHosts, pr);
        }
    }

    private void parseProxiesFromProperty(String proxySettings, Map<String, Map<String, String>> pr) {
        try {
            if (proxySettings != null) {
                String[] protocols;
                for (String protocolSection : protocols = proxySettings.split(";")) {
                    String[] section = protocolSection.split(":");
                    String protocolName = section[0];
                    HashMap<String, String> keyvalue = new HashMap<String, String>();
                    keyvalue.put("protocol", protocolName);
                    keyvalue.put("nonProxyHosts", "");
                    keyvalue.put("host", "localhost");
                    keyvalue.put("port", "80");
                    for (String keyvalueList : section[1].split(REPOSITORIES_SEPARATOR)) {
                        String[] kv = keyvalueList.split("=");
                        String key = kv[0];
                        String value = kv[1];
                        keyvalue.put(key, value);
                    }
                    pr.put(protocolName, keyvalue);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Proxy setting is set to " + proxySettings + ". But it should have this format: <protocol>:<key>=<value>,<key=value>;protocol:<key>=<value>,..");
        }
    }

    private String getSettingsPath() {
        URL url = this.getSettingsFileUrl();
        return url == null ? null : url.getPath();
    }

    private String getLocalRepoPath(PropertyResolver props) {
        return props.get("org.ops4j.pax.url.mvn.localRepository");
    }

    private Settings buildSettings(String localRepoPath, String settingsPath, boolean useFallbackRepositories) {
        Settings settings;
        if (settingsPath == null) {
            settings = new Settings();
        } else {
            DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder builder = factory.newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(new File(settingsPath));
            try {
                SettingsBuildingResult result = builder.build(request);
                settings = result.getEffectiveSettings();
            }
            catch (SettingsBuildingException exc) {
                throw new AssertionError("cannot build settings", exc);
            }
        }
        if (useFallbackRepositories) {
            Profile fallbackProfile = new Profile();
            Repository central = new Repository();
            central.setId("central");
            central.setUrl("http://repo1.maven.org/maven2");
            fallbackProfile.setId("fallback");
            fallbackProfile.setRepositories(Arrays.asList(central));
            settings.addProfile(fallbackProfile);
            settings.addActiveProfile("fallback");
        }
        if (localRepoPath != null) {
            settings.setLocalRepository(localRepoPath);
        }
        return settings;
    }

    @Override
    public Map<String, Map<String, String>> getMirrors() {
        return Collections.emptyMap();
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public String getSecuritySettings() {
        String key = this.m_pid + "security";
        if (!this.contains(key)) {
            String spec = this.m_propertyResolver.get(key);
            if (spec == null) {
                spec = new File(System.getProperty("user.home"), ".m2/settings-security.xml").getPath();
            }
            return this.set(key, spec);
        }
        return (String)this.get(key);
    }
}

