/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionsDependencyFilter
implements DependencyFilter {
    private final Collection<String> excludes = new HashSet<String>();

    public ExclusionsDependencyFilter(Collection<String> excludes) {
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        String id = dependency.getArtifact().getArtifactId();
        if (this.excludes.contains(id)) {
            return false;
        }
        id = dependency.getArtifact().getGroupId() + ':' + id;
        return !this.excludes.contains(id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ExclusionsDependencyFilter that = (ExclusionsDependencyFilter)obj;
        return ((Object)this.excludes).equals(that.excludes);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + ((Object)this.excludes).hashCode();
        return hash;
    }
}

