/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.AetherBasedResolver;
import org.ops4j.pax.url.mvn.internal.Parser;

public class Connection
extends URLConnection {
    private static final Log LOG = LogFactory.getLog(Connection.class);
    private Parser m_parser;
    private AetherBasedResolver m_aetherBasedResolver;

    public Connection(URL url, MavenConfiguration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL cannot be null");
        NullArgumentException.validateNotNull(configuration, "Service configuration");
        this.m_parser = new Parser(url.getPath());
        this.m_aetherBasedResolver = new AetherBasedResolver(configuration);
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug("Resolving [" + this.url.toExternalForm() + "]");
        return this.m_aetherBasedResolver.resolve(this.m_parser.getGroup(), this.m_parser.getArtifact(), this.m_parser.getClassifier(), this.m_parser.getType(), this.m_parser.getVersion());
    }
}

