/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.logging;

import com.atomikos.logging.JULLoggerFactoryDelegate;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactoryDelegate;

public final class LoggerFactory {
    static LoggerFactoryDelegate loggerFactoryDelegate;

    private LoggerFactory() {
    }

    public static Logger createLogger(Class<?> clazz) {
        return loggerFactoryDelegate.createLogger(clazz);
    }

    static void setLoggerFactoryDelegate(LoggerFactoryDelegate loggerFactoryDelegate) {
        LoggerFactory.loggerFactoryDelegate = loggerFactoryDelegate;
    }

    private static void fallbackToDefault() {
        LoggerFactory.setLoggerFactoryDelegate(new JULLoggerFactoryDelegate());
    }

    static {
        String cname = null;
        try {
            Class.forName("org.slf4j.LoggerFactory");
            cname = "com.atomikos.logging.Slf4JLoggerFactoryDelegate";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (cname != null) {
                Class<?> loggerClass = Class.forName(cname.trim(), true, LoggerFactory.class.getClassLoader());
                loggerFactoryDelegate = (LoggerFactoryDelegate)loggerClass.newInstance();
            } else {
                LoggerFactory.fallbackToDefault();
            }
        }
        catch (Throwable ex) {
            LoggerFactory.fallbackToDefault();
        }
        Logger logger = LoggerFactory.createLogger(LoggerFactory.class);
        logger.logDebug("Using " + loggerFactoryDelegate + " for logging.");
    }
}

