/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.Repository;
import com.atomikos.recovery.TxState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryRepository
implements Repository {
    private Map<String, CoordinatorLogEntry> storage = new ConcurrentHashMap<String, CoordinatorLogEntry>();
    private boolean closed = true;

    @Override
    public void init() {
        this.closed = false;
    }

    @Override
    public synchronized void put(String id, CoordinatorLogEntry coordinatorLogEntry) throws IllegalArgumentException {
        CoordinatorLogEntry existing = this.storage.get(id);
        if (existing != null && existing == coordinatorLogEntry) {
            throw new IllegalArgumentException("cannot put the same coordinatorLogEntry twice");
        }
        if (coordinatorLogEntry.getResultingState().isFinalState()) {
            this.storage.remove(id);
        } else {
            this.storage.put(id, coordinatorLogEntry);
        }
    }

    @Override
    public synchronized CoordinatorLogEntry get(String coordinatorId) {
        return this.storage.get(coordinatorId);
    }

    @Override
    public synchronized Collection<CoordinatorLogEntry> findAllCommittingCoordinatorLogEntries() {
        HashSet<CoordinatorLogEntry> res = new HashSet<CoordinatorLogEntry>();
        Collection<CoordinatorLogEntry> allCoordinatorLogEntry = this.storage.values();
        for (CoordinatorLogEntry coordinatorLogEntry : allCoordinatorLogEntry) {
            if (coordinatorLogEntry.getResultingState() != TxState.COMMITTING) continue;
            res.add(coordinatorLogEntry);
        }
        return res;
    }

    @Override
    public void close() {
        this.storage.clear();
        this.closed = true;
    }

    @Override
    public Collection<CoordinatorLogEntry> getAllCoordinatorLogEntries() {
        return this.storage.values();
    }

    @Override
    public void writeCheckpoint(Collection<CoordinatorLogEntry> checkpointContent) {
        this.storage.clear();
        for (CoordinatorLogEntry coordinatorLogEntry : checkpointContent) {
            this.storage.put(coordinatorLogEntry.id, coordinatorLogEntry);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

