/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMImp;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.finitestates.Stateful;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionAbortedEvent;
import com.atomikos.icatch.event.transaction.TransactionCommittedEvent;
import com.atomikos.icatch.event.transaction.TransactionCreatedEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.icatch.event.transaction.TransactionReadOnlyEvent;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.RollbackOnlyParticipant;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.RecoverableCoordinator;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.ParticipantLogEntry;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CoordinatorImp
implements CompositeCoordinator,
Participant,
RecoveryCoordinator,
RecoverableCoordinator,
AlarmTimerListener,
Stateful,
FSMPreEnterListener,
FSMTransitionListener,
FSMEnterListener {
    private static final long serialVersionUID = -7769094320086083771L;
    private static final Logger LOGGER = LoggerFactory.createLogger(CoordinatorImp.class);
    static long DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS = 150L;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_FOR_INDOUBTS = 30;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_BEFORE_ROLLBACK_OF_ACTIVES = 30;
    private int localSiblingCount_ = 0;
    private AlarmTimer timer_ = null;
    private boolean checkSiblings_ = true;
    private long maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = 30L;
    private long maxNumberOfTimeoutTicksBeforeRollback_ = 30L;
    private String root_ = null;
    private FSM fsm_ = null;
    private boolean heuristicMeansCommit_ = true;
    private Vector<Participant> participants_ = new Vector();
    private RecoveryCoordinator superiorCoordinator_ = null;
    private CoordinatorStateHandler stateHandler_;
    private boolean single_threaded_2pc_;
    private transient List<Synchronization> synchronizations;

    protected CoordinatorImp(String root, boolean heuristic_commit, boolean checkorphans) {
        this.root_ = root;
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = heuristic_commit;
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.checkSiblings_ = checkorphans;
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    private void initFsm(TxState initialState) {
        this.fsm_ = new FSMImp(this, initialState);
        this.fsm_.addFSMPreEnterListener(this, TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener(this, TxState.HEUR_HAZARD);
        this.fsm_.addFSMTransitionListener(this, TxState.COMMITTING, TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener(this, TxState.ABORTING, TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener(this, TxState.PREPARING, TxState.TERMINATED);
        this.fsm_.addFSMEnterListener(this, TxState.HEUR_COMMITTED);
        this.fsm_.addFSMEnterListener(this, TxState.HEUR_ABORTED);
        this.fsm_.addFSMEnterListener(this, TxState.HEUR_HAZARD);
        this.fsm_.addFSMEnterListener(this, TxState.HEUR_MIXED);
    }

    protected CoordinatorImp(String root, RecoveryCoordinator coord, boolean heuristic_commit, long timeout, boolean checkorphans, boolean single_threaded_2pc) {
        this.root_ = root;
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = heuristic_commit;
        this.superiorCoordinator_ = coord;
        if (timeout > DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS) {
            this.maxNumberOfTimeoutTicksBeforeRollback_ = this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = timeout / DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
        }
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.checkSiblings_ = checkorphans;
        this.synchronizations = new ArrayList<Synchronization>();
        this.publishDomainEvent(new TransactionCreatedEvent(this.root_));
    }

    public CoordinatorImp() {
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = false;
        this.checkSiblings_ = true;
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    boolean prefersSingleThreaded2PC() {
        return this.single_threaded_2pc_;
    }

    void setCommitted() {
        this.stateHandler_.setCommitted();
    }

    void setStateHandler(CoordinatorStateHandler stateHandler) {
        TxState state = stateHandler.getState();
        this.stateHandler_ = stateHandler;
        this.setState(state);
    }

    RecoveryCoordinator getSuperiorRecoveryCoordinator() {
        return this.superiorCoordinator_;
    }

    public Vector<Participant> getParticipants() {
        return this.participants_;
    }

    boolean prefersHeuristicCommit() {
        return this.heuristicMeansCommit_;
    }

    int getLocalSiblingCount() {
        return this.localSiblingCount_;
    }

    long getMaxIndoubtTicks() {
        return this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_;
    }

    long getMaxRollbackTicks() {
        return this.maxNumberOfTimeoutTicksBeforeRollback_;
    }

    boolean checkSiblings() {
        return this.checkSiblings_;
    }

    public boolean isCommitted() {
        return this.stateHandler_.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads(long timeout) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ == null) {
                this.stateHandler_.activate();
                this.timer_ = new PooledAlarmTimer(timeout);
                this.timer_.addAlarmTimerListener(this);
                this.submitTimer(this.timer_);
            }
        }
    }

    private void submitTimer(AlarmTimer timer) {
        TaskManager.SINGLETON.executeTask(timer);
    }

    protected long getTimeOut() {
        return (this.maxNumberOfTimeoutTicksBeforeRollback_ - this.stateHandler_.getRollbackTicks()) * DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
    }

    void setState(TxState state) throws IllegalStateException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " entering state: " + state.toString());
        }
        this.fsm_.setState(state);
    }

    @Override
    public TxState getState() {
        return this.fsm_.getState();
    }

    void addFSMEnterListener(FSMEnterListener l, TxState state) {
        this.fsm_.addFSMEnterListener(l, state);
    }

    @Override
    public void addFSMPreEnterListener(FSMPreEnterListener l, TxState state) {
        this.fsm_.addFSMPreEnterListener(l, state);
    }

    @Override
    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Participant getParticipant() throws UnsupportedOperationException {
        return this;
    }

    @Override
    public String getCoordinatorId() {
        return this.root_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException(this.getCoordinatorId() + " is no longer active but in state " + this.getState().toString());
            }
            if (!this.participants_.contains(participant)) {
                this.participants_.add(participant);
            }
            this.setState(TxState.ACTIVE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingCount() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, UnsupportedOperationException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException("wrong state: " + (Object)((Object)this.getState()));
            }
            this.rememberSychronizationForAfterCompletion(sync);
        }
    }

    private void rememberSychronizationForAfterCompletion(Synchronization sync) {
        this.getSynchronizations().add(sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Synchronization> getSynchronizations() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.synchronizations == null) {
                this.synchronizations = new ArrayList<Synchronization>();
            }
            return this.synchronizations;
        }
    }

    void notifySynchronizationsAfterCompletion(TxState ... successiveStates) {
        for (TxState state : successiveStates) {
            for (Synchronization s : this.getSynchronizations()) {
                try {
                    s.afterCompletion(state);
                }
                catch (Throwable t) {
                    LOGGER.logWarning("Unexpected error in afterCompletion", t);
                }
            }
        }
    }

    @Override
    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        TxState state = event.getState();
        if (state.equals((Object)TxState.TERMINATED) || state.isHeuristic()) {
            if (!state.equals((Object)TxState.TERMINATED)) {
                LOGGER.logError("Local heuristic termination of coordinator " + this.root_ + " with state " + (Object)((Object)this.getState()));
            } else {
                this.dispose();
            }
        }
    }

    @Override
    public String getURI() {
        return this.getCoordinatorId();
    }

    @Override
    public void forget() {
        this.stateHandler_.forget();
    }

    @Override
    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
        this.stateHandler_.setCascadeList(allParticipants);
    }

    @Override
    public void setGlobalSiblingCount(int count) {
        this.stateHandler_.setGlobalSiblingCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        if (this.getState().equals((Object)TxState.PREPARING)) {
            throw new RollbackException("Recursion detected");
        }
        int ret = 1;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.prepare();
            if (ret == 0) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("prepare() of Coordinator  " + this.getCoordinatorId() + " returning READONLY");
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("prepare() of Coordinator  " + this.getCoordinatorId() + " returning YES vote");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.commit(onePhase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        if (this.getState().equals((Object)TxState.ABORTING)) {
            return;
        }
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.rollbackHeuristically();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            this.stateHandler_.commitHeuristically();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("replayCompletion ( " + participant + " ) received by coordinator " + this.getCoordinatorId() + " for participant " + participant.toString());
        }
        Boolean ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.replayCompletion(participant);
        }
        return ret;
    }

    private boolean excludedFromLogging(TxState state) {
        boolean ret = false;
        if (!state.isRecoverableState()) {
            ret = true;
        } else if (this.superiorCoordinator_ == null) {
            if (state.equals((Object)TxState.IN_DOUBT)) {
                ret = true;
            } else if (this.participants_.isEmpty()) {
                ret = true;
            }
        }
        if (state.isHeuristic()) {
            ret = true;
        }
        return ret;
    }

    public Object getId() {
        return this.root_;
    }

    @Override
    public void alarm(AlarmTimer timer) {
        try {
            this.stateHandler_.onTimeout();
        }
        catch (Exception e) {
            LOGGER.logWarning("Exception on timeout of coordinator " + this.root_, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : stopping timer...");
                }
                this.timer_.stop();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : disposing statehandler " + (Object)((Object)this.stateHandler_.getState()) + "...");
            }
            this.stateHandler_.dispose();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Coordinator " + this.getCoordinatorId() + " : disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean commit) throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, RollbackException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (commit) {
                if (this.participants_.size() <= 1) {
                    this.commit(true);
                } else {
                    int prepareResult = this.prepare();
                    if (prepareResult != 0) {
                        this.commit(false);
                    }
                }
            } else {
                this.rollback();
            }
        }
    }

    void setRollbackOnly() {
        block4: {
            RollbackOnlyParticipant p = new RollbackOnlyParticipant();
            try {
                this.addParticipant(p);
            }
            catch (IllegalStateException alreadyTerminated) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("Error during setRollbackOnly", alreadyTerminated);
                }
            }
            catch (RollbackException e) {
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.logTrace("Error during setRollbackOnly", e);
            }
        }
    }

    public TxState getStateWithTwoPhaseCommitDecision() {
        TxState ret = this.getState();
        if (TxState.TERMINATED.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTED : TxState.ABORTED;
        } else if (TxState.HEUR_ABORTED.equals((Object)this.getState())) {
            ret = TxState.ABORTED;
        } else if (TxState.HEUR_COMMITTED.equals((Object)this.getState())) {
            ret = TxState.COMMITTED;
        } else if (TxState.HEUR_HAZARD.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTING : TxState.ABORTING;
        }
        return ret;
    }

    @Override
    public void transitionPerformed(FSMTransitionEvent e) {
        TxState fromState = e.fromState();
        TxState toState = e.toState();
        if (TxState.TERMINATED.equals((Object)toState)) {
            if (TxState.COMMITTING.equals((Object)fromState)) {
                this.publishDomainEvent(new TransactionCommittedEvent(this.root_));
            } else if (TxState.ABORTING.equals((Object)fromState)) {
                this.publishDomainEvent(new TransactionAbortedEvent(this.root_));
            } else if (TxState.PREPARING.equals((Object)fromState)) {
                this.publishDomainEvent(new TransactionReadOnlyEvent(this.root_));
            }
        }
    }

    private void publishDomainEvent(Event event) {
        EventPublisher.publish(event);
    }

    @Override
    public void entered(FSMEnterEvent e) {
        TxState state = e.getState();
        if (state.isHeuristic()) {
            this.publishDomainEvent(new TransactionHeuristicEvent(this.root_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinatorLogEntry getCoordinatorLogEntry(TxState state) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.excludedFromLogging(state)) {
                return null;
            }
            HashSet<ParticipantLogEntry> participantLogEntries = new HashSet<ParticipantLogEntry>();
            for (Participant participant : this.getParticipants()) {
                if (!participant.isRecoverable()) continue;
                ParticipantLogEntry ple = new ParticipantLogEntry(this.getCoordinatorId(), participant.getURI(), this.getExpires(), participant.getResourceName(), state);
                participantLogEntries.add(ple);
            }
            if (participantLogEntries.isEmpty()) {
                return null;
            }
            ParticipantLogEntry[] participantDetails = participantLogEntries.toArray(new ParticipantLogEntry[participantLogEntries.size()]);
            CoordinatorLogEntry coordinatorLogEntry = new CoordinatorLogEntry(this.getCoordinatorId(), this.isCommitted(), participantDetails);
            return coordinatorLogEntry;
        }
    }

    public CoordinatorLogEntry getCoordinatorLogEntry() {
        return this.getCoordinatorLogEntry(this.getState());
    }

    public Collection<ParticipantLogEntry> getParticipantLogEntries() {
        return Arrays.asList(this.getCoordinatorLogEntry().participants);
    }

    private long getExpires() {
        return System.currentTimeMillis() + this.getTimeOut();
    }

    @Override
    public boolean isRecoverable() {
        return this.superiorCoordinator_ != null;
    }

    @Override
    public String getResourceName() {
        return null;
    }
}

