/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.resource.spi.ConnectionRequestInfo;
import org.ops4j.pax.transx.connection.utils.AbstractConnectionHandle;
import org.ops4j.pax.transx.jms.impl.ConnectionImpl;
import org.ops4j.pax.transx.jms.impl.ConnectionRequestInfoImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionFactoryImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class SessionImpl
extends AbstractConnectionHandle<ManagedConnectionFactoryImpl, ManagedConnectionImpl, Session, SessionImpl>
implements TopicSession,
QueueSession {
    private ConnectionImpl con = null;
    private final Set<AutoCloseable> closeables = new HashSet<AutoCloseable>();

    public SessionImpl(ManagedConnectionFactoryImpl mcf, ConnectionRequestInfo cri, ManagedConnectionImpl mc) {
        super(mcf, cri, mc);
    }

    ConnectionRequestInfoImpl cri() {
        return (ConnectionRequestInfoImpl)this.cri;
    }

    public void setConnection(ConnectionImpl con) {
        this.con = con;
    }

    @Override
    protected void doClose() {
        this.con.closeSession(this);
        try {
            ((ManagedConnectionImpl)this.mc).stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Utils.doClose(this.closeables);
        ((ManagedConnectionImpl)this.mc).connectionClosed(this);
    }

    @Override
    public void cleanup() {
    }

    void start() throws JMSException {
        if (this.mc != null) {
            ((ManagedConnectionImpl)this.mc).start();
        }
    }

    private QueueSession getQueueSessionInternal(Session s) throws JMSException {
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
        }
        return (QueueSession)s;
    }

    private TopicSession getTopicSessionInternal(Session s) throws JMSException {
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
        }
        return (TopicSession)s;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.call(session -> this.wrap(QueueReceiver.class, this.getQueueSessionInternal((Session)session).createReceiver(queue)));
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.call(session -> this.wrap(QueueReceiver.class, this.getQueueSessionInternal((Session)session).createReceiver(queue, messageSelector)));
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return this.call(session -> this.wrap(QueueSender.class, this.getQueueSessionInternal((Session)session).createSender(queue)));
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.call(session -> this.wrap(TopicSubscriber.class, this.getTopicSessionInternal((Session)session).createSubscriber(topic)));
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return this.call(session -> this.wrap(TopicSubscriber.class, this.getTopicSessionInternal((Session)session).createSubscriber(topic, messageSelector, noLocal)));
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.call(session -> this.wrap(TopicPublisher.class, this.getTopicSessionInternal((Session)session).createPublisher(topic)));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createConsumer(destination)));
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createConsumer(destination, messageSelector)));
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createConsumer(destination, messageSelector, noLocal)));
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.call(session -> this.wrap(MessageProducer.class, session.createProducer(destination)));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.call(session -> this.wrap(TopicSubscriber.class, session.createDurableSubscriber(topic, name)));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.call(session -> this.wrap(TopicSubscriber.class, session.createDurableSubscriber(topic, name, messageSelector, noLocal)));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createSharedConsumer(topic, sharedSubscriptionName)));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector)));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createDurableConsumer(topic, name)));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createDurableConsumer(topic, name, messageSelector, noLocal)));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createSharedDurableConsumer(topic, name)));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.call(session -> this.wrap(MessageConsumer.class, session.createSharedDurableConsumer(topic, name, messageSelector)));
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.call(session -> this.con.wrapTemporaryQueue(session.createTemporaryQueue()));
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.call(session -> this.con.wrapTemporaryTopic(session.createTemporaryTopic()));
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.call(Session::createBytesMessage);
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.call(Session::createMapMessage);
    }

    public Message createMessage() throws JMSException {
        return this.call(Session::createMessage);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.call(Session::createObjectMessage);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.call(session -> session.createObjectMessage(object));
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.call(Session::createStreamMessage);
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.call(Session::createTextMessage);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.call(session -> session.createTextMessage(text));
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.call(session -> session.createQueue(queueName));
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.call(session -> session.createTopic(topicName));
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.call(session -> session.createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.call(session -> session.createBrowser(queue, messageSelector));
    }

    public void unsubscribe(String name) throws JMSException {
        this.execute(session -> session.unsubscribe(name));
    }

    public MessageListener getMessageListener() throws JMSException {
        return (MessageListener)Utils.unsupported("getMessageListener");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        Utils.unsupported("setMessageListener");
    }

    public void run() {
        Utils.unsupported("run");
    }

    public void recover() throws JMSException {
        this.execute(session -> {
            if (this.cri().isTransacted()) {
                throw new IllegalStateException("Session is transacted");
            }
            session.recover();
        });
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.call(session -> this.cri().getAcknowledgeMode());
    }

    public boolean getTransacted() throws JMSException {
        return this.call(session -> this.cri().isTransacted());
    }

    public void commit() throws JMSException {
        this.execute(session -> {
            if (!this.cri().isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            session.commit();
        });
    }

    public void rollback() throws JMSException {
        this.execute(session -> {
            if (!this.cri().isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            session.rollback();
        });
    }

    @Override
    protected <E extends Exception> E wrapException(String msg, Exception e) {
        if (msg == null && e instanceof JMSException) {
            return (E)e;
        }
        if (msg == null && e != null && e.getCause() instanceof JMSException) {
            return (E)((Exception)e.getCause());
        }
        return (E)((Exception)new JMSException(msg).initCause((Throwable)e));
    }

    private <T extends AutoCloseable> T wrap(Class<T> clazz, T closeable) {
        this.closeables.add(closeable);
        return (T)((AutoCloseable)clazz.cast(Proxy.newProxyInstance(closeable.getClass().getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if ("close".equals(method.getName()) && method.getParameterCount() == 0 && method.getReturnType() == Void.TYPE) {
                this.closeables.remove(closeable);
            }
            return method.invoke((Object)closeable, args);
        })));
    }
}

