/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tracker;

import java.util.Map;
import org.ops4j.pax.swissbox.tracker.ServiceLookupException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceLookup {
    public static final long DEFAULT_TIMEOUT;

    public static <T> T getService(BundleContext bc, String className) {
        return ServiceLookup.getService(bc, className, DEFAULT_TIMEOUT, "");
    }

    public static <T> T getService(BundleContext bc, Class<T> type) {
        return ServiceLookup.getService(bc, type, DEFAULT_TIMEOUT);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, Map<String, String> props) {
        return ServiceLookup.getService(bc, type, DEFAULT_TIMEOUT, props);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout, Map<String, String> props) {
        return ServiceLookup.getService(bc, type.getName(), timeout, props);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout) {
        return ServiceLookup.getService(bc, type.getName(), timeout, "");
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout, String filter) {
        return ServiceLookup.getService(bc, type.getName(), timeout, filter);
    }

    public static <T> T getService(BundleContext bc, String className, long timeout, Map<String, String> props) {
        try (ServiceTracker tracker = ServiceLookup.createServiceTracker(bc, className, props);){
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new ServiceLookupException("gave up waiting for service " + className);
            }
            Object object = bc.getService(tracker.getServiceReference());
            return (T)object;
        }
    }

    public static <T> T getService(BundleContext bc, String className, long timeout, String filter) {
        try (ServiceTracker tracker = ServiceLookup.createServiceTracker(bc, className, filter);){
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new ServiceLookupException("gave up waiting for service " + className);
            }
            Object object = bc.getService(tracker.getServiceReference());
            return (T)object;
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, String className, long timeout, String filter) {
        try (ServiceTracker tracker = ServiceLookup.createServiceTracker(bc, className, filter);){
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new ServiceLookupException("gave up waiting for service " + className);
            }
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
    }

    private static ServiceTracker createServiceTracker(BundleContext bc, String className, Map<String, String> props) {
        if (bc == null) {
            bc = FrameworkUtil.getBundle(ServiceLookup.class).getBundleContext();
        }
        if (props == null || props.isEmpty()) {
            return new ServiceTracker(bc, className, null);
        }
        StringBuilder builder = new StringBuilder("(&(objectClass=");
        builder.append(className);
        builder.append(')');
        for (Map.Entry<String, String> entry : props.entrySet()) {
            builder.append('(');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append(')');
        }
        builder.append(')');
        return ServiceLookup.createServiceTrackerWithFilter(bc, builder.toString());
    }

    private static ServiceTracker createServiceTrackerWithFilter(BundleContext bc, String ldapFilter) {
        if (bc == null) {
            bc = FrameworkUtil.getBundle(ServiceLookup.class).getBundleContext();
        }
        try {
            Filter filter = bc.createFilter(ldapFilter);
            ServiceTracker tracker = new ServiceTracker(bc, filter, null);
            return tracker;
        }
        catch (InvalidSyntaxException exc) {
            throw new ServiceLookupException(exc);
        }
    }

    private static ServiceTracker createServiceTracker(BundleContext bc, String className, String filterString) {
        StringBuilder builder = new StringBuilder("(&(objectClass=");
        builder.append(className);
        builder.append(')');
        if (filterString != null) {
            builder.append(filterString);
        }
        builder.append(')');
        return ServiceLookup.createServiceTrackerWithFilter(bc, builder.toString());
    }

    public static Object getServiceByFilter(BundleContext bc, String ldapFilter) {
        return ServiceLookup.getServiceByFilter(bc, ldapFilter, DEFAULT_TIMEOUT);
    }

    public static Object getServiceByFilter(BundleContext bc, String ldapFilter, long timeout) {
        try {
            Filter filter = bc.createFilter(ldapFilter);
            ServiceTracker tracker = new ServiceTracker(bc, filter, null);
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new ServiceLookupException("gave up waiting for service " + ldapFilter);
            }
            return bc.getService(tracker.getServiceReference());
        }
        catch (InvalidSyntaxException exc) {
            throw new ServiceLookupException(exc);
        }
        catch (InterruptedException exc) {
            throw new ServiceLookupException(exc);
        }
    }

    static {
        String DEFAULT_TIMEOUT_VALUE_PROPERTY = "org.ops4j.pax.swissbox.tracker.ServiceLookup.DEFAULT_TIMEOUT";
        int DEFAULT_TIMEOUT_VALUE = 10000;
        DEFAULT_TIMEOUT = Long.getLong("org.ops4j.pax.swissbox.tracker.ServiceLookup.DEFAULT_TIMEOUT", 10000L);
    }
}

