/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tinybundles.core.intern;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.swissbox.tinybundles.core.BuildableBundle;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundle;
import org.ops4j.pax.swissbox.tinybundles.core.metadata.RawBuilder;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyBundleImpl
implements TinyBundle {
    private static Log LOG = LogFactory.getLog(TinyBundleImpl.class);
    private Map<String, URL> m_resources = new HashMap<String, URL>();
    private Map<String, String> m_headers = new HashMap<String, String>();
    private Store<InputStream> m_store;

    public TinyBundleImpl(Store<InputStream> bstore) {
        this.m_store = bstore;
    }

    public TinyBundleImpl(InputStream in, Store<InputStream> bstore) {
        this.m_store = bstore;
        if (in != null) {
            try {
                Handle handle = this.m_store.store((Object)in);
                JarInputStream jarOut = new JarInputStream((InputStream)this.m_store.load(handle));
                Manifest manifest = jarOut.getManifest();
                Attributes att = manifest.getMainAttributes();
                for (Object o : att.keySet()) {
                    String k = o.toString();
                    String v = att.getValue(k);
                    this.set(k, v);
                }
                JarEntry entry = null;
                while ((entry = jarOut.getNextJarEntry()) != null) {
                    this.add(entry.getName(), jarOut);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Problem loading bundle.", e);
            }
        }
    }

    @Override
    public TinyBundle add(Class clazz) {
        String name = this.mapClassToEntry(clazz.getName());
        this.add(name, this.getClass().getResource("/" + name));
        return this;
    }

    @Override
    public TinyBundle remove(Class content) {
        String name = this.mapClassToEntry(content.getName());
        this.removeResource(name);
        return this;
    }

    private String mapClassToEntry(String clazzname) {
        return clazzname.replaceAll("\\.", "/") + ".class";
    }

    @Override
    public TinyBundle add(String name, URL url) {
        this.m_resources.put(name, url);
        return this;
    }

    @Override
    public TinyBundle add(String name, InputStream content) {
        try {
            return this.add(name, this.m_store.getLocation(this.m_store.store((Object)content)).toURL());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream build(BuildableBundle builder) {
        return builder.build(this.m_resources, this.m_headers);
    }

    @Override
    public InputStream build() {
        return new RawBuilder().build(this.m_resources, this.m_headers);
    }

    @Override
    public TinyBundle set(String key, String value) {
        this.m_headers.put(key, value);
        return this;
    }

    @Override
    public TinyBundle removeResource(String key) {
        this.m_resources.remove(key);
        return this;
    }

    @Override
    public TinyBundle removeHeader(String key) {
        this.m_headers.remove(key);
        return this;
    }
}

