/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tinybundles.dp.intern;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.Bucket;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.DPContentType;
import org.ops4j.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPBuilder {
    private static Log LOG = LogFactory.getLog(DPBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream build(Map<String, String> headers, final Store<InputStream> cache, final Bucket meta) throws IOException {
        Manifest manifestDP = new Manifest();
        manifestDP.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifestDP.getMainAttributes().putValue("Content-Type", "application/vnd.osgi.dp");
        for (String key : headers.keySet()) {
            manifestDP.getMainAttributes().putValue(key, headers.get(key));
        }
        final Map<String, Attributes> entries = manifestDP.getEntries();
        for (String name : meta.getEntries()) {
            Attributes attr = new Attributes();
            ZipInputStream jout = null;
            try {
                jout = new JarInputStream((InputStream)cache.load(meta.getHandle(name)));
                Manifest man = ((JarInputStream)jout).getManifest();
                if (meta.isType(name, DPContentType.BUNDLE)) {
                    attr.putValue("Bundle-SymbolicName", man.getMainAttributes().getValue("Bundle-SymbolicName"));
                    attr.putValue("Bundle-Version", man.getMainAttributes().getValue("Bundle-Version"));
                } else {
                    attr.putValue("Resource-Processor", "foo");
                }
                if (meta.isMissing(name)) {
                    attr.putValue("DeploymentPackage-Missing", "true");
                }
            }
            finally {
                if (jout != null) {
                    try {
                        jout.close();
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Problem closing jar inputstream of " + name), (Throwable)e);
                    }
                }
            }
            entries.put(name, attr);
        }
        PipedInputStream pin = new PipedInputStream();
        try {
            final PipedOutputStream pout = new PipedOutputStream(pin);
            final JarOutputStream jarOut = new JarOutputStream((OutputStream)pout, manifestDP);
            new Thread(){

                public void run() {
                    try {
                        for (String entry : entries.keySet()) {
                            if (meta.isMissing(entry)) continue;
                            DPBuilder.this.copyResource(entry, (InputStream)cache.load(meta.getHandle(entry)), jarOut);
                        }
                    }
                    catch (IOException ioE) {
                        throw new RuntimeException(ioE);
                    }
                    finally {
                        try {
                            if (jarOut != null) {
                                jarOut.close();
                            }
                            pout.close();
                        }
                        catch (Exception e) {}
                        LOG.debug((Object)"Copy thread finished.");
                    }
                }
            }.start();
        }
        catch (Exception e) {
            LOG.error((Object)"problem ! ", (Throwable)e);
        }
        return pin;
    }

    private void copyResource(String nameSection, InputStream inputStream, JarOutputStream jarOut) throws IOException {
        JarEntry zipEntry = new JarEntry(nameSection);
        jarOut.putNextEntry(zipEntry);
        StreamUtils.copyStream((InputStream)inputStream, (OutputStream)jarOut, (boolean)false);
        jarOut.closeEntry();
    }
}

