/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.osgi.framework.Bundle;

public abstract class BundleEntryScanner<T>
implements BundleScanner<T> {
    private final String m_path;
    private final String m_filePattern;
    private final boolean m_recurse;
    private final String m_pathManifestHeader;
    private final String m_filePatternManifestHeader;
    private final String m_recurseManifestHeader;

    public BundleEntryScanner(String path, String filePattern, boolean recurse) {
        this(null, null, null, path, filePattern, recurse);
        NullArgumentException.validateNotNull((Object)"Path", (String)path);
        NullArgumentException.validateNotNull((Object)"File pattern", (String)filePattern);
    }

    public BundleEntryScanner(String pathManifestHeader, String filePatternManifestHeader, String recurseManifestHeader, String path, String filePattern, boolean recurse) {
        this.m_pathManifestHeader = pathManifestHeader;
        this.m_filePatternManifestHeader = filePatternManifestHeader;
        this.m_recurseManifestHeader = recurseManifestHeader;
        this.m_path = path == null ? "/" : (path.endsWith("/") ? path : path + "/");
        this.m_filePattern = filePattern;
        this.m_recurse = recurse;
    }

    protected String getPath(Bundle bundle) {
        Object value;
        if (this.m_pathManifestHeader != null && (value = bundle.getHeaders().get(this.m_pathManifestHeader)) instanceof String && ((String)value).trim().length() > 0) {
            Object path = (String)value;
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            return path;
        }
        return this.m_path;
    }

    protected String getFilePattern(Bundle bundle) {
        Object value;
        if (this.m_filePatternManifestHeader != null && (value = bundle.getHeaders().get(this.m_filePatternManifestHeader)) instanceof String && ((String)value).trim().length() > 0) {
            return (String)value;
        }
        return this.m_filePattern;
    }

    protected boolean getRecurse(Bundle bundle) {
        Object value;
        if (this.m_recurseManifestHeader != null && (value = bundle.getHeaders().get(this.m_recurseManifestHeader)) instanceof String && ((String)value).trim().length() > 0 && (((String)value).trim().equalsIgnoreCase("true") || ((String)value).trim().equalsIgnoreCase("false"))) {
            return Boolean.valueOf((String)value);
        }
        return this.m_recurse;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("path=").append(this.m_path).append(",filePattern=").append(this.m_filePattern).append(",recurse=").append(this.m_recurse).append("}").toString();
    }
}

