/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWatcher<T>
extends AbstractLifecycle {
    private static final Log LOG = LogFactory.getLog(BundleWatcher.class);
    private final BundleContext m_context;
    private final BundleScanner<T> m_scanner;
    private final List<BundleObserver<T>> m_observers;
    private Map<Bundle, List<T>> m_mappings;
    private BundleListener m_bundleListener;
    private final ExecutorService executorService;

    public BundleWatcher(BundleContext context, BundleScanner<T> scanner) {
        this(context, scanner, null);
    }

    public BundleWatcher(BundleContext context, BundleScanner<T> scanner, BundleObserver<T> ... observers) {
        LOG.debug((Object)("Creating bundle watcher with scanner [" + scanner + "]..."));
        NullArgumentException.validateNotNull((Object)context, (String)"Context");
        NullArgumentException.validateNotNull(scanner, (String)"Bundle scanner");
        this.m_context = context;
        this.m_scanner = scanner;
        this.m_observers = new ArrayList<BundleObserver<T>>();
        if (observers != null) {
            this.m_observers.addAll(Arrays.asList(observers));
        }
        this.executorService = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("Executor: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    void destroy() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void onStart() {
        this.m_mappings = new HashMap<Bundle, List<T>>();
        this.m_bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                switch (bundleEvent.getType()) {
                    case 2: {
                        BundleWatcher.this.register(bundleEvent.getBundle());
                        break;
                    }
                    case 4: {
                        BundleWatcher.this.unregister(bundleEvent.getBundle());
                    }
                }
            }
        };
        this.m_context.addBundleListener(this.m_bundleListener);
        Bundle[] bundles = this.m_context.getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (bundle.getState() != 32) continue;
                this.register(bundle);
            }
        }
    }

    protected void onStop() {
        Bundle[] toBeRemoved;
        this.m_context.removeBundleListener(this.m_bundleListener);
        for (Bundle bundle : toBeRemoved = this.m_mappings.keySet().toArray(new Bundle[this.m_mappings.keySet().size()])) {
            this.unregister(bundle);
        }
        this.m_bundleListener = null;
        this.m_mappings = null;
    }

    private void register(final Bundle bundle) {
        LOG.debug((Object)("Scanning bundle [" + bundle.getSymbolicName() + "]"));
        final List<T> resources = this.m_scanner.scan(bundle);
        this.m_mappings.put(bundle, resources);
        if (resources != null && resources.size() > 0) {
            LOG.debug((Object)("Found resources " + resources));
            for (final BundleObserver<T> observer : this.m_observers) {
                try {
                    this.executorService.submit(new Runnable(){

                        public void run() {
                            observer.addingEntries(bundle, Collections.unmodifiableList(resources));
                        }
                    });
                }
                catch (Throwable ignore) {
                    LOG.error((Object)"Ignored exception during register", ignore);
                }
            }
        }
    }

    private void unregister(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        LOG.debug((Object)("Releasing bundle [" + bundle.getSymbolicName() + "]"));
        List<T> resources = this.m_mappings.get(bundle);
        if (resources != null && resources.size() > 0) {
            LOG.debug((Object)("Un-registering " + resources));
            for (BundleObserver<T> observer : this.m_observers) {
                try {
                    observer.removingEntries(bundle, Collections.unmodifiableList(resources));
                }
                catch (Throwable ignore) {
                    LOG.error((Object)"Ignored exception during un-register", ignore);
                }
            }
        }
        this.m_mappings.remove(bundle);
    }
}

