/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.bnd;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;

public class BndUtils {
    private static final Log LOG = LogFactory.getLog(BndUtils.class);
    private static final Pattern INSTRUCTIONS_PATTERN = Pattern.compile("([a-zA-Z_0-9-]+)=([\\-!\"'()\\[\\]*+,.0-9A-Z_a-z%;:=/\\s]+)");
    private static final Pattern CAMELCASE_PATTERN = Pattern.compile("/\\b([A-Z][a-z]*){2,}\\b/");

    private BndUtils() {
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo) throws IOException {
        return BndUtils.createBundle(jarInputStream, instructions, jarInfo, OverwriteMode.KEEP);
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo, OverwriteMode overwriteMode) throws IOException {
        NullArgumentException.validateNotNull((Object)jarInputStream, (String)"Jar URL");
        NullArgumentException.validateNotNull((Object)instructions, (String)"Instructions");
        NullArgumentException.validateNotEmpty((String)jarInfo, (String)"Jar info");
        LOG.debug((Object)("Creating bundle for [" + jarInfo + "]"));
        LOG.debug((Object)("Overwrite mode: " + (Object)((Object)overwriteMode)));
        LOG.trace((Object)("Using instructions " + instructions));
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = jar.getManifest();
        if (manifest == null || OverwriteMode.KEEP != overwriteMode || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)instructions);
            properties.put("Generated-By-Ops4j-Pax-From", jarInfo);
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            if (manifest != null && OverwriteMode.MERGE == overwriteMode) {
                analyzer.mergeManifest(manifest);
            }
            BndUtils.checkMandatoryProperties(analyzer, jar, jarInfo);
            analyzer.calcManifest();
        }
        return BndUtils.createInputStream(jar);
    }

    private static PipedInputStream createInputStream(final Jar jar) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    jar.write((OutputStream)pout);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Bundle cannot be generated", (Throwable)e);
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error((Object)"Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", analyzer.calculateExportsFromContents(jar));
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndUtils.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }

    public static Properties parseInstructions(String query) throws MalformedURLException {
        Properties instructions = new Properties();
        if (query != null) {
            try {
                String[] segments;
                for (String segment : segments = query.split("&")) {
                    if (segment.trim().length() <= 0) continue;
                    Matcher matcher = INSTRUCTIONS_PATTERN.matcher(segment);
                    if (matcher.matches()) {
                        instructions.setProperty(BndUtils.verifyKey(matcher.group(1)), URLDecoder.decode(matcher.group(2), "UTF-8"));
                        continue;
                    }
                    throw new MalformedURLException("Invalid syntax for instruction [" + segment + "]. Take a look at http://www.aqute.biz/Code/Bnd.");
                }
            }
            catch (UnsupportedEncodingException e) {
                BndUtils.throwAsMalformedURLException("Could not retrieve the instructions from [" + query + "]", e);
            }
        }
        return instructions;
    }

    private static String verifyKey(String key) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(Constants.headers));
        list.add("Web-ContextPath");
        if (list.contains(key)) {
            return key;
        }
        if (CAMELCASE_PATTERN.matcher(key).matches()) {
            return key;
        }
        for (String header : list) {
            if (!header.equalsIgnoreCase(key)) continue;
            return header;
        }
        return key;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }
}

