/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.daemon;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.ops4j.io.Pipe;
import org.ops4j.pax.runner.CommandLine;
import org.ops4j.pax.runner.CommandLineImpl;
import org.ops4j.pax.runner.Run;
import org.ops4j.pax.runner.User;
import org.ops4j.pax.runner.daemon.Daemon;

public class DaemonLauncher {
    public static final String OPTION_START = "--start";
    public static final String OPTION_STARTD = "--startd";
    public static final String OPTION_STOP = "--stop";
    public static final String SPACE = " ";
    private CommandLine commandLine = null;
    private String[] cmdArgs = null;
    private static DaemonLauncher instance = null;
    private static final Log LOG = Run.getLogger();

    public static final DaemonLauncher getInstance() {
        if (instance == null) {
            instance = new DaemonLauncher();
        }
        return instance;
    }

    private DaemonLauncher() {
    }

    public static void main(String[] args) {
        String operation = args == null || args.length == 0 ? null : args[0];
        DaemonLauncher launcher = DaemonLauncher.getInstance();
        if (OPTION_START.equals(operation)) {
            launcher.load(args);
            launcher.start();
        } else if (OPTION_STARTD.equals(operation)) {
            launcher.load(args);
            launcher.startd();
        } else if (OPTION_STOP.equals(operation)) {
            launcher.load(args);
            launcher.stop();
        } else {
            throw new RuntimeException("No valid option specified for Pax Runner Daemon. The specified option should be first argument.\nValid options: --start | --startd | --stop");
        }
    }

    private void load(String[] args) {
        this.cmdArgs = args;
        this.commandLine = new CommandLineImpl(args);
    }

    private void start() {
        this.checkPasswordFile();
        Daemon.main(this.cmdArgs);
    }

    private void startd() {
        this.checkPasswordFile();
        Thread newProc = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String cp = System.getProperty("java.class.path") == null ? "" : "-cp " + System.getProperty("java.class.path");
                    String strCmd = "java " + cp + DaemonLauncher.SPACE + "org.ops4j.pax.runner.daemon.Daemon";
                    for (String cmd : DaemonLauncher.this.cmdArgs) {
                        strCmd = strCmd + DaemonLauncher.SPACE + cmd;
                    }
                    LOG.debug((Object)("Starting command line: " + strCmd));
                    Process proc = Runtime.getRuntime().exec(strCmd);
                    Runtime.getRuntime().addShutdownHook(this.createShutdownHook(proc));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private Thread createShutdownHook(Process process) {
                final Pipe errPipe = new Pipe(process.getErrorStream(), System.err).start("Error pipe");
                final Pipe outPipe = new Pipe(process.getInputStream(), System.out).start("Out pipe");
                final Pipe inPipe = new Pipe(process.getOutputStream(), System.in).start("In pipe");
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        errPipe.stop();
                        outPipe.stop();
                        inPipe.stop();
                    }
                }, "Pax-Runner Daemon Shutdown Hook");
            }
        }, "Pax-Runner DaemonLauncher");
        newProc.setDaemon(true);
        newProc.start();
        try {
            Thread.sleep(4000L);
            newProc.join();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Problems in waiting for the launched thread.");
        }
        LOG.info((Object)"Pax-Runner Daemon launched !");
    }

    private void stop() {
        if (Daemon.isDaemonStarted()) {
            Socket socket = null;
            PrintWriter out = null;
            try {
                socket = new Socket("localhost", Daemon.getShutdownPort());
                out = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (UnknownHostException e) {
                LOG.error((Object)"Unknown address: localhost.");
                return;
            }
            catch (IOException e) {
                LOG.error((Object)"Couldn't connect to: localhost.");
                return;
            }
            String shutdownCmd = Daemon.getShutdown();
            out.write(shutdownCmd + "\n");
            out.flush();
            LOG.debug((Object)("Pax Runner Daemon: Shutdown command issued:" + shutdownCmd));
            do {
                LOG.info((Object)"Pax Runner Daemon: Shutdown in progress...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (Daemon.isDaemonStarted());
            LOG.info((Object)"Pax Runner Daemon Stopped.");
        } else {
            LOG.warn((Object)"No Daemons yet launched!");
        }
    }

    private void checkPasswordFile() {
        File passwordFile = Daemon.getPasswordFile(this.commandLine.getOption("org.ops4j.pax.runner.daemon.password.file"));
        if (!passwordFile.exists()) {
            try {
                LOG.warn((Object)"Password for this configuration is not set.");
                boolean done = false;
                do {
                    LOG.warn((Object)"Please enter a new password: ");
                    String response = User.ask();
                    if (response.trim().length() == 0) {
                        passwordFile.createNewFile();
                        done = true;
                        continue;
                    }
                    LOG.warn((Object)"Please re-enter the new password: ");
                    String confirm = User.ask();
                    if (confirm.equals(response)) {
                        response = Daemon.encrypt(response);
                        passwordFile.createNewFile();
                        Daemon.writeToFile(passwordFile, response);
                        done = true;
                        continue;
                    }
                    LOG.warn((Object)"Passwords did not match.");
                } while (!done);
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting password ", e);
            }
        } else {
            LOG.info((Object)"Password exists for this configuration.");
        }
    }
}

