/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.url.war.internal.AbstractConnection;
import org.ops4j.pax.url.war.internal.Configuration;

public class WarConnection
extends AbstractConnection {
    private static final String JAVAX_SERVLET_HTTP = "javax.servlet.http";
    private static final String JAVAX_SERVLET = "javax.servlet";
    private static final String APACHE_JASPER = "org.apache.jasper";
    private static final String APACHE_TAGLIBS = "org.apache.taglibs";
    private static final String SUN_EL = "com.sun.el";

    public WarConnection(URL url, Configuration config) throws MalformedURLException {
        super(url, config);
    }

    protected Properties getInstructions() throws MalformedURLException {
        String importPackages;
        Properties instructions = BndUtils.parseInstructions(this.getURL().getQuery());
        instructions.setProperty("WAR-URL", this.getURL().getPath());
        if (!instructions.containsKey("Import-Package")) {
            String packages = "javax.servlet,javax.servlet.http,javax.*; resolution:=optional,org.apache.jasper.*;resolution:=optional,org.apache.taglibs.*;resolution:=optional,com.sun.el.*;resolution:=optional,org.xml.*; resolution:=optional,org.w3c.*; resolution:=optional";
            instructions.setProperty("Import-Package", packages);
        } else {
            importPackages = instructions.getProperty("Import-Package");
            if (importPackages.contains(JAVAX_SERVLET) || importPackages.contains(JAVAX_SERVLET_HTTP)) {
                String[] imports;
                boolean servletFound = false;
                boolean servletHttpFound = false;
                for (String importstmt : imports = importPackages.split(",")) {
                    if (!importstmt.contains(JAVAX_SERVLET)) continue;
                    if (importstmt.length() > JAVAX_SERVLET.length() && importstmt.charAt(JAVAX_SERVLET.length()) == '.') {
                        if (!importstmt.contains(JAVAX_SERVLET_HTTP)) continue;
                        servletHttpFound = true;
                        continue;
                    }
                    servletFound = true;
                }
                if (!servletFound) {
                    importPackages = importPackages + ",javax.servlet";
                }
                if (!servletHttpFound) {
                    importPackages = importPackages + ",javax.servlet.http";
                }
            } else {
                importPackages = importPackages + ",javax.servlet,javax.servlet.http";
            }
            if (!importPackages.contains(APACHE_JASPER)) {
                importPackages = importPackages + ",org.apache.jasper.*;resolution:=optional";
            }
            if (!importPackages.contains(APACHE_TAGLIBS)) {
                importPackages = importPackages + ",org.apache.taglibs.*;resolution:=optional";
            }
            if (!importPackages.contains(SUN_EL)) {
                importPackages = importPackages + ",com.sun.el.*;resolution:=optional";
            }
            instructions.setProperty("Import-Package", importPackages);
        }
        if (this.getConfiguration().getImportPaxLoggingPackages().booleanValue()) {
            importPackages = instructions.getProperty("Import-Package");
            String provider = ";provider=paxlogging;resolution:=optional";
            importPackages = importPackages + ",org.apache.commons.logging" + provider + ",org.apache.commons.logging.impl" + provider + ",org.apache.log4j" + provider + ",org.apache.log4j.spi" + provider + ",org.apache.log4j.xml" + provider + ",org.slf4j" + provider + ",org.slf4j.helpers" + provider + ",org.slf4j.spi" + provider;
            instructions.setProperty("Import-Package", importPackages);
        }
        if (!instructions.containsKey("Export-Package")) {
            instructions.setProperty("Export-Package", "!*");
        }
        if (!instructions.containsKey("-removeheaders")) {
            instructions.setProperty("-removeheaders", "Private-Package,Ignore-Package");
        }
        return instructions;
    }
}

