/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.ops4j.pax.url.war.internal.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConnection
extends URLConnection {
    private final Configuration m_configuration;
    private static DocumentBuilderFactory dbf = null;
    private static final Pattern[] blacklist = new Pattern[]{Pattern.compile("servlet\\.jar"), Pattern.compile("servlet-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("servlet-api\\.jar"), Pattern.compile("servlet-api-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("jasper\\.jar"), Pattern.compile("jasper-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("jsp-api\\.jar"), Pattern.compile("jsp-api-[0-9]+(\\.[0-9])+\\.jar")};

    protected AbstractConnection(URL url, Configuration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        NullArgumentException.validateNotNull(configuration, "Configuration");
        String path = url.getPath();
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot empty");
        }
        this.m_configuration = configuration;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        Properties instructions = this.getInstructions();
        PreConditionException.validateNotNull(instructions, "Instructions");
        String warUri = instructions.getProperty("WAR-URL");
        if (warUri == null || warUri.trim().length() == 0) {
            throw new IOException("Instructions file must contain a property named WAR-URL");
        }
        AbstractConnection.generateClassPathInstruction(instructions);
        AbstractConnection.generateImportPackageFromWebXML(instructions);
        return this.createBundle(URLUtils.prepareInputStream(new URL(warUri), this.m_configuration.getCertificateCheck()), instructions, warUri);
    }

    protected InputStream createBundle(InputStream inputStream, Properties instructions, String warUri) throws IOException {
        return BndUtils.createBundle(inputStream, instructions, warUri);
    }

    protected InputStream createBundle(InputStream inputStream, Properties instructions, String warUri, OverwriteMode overwriteMode) throws IOException {
        return BndUtils.createBundle(inputStream, instructions, warUri, overwriteMode);
    }

    protected abstract Properties getInstructions() throws IOException;

    protected Configuration getConfiguration() {
        return this.m_configuration;
    }

    private static void generateClassPathInstruction(Properties instructions) throws IOException {
        ArrayList<String> bundleClassPath = new ArrayList<String>();
        bundleClassPath.addAll(AbstractConnection.toList(instructions.getProperty("Bundle-ClassPath"), ","));
        bundleClassPath.addAll(AbstractConnection.extractJarListFromWar(instructions.getProperty("WAR-URL")));
        if (!bundleClassPath.contains("WEB-INF/classes")) {
            bundleClassPath.add(0, "WEB-INF/classes");
        }
        instructions.setProperty("Bundle-ClassPath", AbstractConnection.join(bundleClassPath, ","));
    }

    private static void generateImportPackageFromWebXML(Properties instructions) throws IOException {
        String warUri = instructions.getProperty("WAR-URL");
        ZipFile jarFile = null;
        ArrayList<String> webXmlImports = new ArrayList<String>();
        try {
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/").openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!"WEB-INF/web.xml".equalsIgnoreCase(entry.getName())) continue;
                if (dbf == null) {
                    dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setValidating(false);
                    dbf.setAttribute("http://xml.org/sax/features/namespaces", true);
                    dbf.setAttribute("http://xml.org/sax/features/validation", false);
                    dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(((JarFile)jarFile).getInputStream(entry));
                NodeList childNodes = doc.getDocumentElement().getChildNodes();
                AbstractConnection.parseChildNodes(webXmlImports, childNodes);
                break;
            }
            StringBuffer buff = new StringBuffer(instructions.getProperty("Import-Package"));
            for (String importPackage : webXmlImports) {
                if (buff.toString().contains(importPackage)) continue;
                buff.append(",");
                buff.append(importPackage);
                buff.append(";resolution:=optional");
            }
            instructions.setProperty("Import-Package", buff.toString());
        }
        catch (ClassCastException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (MalformedURLException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (IOException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (SAXException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static void parseChildNodes(List<String> webXmlImports, NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName;
            Node node = childNodes.item(i);
            NodeList subNodes = node.getChildNodes();
            if (subNodes != null) {
                AbstractConnection.parseChildNodes(webXmlImports, subNodes);
            }
            if (!(nodeName = node.getNodeName()).contains("-class")) continue;
            String lookupClass = node.getTextContent();
            String packageName = lookupClass.substring(0, lookupClass.lastIndexOf(".")).trim();
            webXmlImports.add(packageName);
        }
    }

    @Override
    public void connect() {
    }

    private static List<String> extractJarListFromWar(String warUri) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ZipFile jarFile = null;
        try {
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/").openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar") || !AbstractConnection.checkJarIsLegal(name)) continue;
                list.add(name);
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignore) {}
            }
        }
        return list;
    }

    protected static boolean checkJarIsLegal(String name) {
        Pattern pattern;
        boolean isMatched = false;
        Pattern[] arr$ = blacklist;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(isMatched = (pattern = arr$[i$]).matcher(name).find()); ++i$) {
        }
        return !isMatched;
    }

    protected static List<String> toList(String separatedString, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (separatedString != null) {
            list.addAll(Arrays.asList(separatedString.split(delimiter)));
        }
        return list;
    }

    protected static String join(Collection<String> strings, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }
}

