/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.util.tracker.BundleTrackerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class InternalRecursiveBundleTracker
extends BundleTracker {
    private final int mask;
    private final Set<BundleContext> alreadyRecursedContexts = new HashSet<BundleContext>();
    private final BundleTrackerCustomizer customizer;

    public InternalRecursiveBundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        super(context, stateMask, null);
        this.mask = stateMask;
        this.customizer = customizer;
    }

    public Object addingBundle(Bundle b, BundleEvent event) {
        Object o = null;
        if (b instanceof CompositeBundle) {
            this.customizedProcessBundle((BundleTrackerCustomizer)this, b, event);
            o = b;
        } else if (this.customizer != null) {
            o = this.customizer.addingBundle(b, event);
        }
        return o;
    }

    public void modifiedBundle(Bundle b, BundleEvent event, Object object) {
        if (b instanceof CompositeBundle) {
            this.customizedProcessBundle((BundleTrackerCustomizer)this, b, event);
        } else if (this.customizer != null) {
            this.customizer.modifiedBundle(b, event, object);
        }
    }

    public void removedBundle(Bundle b, BundleEvent event, Object object) {
        if (b instanceof CompositeBundle) {
            this.customizedProcessBundle((BundleTrackerCustomizer)this, b, event);
        } else if (this.customizer != null) {
            this.customizer.removedBundle(b, event, object);
        }
    }

    protected void customizedProcessBundle(BundleTrackerCustomizer btc, Bundle b, BundleEvent event) {
        if (b instanceof CompositeBundle) {
            CompositeBundle cb = (CompositeBundle)b;
            String bundleScope = cb.getSymbolicName() + "_" + cb.getVersion().toString();
            List<BundleTracker> btList = BundleTrackerFactory.getBundleTrackerList(bundleScope);
            if (event == null) {
                if (cb.getState() == 2 || cb.getState() == 4 || cb.getState() == 8 || cb.getState() == 32) {
                    this.openTracker(btc, cb, bundleScope, this.mask);
                }
            } else if (event.getType() == 4) {
                BundleContext compositeBundleContext = ((CompositeBundle)b).getCompositeFramework().getBundleContext();
                this.alreadyRecursedContexts.remove(compositeBundleContext);
                if (btList != null) {
                    BundleTrackerFactory.unregisterAndCloseBundleTracker(bundleScope);
                }
            } else if (event.getType() == 1 || event.getType() == 128) {
                this.openTracker(btc, cb, bundleScope, this.mask);
            }
        }
    }

    private synchronized void openTracker(BundleTrackerCustomizer btc, CompositeBundle cb, String bundleScope, int stateMask) {
        BundleContext compositeBundleContext = cb.getCompositeFramework().getBundleContext();
        if (!this.alreadyRecursedContexts.contains(compositeBundleContext)) {
            this.alreadyRecursedContexts.add(compositeBundleContext);
            InternalRecursiveBundleTracker bt = new InternalRecursiveBundleTracker(compositeBundleContext, stateMask, this.customizer);
            bt.open();
            BundleTrackerFactory.registerBundleTracker(bundleScope, bt);
        }
    }
}

