/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.features.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.kernel.gshell.features.Feature;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.ScannedBundleBean;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.pax.scanner.features.internal.FeaturesFilter;
import org.ops4j.pax.scanner.features.internal.FeaturesServiceWrapper;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(FeaturesScanner.class);
    private PropertyResolver m_propertyResolver;

    public FeaturesScanner(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug((Object)("Scanning [" + provisionSpec.getPath() + "]"));
        ScannerConfiguration config = this.createConfiguration();
        Integer defaultStartLevel = this.getDefaultStartLevel(provisionSpec, config);
        Boolean defaultStart = this.getDefaultStart(provisionSpec, config);
        Boolean defaultUpdate = this.getDefaultUpdate(provisionSpec, config);
        FeaturesServiceWrapper featuresService = new FeaturesServiceWrapper();
        try {
            featuresService.addRepository(provisionSpec.getPathAsUrl().toURI());
        }
        catch (Exception e) {
            throw new ScannerException("Repository URL cannot be used", e);
        }
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        for (FeaturesFilter featuresFilter : FeaturesFilter.fromProvisionSpec(provisionSpec)) {
            scannedBundles.addAll(this.features(featuresService, featuresFilter.getName(), featuresFilter.getVersion(), defaultStartLevel, defaultStart, defaultUpdate));
        }
        return scannedBundles;
    }

    private List<ScannedBundle> features(FeaturesServiceWrapper featuresService, String featureName, String featureVersion, Integer startLevel, Boolean shouldStart, Boolean shouldUpdate) throws ScannerException {
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        try {
            Feature feature = featuresService.getFeature(featureName, featureVersion);
            if (feature == null) {
                throw new ScannerException("No feature named '" + featureName + "' with version '" + featureVersion + "' available");
            }
            for (Feature dependency : feature.getDependencies()) {
                scannedBundles.addAll(this.features(featuresService, dependency.getName(), dependency.getVersion(), startLevel, shouldStart, shouldUpdate));
            }
            for (String bundleUrl : feature.getBundles()) {
                ScannedBundleBean scannedBundle = new ScannedBundleBean(bundleUrl, startLevel, shouldStart, shouldUpdate);
                scannedBundles.add(scannedBundle);
                LOGGER.debug((Object)("Installing bundle [" + scannedBundles + "]"));
            }
            return scannedBundles;
        }
        catch (Exception e) {
            throw new ScannerException("Cannot find a feature named '" + featureName + "' with version '" + featureVersion + "'", e);
        }
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.features");
    }
}

