/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.sift;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionFactory;

public class MDCSiftingAppender
extends AppenderSkeleton {
    private String key;
    private String defaultValue = "default";
    private OptionFactory appender;
    private Map<String, Node> appenders = new HashMap<String, Node>();
    private Node head = null;
    private Node tail = null;
    private long lastCheck;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public OptionFactory getAppender() {
        return this.appender;
    }

    public void setAppender(OptionFactory appender) {
        this.appender = appender;
    }

    @Override
    protected void append(LoggingEvent event) {
        Object value = event.getMDC(this.key);
        Map mdc = event.getProperties();
        String valStr = value == null ? this.defaultValue : value.toString();
        Appender app = this.getAppender(valStr, mdc);
        app.doAppend(event);
    }

    @Override
    public synchronized void close() {
        for (Node node : this.appenders.values()) {
            node.appender.close();
        }
        this.appenders.clear();
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    protected synchronized Appender getAppender(String valStr, Map<?, ?> mdc) {
        long timestamp = System.currentTimeMillis();
        Node node = this.appenders.get(valStr);
        if (node == null) {
            node = new Node();
            Properties props = new Properties();
            props.put(this.key, valStr);
            props.putAll(mdc);
            node.next = this.head;
            node.prev = null;
            node.appender = (Appender)((Object)this.appender.create(props));
            node.appender.setName(this.getName() + "[" + valStr + "]");
            node.timestamp = timestamp;
            this.head = node;
            if (this.tail == null) {
                this.tail = node;
            }
            this.appenders.put(valStr, node);
        } else {
            Node p = node.prev;
            Node n = node.next;
            node.next = this.head;
            node.prev = null;
            this.head = node;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
            } else {
                this.tail = p;
            }
            node.timestamp = timestamp;
        }
        if (timestamp - this.lastCheck > 1000L) {
            Node n = this.tail;
            while (n != null && timestamp - n.timestamp > 1800000L) {
                n.appender.close();
                n = n.prev;
            }
            if (n == null) {
                this.head = null;
                this.tail = null;
            } else {
                n.next = null;
                this.tail = n;
            }
        }
        return node.appender;
    }

    protected static class Node {
        Node next;
        Node prev;
        Appender appender;
        long timestamp;

        protected Node() {
        }
    }
}

