/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    protected final CopyOnWriteArrayList<Appender> appenderList = new CopyOnWriteArrayList();

    @Override
    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        this.appenderList.addIfAbsent(newAppender);
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int nb = 0;
        for (Appender appender : this.appenderList) {
            appender.doAppend(event);
            ++nb;
        }
        return nb;
    }

    public void closeAppenders() {
        for (Appender appender : this.appenderList) {
            appender.close();
        }
    }

    @Override
    public Enumeration getAllAppenders() {
        return new Enumeration(){
            final Iterator it;
            {
                this.it = AppenderAttachableImpl.this.appenderList.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return this.it.next();
            }
        };
    }

    public Iterable<Appender> getAppenders() {
        return this.appenderList;
    }

    @Override
    public Appender getAppender(String name) {
        if (name == null) {
            return null;
        }
        for (Appender appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        for (Appender a : this.appenderList) {
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllAppenders() {
        for (Appender a : this.appenderList) {
            a.close();
        }
        this.appenderList.clear();
    }

    @Override
    public void removeAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        this.appenderList.remove(appender);
    }

    @Override
    public void removeAppender(String name) {
        if (name == null) {
            return;
        }
        Iterator<Appender> it = this.appenderList.iterator();
        while (it.hasNext()) {
            if (!name.equals(it.next().getName())) continue;
            it.remove();
            break;
        }
    }
}

