/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private final List<LoggingEvent> buffer = new ArrayList<LoggingEvent>();
    private final Map<String, DiscardSummary> discardMap = new HashMap<String, DiscardSummary>();
    private int bufferSize = 128;
    AppenderAttachableImpl aai = this.appenders = new AppenderAttachableImpl();
    private final AppenderAttachableImpl appenders;
    private final Thread dispatcher = new Thread(new Dispatcher());
    private boolean locationInfo = false;
    private boolean blocking = true;

    public AsyncAppender() {
        this.dispatcher.setDaemon(true);
        this.dispatcher.setName("AsyncAppender-Dispatcher-" + this.dispatcher.getName());
        this.dispatcher.start();
    }

    @Override
    public void doAppend(LoggingEvent event) {
        if (this.closed) {
            LogLog.error("Attempted to append to closed appender named [" + this.name + "].");
            return;
        }
        if (!this.isAsSevereAsThreshold(event.getLevel())) {
            return;
        }
        Filter f = this.headFilter;
        block5: while (f != null) {
            switch (f.decide(event)) {
                case -1: {
                    return;
                }
                case 1: {
                    break block5;
                }
                case 0: {
                    f = f.getNext();
                }
                default: {
                    continue block5;
                }
            }
        }
        this.append(event);
    }

    @Override
    public void addAppender(Appender newAppender) {
        this.appenders.addAppender(newAppender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LoggingEvent event) {
        if (!this.dispatcher.isAlive() || this.bufferSize <= 0) {
            this.appenders.appendLoopOnAppenders(event);
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        event.getRenderedMessage();
        event.getThrowableStrRep();
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            block12: {
                boolean discard;
                do {
                    int previousSize;
                    if ((previousSize = this.buffer.size()) < this.bufferSize) {
                        this.buffer.add(event);
                        if (previousSize == 0) {
                            this.buffer.notifyAll();
                        }
                        break block12;
                    }
                    discard = true;
                    if (!this.blocking || Thread.interrupted() || Thread.currentThread() == this.dispatcher) continue;
                    try {
                        this.buffer.wait();
                        discard = false;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } while (!discard);
                String loggerName = event.getLoggerName();
                DiscardSummary summary = this.discardMap.get(loggerName);
                if (summary == null) {
                    summary = new DiscardSummary(event);
                    this.discardMap.put(loggerName, summary);
                } else {
                    summary.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            this.closed = true;
            this.buffer.notifyAll();
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", e);
        }
        this.appenders.closeAppenders();
    }

    @Override
    public Enumeration getAllAppenders() {
        return this.appenders.getAllAppenders();
    }

    @Override
    public Appender getAppender(String name) {
        return this.appenders.getAppender(name);
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public boolean isAttached(Appender appender) {
        return this.appenders.isAttached(appender);
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    @Override
    public void removeAllAppenders() {
        this.appenders.removeAllAppenders();
    }

    @Override
    public void removeAppender(Appender appender) {
        this.appenders.removeAppender(appender);
    }

    @Override
    public void removeAppender(String name) {
        this.appenders.removeAppender(name);
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size");
        }
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            this.bufferSize = size < 1 ? 1 : size;
            this.buffer.notifyAll();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean value) {
        List<LoggingEvent> list = this.buffer;
        synchronized (list) {
            this.blocking = value;
            this.buffer.notifyAll();
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    private class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isActive = true;
            try {
                while (isActive) {
                    LoggingEvent[] events = null;
                    List list = AsyncAppender.this.buffer;
                    synchronized (list) {
                        int bufferSize = AsyncAppender.this.buffer.size();
                        boolean bl = isActive = !AsyncAppender.this.closed;
                        while (bufferSize == 0 && isActive) {
                            AsyncAppender.this.buffer.wait();
                            bufferSize = AsyncAppender.this.buffer.size();
                            isActive = !AsyncAppender.this.closed;
                        }
                        if (AsyncAppender.this.closed && !AsyncAppender.this.blocking) {
                            break;
                        }
                        if (bufferSize > 0) {
                            events = new LoggingEvent[bufferSize + AsyncAppender.this.discardMap.size()];
                            AsyncAppender.this.buffer.toArray(events);
                            int index = bufferSize;
                            Iterator iterator = AsyncAppender.this.discardMap.values().iterator();
                            while (iterator.hasNext()) {
                                events[index++] = ((DiscardSummary)iterator.next()).createEvent();
                            }
                            AsyncAppender.this.buffer.clear();
                            AsyncAppender.this.discardMap.clear();
                            AsyncAppender.this.buffer.notifyAll();
                        }
                    }
                    if (events == null) continue;
                    for (List list2 : events) {
                        AsyncAppender.this.appenders.appendLoopOnAppenders((LoggingEvent)((Object)list2));
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DiscardSummary {
        private LoggingEvent maxEvent;
        private int count;

        public DiscardSummary(LoggingEvent event) {
            this.maxEvent = event;
            this.count = 1;
        }

        public void add(LoggingEvent event) {
            if (event.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                this.maxEvent = event;
            }
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String msg = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", this.count, this.maxEvent.getMessage());
            return new LoggingEvent("org.apache.log4j.AsyncAppender.DONT_REPORT_LOCATION", Logger.getLogger(this.maxEvent.getLoggerName()), this.maxEvent.getLevel(), msg, null);
        }
    }
}

