/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.util.Strings;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManagerFactory FACTORY = new TcpSocketManagerFactory();
    private final int reconnectionDelay;
    private Reconnector connector;
    private Socket socket;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    public TcpSocketManager(String name, OutputStream os, Socket sock, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int delay, boolean immediateFail, Layout<? extends Serializable> layout) {
        super(name, os, inetAddress, host, port, layout, true);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectionDelay = delay;
        this.socket = sock;
        this.immediateFail = immediateFail;
        boolean bl = this.retry = delay > 0;
        if (sock == null) {
            this.connector = new Reconnector(this);
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    public static TcpSocketManager getSocketManager(String host, int port, int connectTimeoutMillis, int delayMillis, boolean immediateFail, Layout<? extends Serializable> layout) {
        if (Strings.isEmpty(host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 4560;
        }
        if (delayMillis == 0) {
            delayMillis = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + host + ':' + port, new FactoryData(host, port, connectTimeoutMillis, delayMillis, immediateFail, layout), FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        if (this.socket == null) {
            if (this.connector != null && !this.immediateFail) {
                this.connector.latch();
            }
            if (this.socket == null) {
                String msg = "Error writing to " + this.getName() + " socket not available";
                throw new AppenderLoggingException(msg);
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            try {
                OutputStream outputStream = this.getOutputStream();
                outputStream.write(bytes, offset, length);
                if (immediateFlush) {
                    outputStream.flush();
                }
            }
            catch (IOException ex) {
                if (this.retry && this.connector == null) {
                    this.connector = new Reconnector(this);
                    this.connector.setDaemon(true);
                    this.connector.setPriority(1);
                    this.connector.start();
                }
                String msg = "Error writing to " + this.getName();
                throw new AppenderLoggingException(msg, ex);
            }
        }
    }

    @Override
    protected synchronized void close() {
        super.close();
        if (this.connector != null) {
            this.connector.shutdown();
            this.connector.interrupt();
            this.connector = null;
        }
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("protocol", "tcp");
        result.put("direction", "out");
        return result;
    }

    protected Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getHostName(), port);
    }

    protected Socket createSocket(String host, int port) throws IOException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        Socket newSocket = new Socket();
        newSocket.connect(address, this.connectTimeoutMillis);
        return newSocket;
    }

    protected static class TcpSocketManagerFactory
    implements ManagerFactory<TcpSocketManager, FactoryData> {
        protected TcpSocketManagerFactory() {
        }

        @Override
        public TcpSocketManager createManager(String name, FactoryData data) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(data.host);
            }
            catch (UnknownHostException ex) {
                LOGGER.error("Could not find address of " + data.host, (Object)ex, (Object)ex);
                return null;
            }
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(data.host, data.port), data.connectTimeoutMillis);
                OutputStream os = socket.getOutputStream();
                return new TcpSocketManager(name, os, socket, inetAddress, data.host, data.port, data.connectTimeoutMillis, data.delayMillis, data.immediateFail, data.layout);
            }
            catch (IOException ex) {
                LOGGER.error("TcpSocketManager (" + name + ") " + ex, (Throwable)ex);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                if (data.delayMillis == 0) {
                    return null;
                }
                return new TcpSocketManager(name, os, null, inetAddress, data.host, data.port, data.connectTimeoutMillis, data.delayMillis, data.immediateFail, data.layout);
            }
        }
    }

    private static class FactoryData {
        private final String host;
        private final int port;
        private final int connectTimeoutMillis;
        private final int delayMillis;
        private final boolean immediateFail;
        private final Layout<? extends Serializable> layout;

        public FactoryData(String host, int port, int connectTimeoutMillis, int delayMillis, boolean immediateFail, Layout<? extends Serializable> layout) {
            this.host = host;
            this.port = port;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.delayMillis = delayMillis;
            this.immediateFail = immediateFail;
            this.layout = layout;
        }
    }

    private class Reconnector
    extends Thread {
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean shutdown = false;
        private final Object owner;

        public Reconnector(OutputStreamManager owner) {
            this.owner = owner;
        }

        public void latch() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Reconnector.sleep(TcpSocketManager.this.reconnectionDelay);
                    Socket sock = TcpSocketManager.this.createSocket(TcpSocketManager.this.inetAddress, TcpSocketManager.this.port);
                    OutputStream newOS = sock.getOutputStream();
                    Object object = this.owner;
                    synchronized (object) {
                        try {
                            TcpSocketManager.this.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        TcpSocketManager.this.setOutputStream(newOS);
                        TcpSocketManager.this.socket = sock;
                        TcpSocketManager.this.connector = null;
                        this.shutdown = true;
                    }
                    LOGGER.debug("Connection to " + TcpSocketManager.this.host + ':' + TcpSocketManager.this.port + " reestablished.");
                }
                catch (InterruptedException ie) {
                    LOGGER.debug("Reconnection interrupted.");
                }
                catch (ConnectException ex) {
                    LOGGER.debug(TcpSocketManager.this.host + ':' + TcpSocketManager.this.port + " refused connection");
                }
                catch (IOException ioe) {
                    LOGGER.debug("Unable to reconnect to " + TcpSocketManager.this.host + ':' + TcpSocketManager.this.port);
                }
                finally {
                    this.latch.countDown();
                }
            }
        }
    }
}

