/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.Log4jThread;

public class ConfiguratonFileWatcher
implements FileWatcher {
    private final Reconfigurable reconfigurable;
    private final List<ConfigurationListener> listeners;

    public ConfiguratonFileWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> listeners) {
        this.reconfigurable = reconfigurable;
        this.listeners = listeners;
    }

    public List<ConfigurationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void fileModified(File file) {
        for (ConfigurationListener listener : this.listeners) {
            Log4jThread thread = new Log4jThread(new ReconfigurationWorker(listener, this.reconfigurable));
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static class ReconfigurationWorker
    implements Runnable {
        private final ConfigurationListener listener;
        private final Reconfigurable reconfigurable;

        public ReconfigurationWorker(ConfigurationListener listener, Reconfigurable reconfigurable) {
            this.listener = listener;
            this.reconfigurable = reconfigurable;
        }

        @Override
        public void run() {
            this.listener.onChange(this.reconfigurable);
        }
    }
}

