/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class PaxLoggerImpl
implements PaxLogger {
    private ExtendedLogger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private BundleRevision m_bundleRevision;
    private Long m_bundleId;
    private String m_bundleSymbolicName;
    private String m_bundleVersion;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, ExtendedLogger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public void setDelegate(ExtendedLogger m_delegate) {
        this.m_delegate = m_delegate;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            for (Map.Entry entry : context.entrySet()) {
                this.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.m_bundle != null) {
            BundleRevision rev = (BundleRevision)this.m_bundle.adapt(BundleRevision.class);
            if (rev != this.m_bundleRevision) {
                this.m_bundleId = this.m_bundle.getBundleId();
                this.m_bundleSymbolicName = this.m_bundle.getSymbolicName();
                this.m_bundleVersion = this.m_bundle.getVersion().toString();
                this.m_bundleRevision = rev;
            }
            this.put("bundle.id", this.m_bundleId);
            this.put("bundle.name", this.m_bundleSymbolicName);
            this.put("bundle.version", this.m_bundleVersion);
        }
    }

    private void put(String name, Object o) {
        if (o != null) {
            ThreadContext.put(name, o.toString());
        }
    }

    private void clearDelegateContext() {
        ThreadContext.clearMap();
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.TRACE, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.DEBUG, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.INFO, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.WARN, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.ERROR, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(this.m_fqcn, Level.FATAL, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.TRACE, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.DEBUG, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
        }
    }

    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.INFO, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
        }
    }

    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.WARN, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
        }
    }

    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.ERROR, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.setDelegateContext();
            Message msg = this.m_delegate.getMessageFactory().newMessage(message);
            this.m_delegate.logMessage(fqcn, Level.FATAL, null, msg, t);
            this.clearDelegateContext();
            this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
        }
    }

    public int getLogLevel() {
        switch (this.m_delegate.getLevel().getStandardLevel()) {
            case TRACE: {
                return 0;
            }
            case DEBUG: {
                return 1;
            }
            case INFO: {
                return 2;
            }
            case WARN: {
                return 3;
            }
        }
        return 4;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

