/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.core.async.DaemonThreadFactory;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventHandler;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.status.StatusLogger;

class AsyncLoggerDisruptor {
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private volatile Disruptor<RingBufferLogEvent> disruptor;
    private ExecutorService executor;
    private String contextName;
    private boolean useThreadLocalTranslator;
    private long backgroundThreadId;

    AsyncLoggerDisruptor(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    Disruptor<RingBufferLogEvent> getDisruptor() {
        return this.disruptor;
    }

    synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor not starting new disruptor for this context, using existing object.", this.contextName);
            return;
        }
        LOGGER.trace("[{}] AsyncLoggerDisruptor creating new disruptor for this context.", this.contextName);
        int ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLogger.RingBufferSize");
        WaitStrategy waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLogger.WaitStrategy");
        this.executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("AsyncLogger[" + this.contextName + "]"));
        this.backgroundThreadId = DisruptorUtil.getExecutorThreadId(this.executor);
        this.disruptor = new Disruptor((EventFactory)RingBufferLogEvent.FACTORY, ringBufferSize, (Executor)this.executor, ProducerType.MULTI, waitStrategy);
        ExceptionHandler<RingBufferLogEvent> errorHandler = DisruptorUtil.getExceptionHandler("AsyncLogger.ExceptionHandler", RingBufferLogEvent.class);
        this.disruptor.handleExceptionsWith(errorHandler);
        RingBufferLogEventHandler[] handlers = new RingBufferLogEventHandler[]{new RingBufferLogEventHandler()};
        this.disruptor.handleEventsWith((EventHandler[])handlers);
        LOGGER.debug("[{}] Starting AsyncLogger disruptor for this context with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", this.contextName, this.disruptor.getRingBuffer().getBufferSize(), waitStrategy.getClass().getSimpleName(), errorHandler);
        this.disruptor.start();
        LOGGER.trace("[{}] AsyncLoggers use a {} translator", this.contextName, this.useThreadLocalTranslator ? "threadlocal" : "vararg");
    }

    synchronized void stop() {
        Disruptor<RingBufferLogEvent> temp = this.getDisruptor();
        if (temp == null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor for this context already shut down.", this.contextName);
            return;
        }
        LOGGER.debug("[{}] AsyncLoggerDisruptor: shutting down disruptor for this context.", this.contextName);
        this.disruptor = null;
        for (int i = 0; AsyncLoggerDisruptor.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        temp.shutdown();
        LOGGER.trace("[{}] AsyncLoggerDisruptor: shutting down disruptor executor.", this.contextName);
        this.executor.shutdown();
        this.executor = null;
    }

    private static boolean hasBacklog(Disruptor<?> theDisruptor) {
        RingBuffer ringBuffer = theDisruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    public RingBufferAdmin createRingBufferAdmin(String jmxContextName) {
        RingBuffer ring = this.disruptor == null ? null : this.disruptor.getRingBuffer();
        return RingBufferAdmin.forAsyncLogger(ring, jmxContextName);
    }

    boolean shouldLogInCurrentThread() {
        return this.currentThreadIsAppenderThread() && this.isRingBufferFull();
    }

    private boolean currentThreadIsAppenderThread() {
        return Thread.currentThread().getId() == this.backgroundThreadId;
    }

    private boolean isRingBufferFull() {
        Disruptor<RingBufferLogEvent> theDisruptor = this.disruptor;
        return theDisruptor == null || theDisruptor.getRingBuffer().remainingCapacity() == 0L;
    }

    void enqueueLogMessageInfo(RingBufferLogEventTranslator translator) {
        try {
            this.disruptor.publishEvent((EventTranslator)translator);
        }
        catch (NullPointerException npe) {
            LOGGER.fatal("[{}] Ignoring log event after log4j was shut down.", this.contextName);
        }
    }

    public boolean isUseThreadLocals() {
        return this.useThreadLocalTranslator;
    }

    public void setUseThreadLocals(boolean allow) {
        this.useThreadLocalTranslator = allow;
    }
}

