/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class ThreadContextStackResolver
implements EventResolver {
    private final Pattern itemPattern;

    ThreadContextStackResolver(TemplateResolverConfig config) {
        this.itemPattern = Optional.ofNullable(config.getString("pattern")).map(Pattern::compile).orElse(null);
    }

    static String getName() {
        return "ndc";
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        ThreadContext.ContextStack contextStack = logEvent.getContextStack();
        return contextStack.getDepth() > 0;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        ThreadContext.ContextStack contextStack = logEvent.getContextStack();
        if (contextStack.getDepth() == 0) {
            jsonWriter.writeNull();
            return;
        }
        boolean arrayStarted = false;
        for (String contextStackItem : contextStack.asList()) {
            boolean matched = this.itemPattern == null || this.itemPattern.matcher(contextStackItem).matches();
            if (!matched) continue;
            if (arrayStarted) {
                jsonWriter.writeSeparator();
            } else {
                jsonWriter.writeArrayStart();
                arrayStarted = true;
            }
            jsonWriter.writeString(contextStackItem);
        }
        if (arrayStarted) {
            jsonWriter.writeArrayEnd();
        } else {
            jsonWriter.writeNull();
        }
    }
}

