/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class StatusConsoleListener
implements StatusListener {
    private final Lock lock = new ReentrantLock();
    private final Level initialLevel;
    private final PrintStream initialStream;
    private volatile Level level;
    private volatile PrintStream stream;
    private static PaxLogger logger = FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(StatusLogger.class), "log4j2");

    public StatusConsoleListener(Level level) {
        this(level, System.out);
    }

    public StatusConsoleListener(Level level, PrintStream stream) {
        this.initialLevel = this.level = Objects.requireNonNull(level, "level");
        this.initialStream = this.stream = Objects.requireNonNull(stream, "stream");
    }

    public void setLevel(Level level) {
    }

    public void setStream(PrintStream stream) {
        Objects.requireNonNull(stream, "stream");
        if (this.stream != stream) {
            PrintStream oldStream = null;
            this.lock.lock();
            try {
                if (this.stream != stream) {
                    oldStream = this.stream;
                    this.stream = stream;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (oldStream != null) {
                StatusConsoleListener.closeNonSystemStream(oldStream);
            }
        }
    }

    @Override
    public Level getStatusLevel() {
        switch (logger.getLogLevel()) {
            case 0: {
                return Level.TRACE;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.ERROR;
            }
            case 5: {
                return Level.FATAL;
            }
            case 6: {
                return Level.OFF;
            }
        }
        return Level.DEBUG;
    }

    @Override
    public void log(StatusData data) {
        Objects.requireNonNull(data, "data");
        StackTraceElement ste = data.getStackTraceElement();
        this.logMessage0(ste == null ? null : ste.getClassName(), data.getLevel(), data.getMarker(), data.getMessage(), data.getThrowable());
        String formattedStatus = data.getFormattedStatus();
        this.stream.println(formattedStatus);
    }

    private void logMessage0(String fqcn, Level level, Marker marker, Message msg, Throwable t) {
        if (level == Level.ALL) {
            logger.trace(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.FATAL) {
            logger.fatal(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.ERROR) {
            logger.error(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.WARN) {
            logger.warn(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.INFO) {
            logger.inform(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.DEBUG) {
            logger.debug(msg.getFormattedMessage(), t, fqcn);
        } else if (level == Level.TRACE) {
            logger.trace(msg.getFormattedMessage(), t, fqcn);
        }
    }

    @Deprecated
    public void setFilters(String ... filters) {
    }

    @Override
    public void close() {
        PrintStream oldStream;
        this.lock.lock();
        try {
            oldStream = this.stream;
            this.stream = this.initialStream;
            this.level = this.initialLevel;
        }
        finally {
            this.lock.unlock();
        }
        StatusConsoleListener.closeNonSystemStream(oldStream);
    }

    private static void closeNonSystemStream(OutputStream stream) {
        if (stream != System.out && stream != System.err) {
            try {
                stream.close();
            }
            catch (IOException error) {
                error.printStackTrace(System.err);
            }
        }
    }
}

