/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jpa.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.bind.JAXBException;
import org.ops4j.pax.jpa.impl.EntityManagerFactoryBuilderImpl;
import org.ops4j.pax.jpa.impl.PersistenceUnitState;
import org.ops4j.pax.jpa.impl.descriptor.PersistenceDescriptorParser;
import org.ops4j.pax.jpa.impl.descriptor.PersistenceUnitInfoImpl;
import org.ops4j.pax.jpa.jaxb.Persistence;
import org.ops4j.pax.swissbox.extender.BundleManifestScanner;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.ops4j.pax.swissbox.extender.ManifestEntry;
import org.ops4j.pax.swissbox.extender.ManifestFilter;
import org.ops4j.pax.swissbox.extender.RegexKeyManifestFilter;
import org.ops4j.pax.swissbox.extender.SynchronousBundleWatcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PersistenceBundleObserver
implements BundleObserver<ManifestEntry> {
    private static Logger log = LoggerFactory.getLogger(PersistenceBundleObserver.class);
    private PersistenceDescriptorParser parser = new PersistenceDescriptorParser();
    private SynchronousBundleWatcher<ManifestEntry> watcher;
    private Map<String, PersistenceUnitInfoImpl> persistenceUnits = new HashMap<String, PersistenceUnitInfoImpl>();
    private List<ServiceReference<PersistenceProvider>> persistenceProviders = new ArrayList<ServiceReference<PersistenceProvider>>();
    private List<ServiceReference<DataSourceFactory>> dataSourceFactories = new ArrayList<ServiceReference<DataSourceFactory>>();

    public synchronized void activate(BundleContext bc) {
        log.debug("starting bundle {}", (Object)bc.getBundle().getSymbolicName());
        RegexKeyManifestFilter manifestFilter = new RegexKeyManifestFilter("Meta-Persistence");
        BundleManifestScanner scanner = new BundleManifestScanner((ManifestFilter)manifestFilter);
        this.watcher = new SynchronousBundleWatcher(bc, (BundleScanner)scanner, new BundleObserver[]{this});
        this.watcher.start();
    }

    public synchronized void deactivate(BundleContext bc) {
        log.debug("stopping bundle {}", (Object)bc.getBundle().getSymbolicName());
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            this.deactivatePersistenceUnit(puInfo);
        }
        this.watcher.stop();
    }

    public synchronized void addingEntries(Bundle bundle, List<ManifestEntry> entries) {
        log.info("discovered persistence bundle {}_{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        ManifestEntry entry = entries.get(0);
        List<URL> resources = this.parseMetaPersistenceHeader(bundle, entry.getValue());
        for (URL resource : resources) {
            this.processPersistenceDescriptor(bundle, resource);
        }
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (puInfo.getProvider() == null && this.canAssign(puInfo)) {
                this.assignPersistenceUnit(puInfo);
            }
            if (puInfo.getDataSourceFactory() != null || !this.canComplete(puInfo) || puInfo.getProvider() == null) continue;
            this.activatePersistenceUnit(puInfo);
        }
    }

    public synchronized void removingEntries(Bundle bundle, List<ManifestEntry> entries) {
        log.info("removed persistence bundle {}_{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (!puInfo.getBundle().equals(bundle)) continue;
            this.persistenceUnits.remove(puInfo.getPersistenceUnitName());
        }
    }

    public synchronized void addPersistenceProvider(ServiceReference<PersistenceProvider> persistenceProvider) {
        log.debug("adding persistence provider {}", persistenceProvider.getProperty("javax.persistence.provider"));
        this.persistenceProviders.add(persistenceProvider);
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (puInfo.getProvider() != null || !this.canAssign(puInfo)) continue;
            this.assignPersistenceUnit(puInfo);
            if (!this.canComplete(puInfo)) continue;
            this.activatePersistenceUnit(puInfo);
        }
    }

    public synchronized void removePersistenceProvider(ServiceReference<PersistenceProvider> persistenceProvider) {
        log.debug("removing persistence provider {}", persistenceProvider.getProperty("javax.persistence.provider"));
        this.persistenceProviders.remove(persistenceProvider);
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (puInfo.getState() == PersistenceUnitState.UNASSIGNED || this.canAssign(puInfo)) continue;
            this.unassignPersistenceUnit(puInfo);
        }
    }

    public synchronized void addDataSourceFactory(ServiceReference<DataSourceFactory> dsf) {
        log.debug("adding data source factory {}", dsf.getProperty("osgi.jdbc.driver.class"));
        this.dataSourceFactories.add(dsf);
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (puInfo.getDataSourceFactory() != null || !this.canComplete(puInfo) || puInfo.getProvider() == null) continue;
            this.activatePersistenceUnit(puInfo);
        }
    }

    public synchronized void removeDataSourceFactory(ServiceReference<DataSourceFactory> dsf) {
        log.debug("removing data source factory {}", dsf.getProperty("osgi.jdbc.driver.class"));
        this.dataSourceFactories.remove(dsf);
        for (PersistenceUnitInfoImpl puInfo : this.persistenceUnits.values()) {
            if (puInfo.getState() != PersistenceUnitState.COMPLETE || this.canComplete(puInfo)) continue;
            this.deactivatePersistenceUnit(puInfo);
        }
    }

    private boolean canAssign(PersistenceUnitInfoImpl puInfo) {
        BundleContext bc = puInfo.getBundle().getBundleContext();
        PersistenceProvider provider = null;
        String providerClassName = puInfo.getPersistenceProviderClassName();
        if (providerClassName == null) {
            if (!this.persistenceProviders.isEmpty()) {
                provider = (PersistenceProvider)bc.getService(this.persistenceProviders.get(0));
                puInfo.setProvider(provider);
                return true;
            }
        } else {
            for (ServiceReference<PersistenceProvider> providerRef : this.persistenceProviders) {
                if (!providerClassName.equals(providerRef.getProperty("javax.persistence.provider"))) continue;
                provider = (PersistenceProvider)bc.getService(providerRef);
                puInfo.setProvider(provider);
                return true;
            }
        }
        puInfo.setProvider(null);
        return false;
    }

    private boolean canComplete(PersistenceUnitInfoImpl puInfo) {
        if (puInfo.hasJndiDataSource()) {
            return true;
        }
        puInfo.setDataSourceFactory(null);
        BundleContext bc = puInfo.getBundle().getBundleContext();
        String driver = puInfo.getProperties().getProperty("javax.persistence.jdbc.driver");
        if (driver == null) {
            return false;
        }
        DataSourceFactory dsf = null;
        for (ServiceReference<DataSourceFactory> dsfRef : this.dataSourceFactories) {
            if (!driver.equals(dsfRef.getProperty("osgi.jdbc.driver.class"))) continue;
            dsf = (DataSourceFactory)bc.getService(dsfRef);
            puInfo.setDataSourceFactory(dsf);
            return true;
        }
        return false;
    }

    private void assignPersistenceUnit(PersistenceUnitInfoImpl puInfo) {
        PersistenceProvider provider = puInfo.getProvider();
        Bundle bundle = puInfo.getBundle();
        EntityManagerFactoryBuilderImpl builder = new EntityManagerFactoryBuilderImpl(puInfo);
        Hashtable<String, String> emfBuilderServiceProps = new Hashtable<String, String>();
        ((Dictionary)emfBuilderServiceProps).put("osgi.unit.name", puInfo.getPersistenceUnitName());
        ((Dictionary)emfBuilderServiceProps).put("osgi.unit.version", bundle.getVersion().toString());
        ((Dictionary)emfBuilderServiceProps).put("osgi.unit.provider", provider.getClass().getName());
        ServiceRegistration builderReg = bundle.getBundleContext().registerService(EntityManagerFactoryBuilder.class, (Object)builder, emfBuilderServiceProps);
        puInfo.setEmfBuilderRegistration((ServiceRegistration<EntityManagerFactoryBuilder>)builderReg);
        puInfo.setState(PersistenceUnitState.READY);
    }

    private void activatePersistenceUnit(PersistenceUnitInfoImpl puInfo) {
        PersistenceProvider provider = puInfo.getProvider();
        Bundle bundle = puInfo.getBundle();
        Properties emfProps = puInfo.getProperties();
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)puInfo, (Map)emfProps);
        Hashtable<String, String> emfServiceProps = new Hashtable<String, String>();
        ((Dictionary)emfServiceProps).put("osgi.unit.name", puInfo.getPersistenceUnitName());
        ((Dictionary)emfServiceProps).put("osgi.unit.version", bundle.getVersion().toString());
        ((Dictionary)emfServiceProps).put("osgi.unit.provider", provider.getClass().getName());
        ServiceRegistration reg = bundle.getBundleContext().registerService(EntityManagerFactory.class, (Object)emf, emfServiceProps);
        puInfo.setEmfRegistration((ServiceRegistration<EntityManagerFactory>)reg);
        puInfo.setState(PersistenceUnitState.COMPLETE);
    }

    private void deactivatePersistenceUnit(PersistenceUnitInfoImpl puInfo) {
        puInfo.unregister();
        puInfo.setDataSourceFactory(null);
        puInfo.setState(PersistenceUnitState.READY);
    }

    private void unassignPersistenceUnit(PersistenceUnitInfoImpl puInfo) {
        puInfo.unregister();
        puInfo.setProvider(null);
        puInfo.setState(PersistenceUnitState.UNASSIGNED);
    }

    private List<URL> parseMetaPersistenceHeader(Bundle bundle, String value) {
        String[] parts;
        URL defaultUrl = bundle.getEntry("META-INF/persistence.xml");
        boolean defaultUrlFound = false;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String part : parts = value.split(",\\s*")) {
            URL url;
            String resource = part.trim();
            if (resource.isEmpty() || (url = bundle.getEntry(resource)) == null) continue;
            urls.add(url);
            if (!url.equals(defaultUrl)) continue;
            defaultUrlFound = true;
        }
        if (defaultUrl != null && !defaultUrlFound) {
            urls.add(0, defaultUrl);
        }
        return urls;
    }

    private void processPersistenceDescriptor(Bundle bundle, URL persistenceXml) {
        try {
            Persistence descriptor = this.parser.parseDescriptor(persistenceXml);
            for (Persistence.PersistenceUnit persistenceUnit : descriptor.getPersistenceUnit()) {
                this.processPersistenceUnit(bundle, descriptor.getVersion(), persistenceUnit);
            }
        }
        catch (JAXBException exc) {
            log.error("cannot parse persistence descriptor", (Throwable)exc);
        }
        catch (IOException exc) {
            log.error("cannot parse persistence descriptor", (Throwable)exc);
        }
        catch (SAXException exc) {
            log.error("cannot parse persistence descriptor", (Throwable)exc);
        }
    }

    private void processPersistenceUnit(Bundle bundle, String version, Persistence.PersistenceUnit persistenceUnit) {
        String puName = persistenceUnit.getName();
        PersistenceUnitInfoImpl puInfo = this.persistenceUnits.get(puName);
        if (puInfo != null) {
            log.error("ignoring persistence unit [{}] from bundle [{}], unit with this name already registered by bundle [{}]", new Object[]{puName, bundle, puInfo.getBundle()});
            return;
        }
        log.info("processing persistence unit {}", (Object)puName);
        Properties puProps = this.parser.parseProperties(persistenceUnit);
        puInfo = new PersistenceUnitInfoImpl(bundle, version, persistenceUnit, puProps);
        this.persistenceUnits.put(puInfo.getPersistenceUnitName(), puInfo);
    }
}

